/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.utils.TextEditUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LeftWhitespacesOffsetTest
extends AbstractCacheBasedTest {
    @Test
    public void spaces() {
        LeftWhitespacesOffsetTest.assertLeftWhitespacesOffset("<a|    |>", "<a|    >");
        LeftWhitespacesOffsetTest.assertLeftWhitespacesOffset("<a |    |>", "<a |    >");
        LeftWhitespacesOffsetTest.assertLeftWhitespacesOffset("<a |b    |>", "<a b|    >");
        LeftWhitespacesOffsetTest.assertLeftWhitespacesOffset("|<a b    |>", "<a b|    >");
    }

    @Test
    public void lineSeparator() {
        LeftWhitespacesOffsetTest.assertLeftWhitespacesOffset("<a|\r\n    |>", "<a|\r\n    >");
        LeftWhitespacesOffsetTest.assertLeftWhitespacesOffset("<a\r\n |    |>", "<a\r\n |    >");
        LeftWhitespacesOffsetTest.assertLeftWhitespacesOffset("<a\r\n |b\r\n    |>", "<a\r\n b|\r\n    >");
        LeftWhitespacesOffsetTest.assertLeftWhitespacesOffset("|<a\r\n b\r\n    |>", "<a\r\n b|\r\n    >");
    }

    @Test
    public void nullOffset() {
        LeftWhitespacesOffsetTest.assertLeftWhitespacesOffset("||<a >", "<a >");
    }

    @Test
    public void noSpaces() {
        LeftWhitespacesOffsetTest.assertLeftWhitespacesOffset("<a|bcd|>", "<abcd|>");
    }

    @Test
    public void getLeftWhitespacesOffsetWithToZero() {
        int offset = TextEditUtils.adjustOffsetWithLeftWhitespaces((int)0, (int)0, (String)"<a>");
        Assertions.assertEquals((int)-1, (int)offset);
        offset = TextEditUtils.adjustOffsetWithLeftWhitespaces((int)1, (int)0, (String)"<a    >");
        Assertions.assertEquals((int)-1, (int)offset);
    }

    @Test
    public void getLeftWhitespacesOffsetWith() {
        int offset = TextEditUtils.adjustOffsetWithLeftWhitespaces((int)0, (int)0, (String)"<a    >");
        Assertions.assertEquals((int)-1, (int)offset);
        offset = TextEditUtils.adjustOffsetWithLeftWhitespaces((int)1, (int)0, (String)"<a    >");
        Assertions.assertEquals((int)-1, (int)offset);
    }

    private static void assertLeftWhitespacesOffset(String textWithRanges, String expectedWithOffset) {
        int leftLimit = textWithRanges.indexOf(124);
        int to = textWithRanges.indexOf(124, leftLimit + 1) - 1;
        StringBuilder text = new StringBuilder();
        text.append(textWithRanges.substring(0, leftLimit));
        text.append(textWithRanges.substring(leftLimit + 1, to + 1));
        text.append(textWithRanges.substring(to + 2, textWithRanges.length()));
        int offset = TextEditUtils.adjustOffsetWithLeftWhitespaces((int)leftLimit, (int)to, (String)text.toString());
        if (offset != -1) {
            text.insert(offset, '|');
        }
        Assertions.assertEquals((Object)expectedWithOffset, (Object)text.toString());
    }
}

