/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.settings;

import java.util.Arrays;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterWhitespaceSettingTest {
    @Test
    public void testTrimTrailingWhitespaceText() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<a>   \ntext     \n    text text text    \n    text\n</a>   ";
        String expected = "<a>\n  text\n  text text text\n  text\n</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 0, "\n  "), XMLAssert.te(1, 4, 2, 4, "\n  "), XMLAssert.te(2, 18, 3, 4, "\n  "), XMLAssert.te(4, 4, 4, 7, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testTrimTrailingWhitespaceTextJoinContentLines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a>   \ntext     \n    text text text    \n    text\n</a>   ";
        String expected = "<a> text text text text text </a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 0, " "), XMLAssert.te(1, 4, 2, 4, " "), XMLAssert.te(2, 18, 3, 4, " "), XMLAssert.te(3, 8, 4, 0, " "), XMLAssert.te(4, 4, 4, 7, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testTrimTrailingWhitespaceTextPreserveEmptyContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        settings.getFormattingSettings().setPreserveSpace(Arrays.asList("a"));
        String content = "<a>   \ntext     \n    text text text    \n    text\n</a>   ";
        String expected = "<a>\ntext\n    text text text\n    text\n</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 0, 6, ""), XMLAssert.te(1, 4, 1, 9, ""), XMLAssert.te(2, 18, 2, 22, ""), XMLAssert.te(4, 4, 4, 7, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testTrimTrailingWhitespaceNewlines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<a>   \n   \n</a>   ";
        String expected = "<a>\n\n</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 2, 0, "\n\n"), XMLAssert.te(2, 4, 2, 7, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testTrimTrailingWhitespaceAtEnd() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<a>   \n</a>      \n   \n       ";
        String expected = "<a>\n</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 0, "\n"), XMLAssert.te(1, 4, 3, 7, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testTrimTrailingWhitespaceAtEndTwoCharLineSeparator() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        String content = "<a>   \r\n</a>\r\n      \r\n   \r\n ";
        String expected = "<a>\r\n</a>\r\n\r\n\r\n";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 0, "\r\n"), XMLAssert.te(2, 0, 2, 6, ""), XMLAssert.te(3, 0, 3, 3, ""), XMLAssert.te(4, 0, 4, 1, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testTrimTrailingWhitespaceAtEndTwoCharLineSeparatorTrimFinalNewlines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        settings.getFormattingSettings().setTrimFinalNewlines(true);
        String content = "<a>   \r\n</a>\r\n      \r\n   \r\n  ";
        String expected = "<a>\r\n</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 0, "\r\n"), XMLAssert.te(1, 4, 4, 2, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testTrimTrailingWhitespaceTextAndNewlines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<a>   \n    \ntext     \n    text text text    \n   \n    text\n        \n</a>   ";
        String expected = "<a>\n\n  text\n  text text text\n\n  text\n\n</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 2, 0, "\n\n  "), XMLAssert.te(2, 4, 3, 4, "\n  "), XMLAssert.te(3, 18, 5, 4, "\n\n  "), XMLAssert.te(5, 8, 7, 0, "\n\n"), XMLAssert.te(7, 4, 7, 7, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testTrimTrailingWhitespaceTextAndNewlinesPreserveEmptyContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        settings.getFormattingSettings().setPreserveSpace(Arrays.asList("a"));
        String content = "<a>   \n    \ntext     \n    text text text    \n   \n    text\n        \n</a>   ";
        String expected = "<a>\n\ntext\n    text text text\n\n    text\n\n</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 0, 6, ""), XMLAssert.te(1, 0, 1, 4, ""), XMLAssert.te(2, 4, 2, 9, ""), XMLAssert.te(3, 18, 3, 22, ""), XMLAssert.te(4, 0, 4, 3, ""), XMLAssert.te(6, 0, 6, 8, ""), XMLAssert.te(7, 4, 7, 7, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testTrimTrailingWhitespaceTextAndNewlinesTwoCharLineSeparator() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<a>   \r\n    \r\ntext     \r\n    text text text    \r\n   \r\n    text\r\n        \r\n</a>   ";
        String expected = "<a>\r\n\r\n  text\r\n  text text text\r\n\r\n  text\r\n\r\n</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 2, 0, "\r\n\r\n  "), XMLAssert.te(2, 4, 3, 4, "\r\n  "), XMLAssert.te(3, 18, 5, 4, "\r\n\r\n  "), XMLAssert.te(5, 8, 7, 0, "\r\n\r\n"), XMLAssert.te(7, 4, 7, 7, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testTrimTrailingWhitespaceWithRange() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<aaa>\r\n  <bbb>\r\n    |asdf               \r\n    asd a;s jlkaj k lk ;alkdsj alskdj a;lskdj a\r\n    a jssa j\r\n    sd asd\r\n    fsdf\r\n    fsd a\r\n    sd f\r\n    asd     \r\n    f as  as\r\n    hjkl    |\r\n  </bbb>\r\n  <ccc>\r\n  </ccc>\r\n</aaa>\r\n";
        String expected = "<aaa>\r\n  <bbb>\r\n    asdf\r\n    asd a;s jlkaj k lk ;alkdsj alskdj a;lskdj a\r\n    a jssa j\r\n    sd asd\r\n    fsdf\r\n    fsd a\r\n    sd f\r\n    asd\r\n    f as as\r\n    hjkl\r\n  </bbb>\r\n  <ccc>\r\n  </ccc>\r\n</aaa>\r\n";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(2, 8, 3, 4, "\r\n    "), XMLAssert.te(9, 7, 10, 4, "\r\n    "), XMLAssert.te(10, 8, 10, 10, " "), XMLAssert.te(11, 8, 11, 12, ""));
    }

    @Test
    public void testTrimTrailingWhitespaceWithRangeSingleCharLineSeparator() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<aaa>\n  <bbb>\n    |asdf               \n    asd a;s jlkaj k lk ;alkdsj alskdj a;lskdj a\n    a jssa j\n    sd asd\n    fsdf\n    fsd a\n    sd f\n    asd     \n    f as  as\n    hjkl    |\n  </bbb>\n  <ccc>\n  </ccc>\n</aaa>\n";
        String expected = "<aaa>\n  <bbb>\n    asdf\n    asd a;s jlkaj k lk ;alkdsj alskdj a;lskdj a\n    a jssa j\n    sd asd\n    fsdf\n    fsd a\n    sd f\n    asd\n    f as as\n    hjkl\n  </bbb>\n  <ccc>\n  </ccc>\n</aaa>\n";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(2, 8, 3, 4, "\n    "), XMLAssert.te(9, 7, 10, 4, "\n    "), XMLAssert.te(10, 8, 10, 10, " "), XMLAssert.te(11, 8, 11, 12, ""));
    }

    @Test
    public void testDontInsertFinalNewLineWithRange() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<div  class = \"foo\">\r\n  |<img  src = \"foo\"|/>\r\n </div>";
        String expected = "<div  class = \"foo\">\r\n  <img src=\"foo\" />\r\n </div>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 1, 8, " "), XMLAssert.te(1, 11, 1, 12, ""), XMLAssert.te(1, 13, 1, 14, ""), XMLAssert.te(1, 19, 1, 19, " "));
    }

    @Test
    public void testInsertFinalNewLineWithRange2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<div  class = \"foo\">\r\n  |<img  src = \"foo\"/>\r\n </div>|";
        String expected = "<div  class = \"foo\">\r\n  <img src=\"foo\" />\r\n</div>\r\n";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 1, 8, " "), XMLAssert.te(1, 11, 1, 12, ""), XMLAssert.te(1, 13, 1, 14, ""), XMLAssert.te(1, 19, 1, 19, " "), XMLAssert.te(1, 21, 2, 1, "\r\n"), XMLAssert.te(2, 7, 2, 7, "\r\n"));
    }

    @Test
    public void testInsertFinalNewLineWithRange3() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<div  class = \"foo\">\r\n  |<img  src = \"foo\"/>\r\n\r\n|\r\n<h1></h1>\r\n </div>";
        String expected = "<div  class = \"foo\">\r\n  <img src=\"foo\" />\r\n\r\n\r\n<h1></h1>\r\n </div>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 1, 8, " "), XMLAssert.te(1, 11, 1, 12, ""), XMLAssert.te(1, 13, 1, 14, ""), XMLAssert.te(1, 19, 1, 19, " "));
    }

    @Test
    public void testDontTrimFinalNewLines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        String content = "<a  ></a>\r\n\r\n\r\n";
        String expected = "<a></a>\r\n\r\n\r\n";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 4, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontTrimFinalNewLines2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        String content = "<a  ></a>\r\n   \r\n\r\n";
        String expected = "<a></a>\r\n   \r\n\r\n";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 4, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontTrimFinalNewLines3() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        String content = "<a  ></a>\r\n  text \r\n  more text   \r\n   \r\n";
        String expected = "<a></a>\r\ntext\r\nmore text   \r\n   \r\n";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 4, ""), XMLAssert.te(0, 9, 1, 2, "\r\n"), XMLAssert.te(1, 6, 2, 2, "\r\n"));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testFormatRemoveFinalNewlinesWithoutTrimTrailing() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(true);
        settings.getFormattingSettings().setTrimTrailingWhitespace(false);
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        String content = "<aaa/>    \r\n\r\n\r\n";
        String expected = "<aaa/>    ";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 10, 3, 0, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testClosingBracketNewLine() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(XMLFormattingOptions.SplitAttributes.splitNewLine);
        settings.getFormattingSettings().setSplitAttributesIndentSize(0);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        String content = "<a b='' c=''/>";
        String expected = "<a" + System.lineSeparator() + "b=''" + System.lineSeparator() + "c=''" + System.lineSeparator() + "/>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 3, System.lineSeparator()), XMLAssert.te(0, 7, 0, 8, System.lineSeparator()), XMLAssert.te(0, 12, 0, 12, System.lineSeparator()));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testClosingBracketNewLineWithDefaultIndentSize() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(XMLFormattingOptions.SplitAttributes.splitNewLine);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        String content = "<a b='b' c='c'/>";
        String expected = "<a" + System.lineSeparator() + "    b='b'" + System.lineSeparator() + "    c='c'" + System.lineSeparator() + "    />";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 3, System.lineSeparator() + "    "), XMLAssert.te(0, 8, 0, 9, System.lineSeparator() + "    "), XMLAssert.te(0, 14, 0, 14, System.lineSeparator() + "    "));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testClosingBracketNewLineWithAlignWithFirstAttr() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(XMLFormattingOptions.SplitAttributes.alignWithFirstAttr);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        String content = "<a b='b' c='c'/>";
        String expected = "<a b='b'" + System.lineSeparator() + "   c='c'" + System.lineSeparator() + "   />";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 9, System.lineSeparator() + "   "), XMLAssert.te(0, 14, 0, 14, System.lineSeparator() + "   "));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testClosingBracketNewLineWithAlignWithFirstAttrNested() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(XMLFormattingOptions.SplitAttributes.alignWithFirstAttr);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        String content = "<a b='b' c='c'>\n  <b c='c' d='d'/>\n</a>";
        String expected = "<a b='b'\n   c='c'\n   >\n  <b c='c'\n     d='d'\n     />\n</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 9, "\n   "), XMLAssert.te(0, 14, 0, 14, "\n   "), XMLAssert.te(1, 10, 1, 11, "\n     "), XMLAssert.te(1, 16, 1, 16, "\n     "));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testClosingBracketNewLineWithoutSplitAttributes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(XMLFormattingOptions.SplitAttributes.preserve);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        String content = "<a b='' c=''/>";
        String expected = "<a b='' c='' />";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 12, 0, 12, " "));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testClosingBracketNewLineWithSingleAttribute() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(XMLFormattingOptions.SplitAttributes.splitNewLine);
        settings.getFormattingSettings().setSplitAttributesIndentSize(0);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        String content = "<a b=''/>";
        String expected = "<a b='' />";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 7, 0, 7, " "));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testClosingBracketNewLineWithChildElementIndent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(XMLFormattingOptions.SplitAttributes.splitNewLine);
        settings.getFormattingSettings().setSplitAttributesIndentSize(0);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        String content = "<a>" + System.lineSeparator() + "  <b c='' d=''/>" + System.lineSeparator() + "</a>";
        String expected = "<a>" + System.lineSeparator() + "  <b" + System.lineSeparator() + "  c=''" + System.lineSeparator() + "  d=''" + System.lineSeparator() + "  />" + System.lineSeparator() + "</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(1, 4, 1, 5, System.lineSeparator() + "  "), XMLAssert.te(1, 9, 1, 10, System.lineSeparator() + "  "), XMLAssert.te(1, 14, 1, 14, System.lineSeparator() + "  "));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testClosingBracketNewLineWithPreserveEmptyContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(XMLFormattingOptions.SplitAttributes.splitNewLine);
        settings.getFormattingSettings().setSplitAttributesIndentSize(0);
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        String content = "<a>" + System.lineSeparator() + "<b c='' d=''></b>" + System.lineSeparator() + "</a>";
        String expected = "<a>" + System.lineSeparator() + "  <b" + System.lineSeparator() + "  c=''" + System.lineSeparator() + "  d=''" + System.lineSeparator() + "  ></b>" + System.lineSeparator() + "</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 0, System.lineSeparator() + "  "), XMLAssert.te(1, 2, 1, 3, System.lineSeparator() + "  "), XMLAssert.te(1, 7, 1, 8, System.lineSeparator() + "  "), XMLAssert.te(1, 12, 1, 12, System.lineSeparator() + "  "));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testClosingBracketNewLineWithPreserveEmptyContentSingleAttribute() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(XMLFormattingOptions.SplitAttributes.splitNewLine);
        settings.getFormattingSettings().setSplitAttributesIndentSize(0);
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        String content = "<a>" + System.lineSeparator() + "<b></b>" + System.lineSeparator() + "</a>";
        String expected = "<a>" + System.lineSeparator() + "  <b></b>" + System.lineSeparator() + "</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 0, System.lineSeparator() + "  "));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterWhitespaceSettingTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterWhitespaceSettingTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

