/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.XMLBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class XMLBuilderTest {
    SharedSettings settings;

    @BeforeEach
    public void startup() {
        this.settings = new SharedSettings();
        this.settings.getFormattingSettings().setInsertSpaces(false);
        this.settings.getFormattingSettings().setTabSize(4);
    }

    @Test
    public void simple() throws Exception {
        String xml = new XMLBuilder(this.settings, "", "\n").startElement("html", true).endElement("html").toString();
        Assertions.assertEquals((Object)"<html></html>", (Object)xml);
    }

    @Test
    public void simpleLinefeed() throws Exception {
        String xml = new XMLBuilder(this.settings, "", "\n").startElement("html", true).linefeed().endElement("html").toString();
        Assertions.assertEquals((Object)"<html>\n</html>", (Object)xml);
    }

    @Test
    public void elementWithChild() throws Exception {
        String xml = new XMLBuilder(this.settings, "", "\n").startElement("html", true).linefeed().indent(1).startElement("head", false).selfCloseElement().linefeed().endElement("html").toString();
        Assertions.assertEquals((Object)"<html>\n\t<head />\n</html>", (Object)xml);
    }
}

