/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.CodeActionRequest;
import org.eclipse.lemminx.services.ResolveCodeActionRequest;
import org.eclipse.lemminx.services.XMLCompletions;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionResolvesParticipant;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XMLCodeActions {
    private static final Logger LOGGER = Logger.getLogger(XMLCompletions.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLCodeActions(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<CodeAction> doCodeActions(CodeActionContext context, Range range, DOMDocument document, SharedSettings sharedSettings, CancelChecker cancelChecker) throws CancellationException {
        cancelChecker.checkCanceled();
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        List diagnostics = context.getDiagnostics();
        if (diagnostics != null) {
            for (Diagnostic diagnostic : diagnostics) {
                if (diagnostic == null) continue;
                for (ICodeActionParticipant codeActionParticipant : this.extensionsRegistry.getCodeActionsParticipants()) {
                    cancelChecker.checkCanceled();
                    try {
                        CodeActionRequest request = new CodeActionRequest(diagnostic, range, document, this.extensionsRegistry, sharedSettings);
                        codeActionParticipant.doCodeAction(request, codeActions, cancelChecker);
                    }
                    catch (CancellationException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Error while processing code actions for the participant '" + codeActionParticipant.getClass().getName() + "'.", e);
                    }
                }
            }
        }
        for (ICodeActionParticipant codeActionParticipant : this.extensionsRegistry.getCodeActionsParticipants()) {
            cancelChecker.checkCanceled();
            try {
                CodeActionRequest request = new CodeActionRequest(null, range, document, this.extensionsRegistry, sharedSettings);
                codeActionParticipant.doCodeActionUnconditional(request, codeActions, cancelChecker);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while processing code actions for the participant '" + codeActionParticipant.getClass().getName() + "'.", e);
            }
        }
        cancelChecker.checkCanceled();
        return codeActions;
    }

    public CodeAction resolveCodeAction(CodeAction unresolved, DOMDocument document, SharedSettings sharedSettings, CancelChecker cancelChecker) throws CancellationException {
        ResolveCodeActionRequest request = new ResolveCodeActionRequest(unresolved, document, this.extensionsRegistry, sharedSettings);
        String participantId = request.getParticipantId();
        if (StringUtils.isEmpty(participantId)) {
            return null;
        }
        for (ICodeActionParticipant codeActionParticipant : this.extensionsRegistry.getCodeActionsParticipants()) {
            try {
                cancelChecker.checkCanceled();
                ICodeActionResolvesParticipant resolveCodeActionParticipant = codeActionParticipant.getResolveCodeActionParticipant(participantId);
                if (resolveCodeActionParticipant == null) continue;
                return resolveCodeActionParticipant.resolveCodeAction(request, cancelChecker);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while processing resolve code action for the participant '" + codeActionParticipant.getClass().getName() + "'.", e);
            }
        }
        return null;
    }
}

