/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.rpmlint.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.internal.rpm.rpmlint.RpmlintLog;
import org.eclipse.linuxtools.internal.rpm.rpmlint.parser.RpmlintItem;
import org.eclipse.linuxtools.internal.rpm.rpmlint.parser.RpmlintParser;
import org.eclipse.linuxtools.rpm.ui.editor.markers.SpecfileErrorHandler;
import org.eclipse.linuxtools.rpm.ui.editor.markers.SpecfileTaskHandler;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParser;

public class RpmlintMarkerVisitor
implements IResourceVisitor {
    private List<RpmlintItem> rpmlintItems;
    private boolean firstWarningInResource;
    private SpecfileParser parser;
    private SpecfileErrorHandler errorHandler;
    private SpecfileTaskHandler taskHandler;

    public RpmlintMarkerVisitor(List<RpmlintItem> rpmlintItems) {
        this.rpmlintItems = rpmlintItems;
        this.parser = new SpecfileParser();
    }

    public boolean visit(IResource resource) throws CoreException {
        block7: {
            block8: {
                if (resource.getType() != 1) break block7;
                if (!"spec".equals(resource.getFileExtension())) break block8;
                this.firstWarningInResource = true;
                for (RpmlintItem item : this.rpmlintItems) {
                    int lineNumber;
                    if (!item.getFileName().equals(resource.getLocation().toOSString())) continue;
                    IFile currentFile = (IFile)resource;
                    if (this.firstWarningInResource) {
                        RpmlintParser.deleteMarkers(resource);
                        currentFile.deleteMarkers("org.eclipse.linuxtools.rpm.ui.editor.specfileerror", false, 0);
                        this.firstWarningInResource = false;
                    }
                    String specContent = RpmlintMarkerVisitor.fileToString(currentFile);
                    if (item.getId().equals("configure-without-libdir-spec")) {
                        item.setLineNbr(-1);
                        lineNumber = RpmlintParser.getRealLineNbr(specContent, "./configure");
                        if (lineNumber == -1) {
                            lineNumber = RpmlintParser.getRealLineNbr(specContent, "%configure");
                        }
                        item.setLineNbr(lineNumber);
                    }
                    if ((lineNumber = item.getLineNbr()) == -1 && (lineNumber = RpmlintParser.getRealLineNbr(specContent, item.getRefferedContent())) == -1) {
                        lineNumber = 1;
                    }
                    --lineNumber;
                    this.parser.setErrorHandler(this.getSpecfileErrorHandler(currentFile, specContent));
                    this.parser.setTaskHandler(this.getSpecfileTaskHandler(currentFile, specContent));
                    this.parser.parse(specContent);
                    Document document = new Document(specContent);
                    int charStart = RpmlintMarkerVisitor.getLineOffset((IDocument)document, lineNumber);
                    int charEnd = charStart + RpmlintMarkerVisitor.getLineLength((IDocument)document, lineNumber);
                    RpmlintParser.addMarker(currentFile, item.getId() + ": " + item.getMessage(), lineNumber, charStart, charEnd, item.getSeverity(), item.getId(), item.getRefferedContent());
                }
                break block7;
            }
            if (!"rpm".equals(resource.getFileExtension())) break block7;
            this.firstWarningInResource = true;
            for (RpmlintItem item : this.rpmlintItems) {
                IFile currentFile = (IFile)resource;
                if (this.firstWarningInResource) {
                    RpmlintParser.deleteMarkers(resource);
                    currentFile.deleteMarkers("org.eclipse.linuxtools.rpm.ui.editor.specfileerror", false, 0);
                    this.firstWarningInResource = false;
                }
                RpmlintParser.addMarker(currentFile, item.getId() + ": " + item.getMessage(), item.getSeverity(), item.getId(), item.getRefferedContent());
            }
        }
        return true;
    }

    private SpecfileErrorHandler getSpecfileErrorHandler(IFile file, String specContent) {
        if (this.errorHandler == null) {
            this.errorHandler = new SpecfileErrorHandler(file, (IDocument)new Document(specContent));
        } else {
            this.errorHandler.setFile(file);
            this.errorHandler.setDocument((IDocument)new Document(specContent));
        }
        return this.errorHandler;
    }

    private SpecfileTaskHandler getSpecfileTaskHandler(IFile file, String specContent) {
        if (this.taskHandler == null) {
            this.taskHandler = new SpecfileTaskHandler(file, (IDocument)new Document(specContent));
        } else {
            this.taskHandler.setFile(file);
            this.taskHandler.setDocument((IDocument)new Document(specContent));
        }
        return this.taskHandler;
    }

    private static int getLineOffset(IDocument document, int lineNumber) {
        try {
            return document.getLineOffset(lineNumber);
        }
        catch (BadLocationException e) {
            RpmlintLog.logError(e);
            return 1;
        }
    }

    private static int getLineLength(IDocument document, int lineNumber) {
        try {
            return document.getLineLength(lineNumber);
        }
        catch (BadLocationException e) {
            RpmlintLog.logError(e);
            return 1;
        }
    }

    private static String fileToString(IFile file) {
        String ret = "";
        try (InputStream in = file.getContents();){
            int nbrOfByte = in.available();
            byte[] bytes = new byte[nbrOfByte];
            in.read(bytes);
            ret = new String(bytes);
        }
        catch (IOException | CoreException e) {
            RpmlintLog.logError(e);
        }
        return ret;
    }
}

