/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swtchart.extensions.core.Messages;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.model.ICustomSeries;

public class CustomSeriesLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    public static final int INDEX_ID = 0;
    public static final int INDEX_DRAW = 1;
    public static final String[] TITLES = new String[]{Messages.getString("ID"), Messages.getString("DRAW"), Messages.getString("LABEL"), Messages.getString("DESCRIPTION")};
    public static final int[] BOUNDS = new int[]{24, 30, 100, 200};

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof ICustomSeries) {
            ICustomSeries customPaintSeries = (ICustomSeries)element;
            if (columnIndex == 0) {
                return ResourceSupport.getImage("seriesMarker.gif");
            }
            if (columnIndex == 1) {
                Image checked = ResourceSupport.getImage("checked.gif");
                Image unchecked = ResourceSupport.getImage("unchecked.gif");
                return customPaintSeries.isDraw() ? checked : unchecked;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof ICustomSeries) {
            ICustomSeries customPaintSeries = (ICustomSeries)element;
            switch (columnIndex) {
                case 0: {
                    text = customPaintSeries.getId();
                    break;
                }
                case 1: {
                    text = "";
                    break;
                }
                case 2: {
                    text = customPaintSeries.getLabel();
                    break;
                }
                case 3: {
                    text = customPaintSeries.getDescription();
                    break;
                }
                default: {
                    text = "";
                }
            }
        }
        return text;
    }
}

