/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.diagram.layout;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;

public class ElkGlobalCoordinates {
    private ElkGlobalCoordinates() {
    }

    public static Point2D.Double getGlobalLocation(ElkShape shape) {
        ElkGraphElement parent = ElkGlobalCoordinates.getParent(shape);
        Point2D.Double _xifexpression = null;
        _xifexpression = parent instanceof ElkShape ? ElkGlobalCoordinates.getGlobalLocation((ElkShape)parent) : new Point2D.Double();
        Point2D.Double anchor = _xifexpression;
        return ElkGlobalCoordinates.translate(anchor, shape.getX(), shape.getY());
    }

    public static Rectangle2D.Double getGlobalBounds(ElkShape shape) {
        Point2D.Double globalLocation = ElkGlobalCoordinates.getGlobalLocation(shape);
        double _width = shape.getWidth();
        double _height = shape.getHeight();
        return new Rectangle2D.Double(globalLocation.x, globalLocation.y, _width, _height);
    }

    public static void setGlobalLocation(ElkShape shape, double x, double y) {
        ElkGraphElement parent = ElkGlobalCoordinates.getParent(shape);
        if (parent instanceof ElkShape) {
            Point2D.Double parentLocation = ElkGlobalCoordinates.getGlobalLocation((ElkShape)parent);
            shape.setLocation(x - parentLocation.x, y - parentLocation.y);
        } else {
            shape.setLocation(x, y);
        }
    }

    public static Point2D.Double getGlobalStartLocation(ElkEdgeSection section) {
        ElkNode container = section.getParent().getContainingNode();
        Point2D.Double _xifexpression = null;
        if (container == null) {
            double _startX = section.getStartX();
            double _startY = section.getStartY();
            _xifexpression = new Point2D.Double(_startX, _startY);
        } else {
            _xifexpression = ElkGlobalCoordinates.translate(ElkGlobalCoordinates.getGlobalLocation((ElkShape)container), section.getStartX(), section.getStartY());
        }
        return _xifexpression;
    }

    public static void setGlobalStartLocation(ElkEdgeSection section, double x, double y) {
        ElkNode container = section.getParent().getContainingNode();
        if (container == null) {
            section.setStartLocation(x, y);
        } else {
            Point2D.Double containerLocation = ElkGlobalCoordinates.getGlobalLocation((ElkShape)container);
            section.setStartLocation(x - containerLocation.x, y - containerLocation.y);
        }
    }

    public static Point2D.Double getGlobalEndLocation(ElkEdgeSection section) {
        ElkNode container = section.getParent().getContainingNode();
        Point2D.Double _xifexpression = null;
        if (container == null) {
            double _endX = section.getEndX();
            double _endY = section.getEndY();
            _xifexpression = new Point2D.Double(_endX, _endY);
        } else {
            _xifexpression = ElkGlobalCoordinates.translate(ElkGlobalCoordinates.getGlobalLocation((ElkShape)container), section.getEndX(), section.getEndY());
        }
        return _xifexpression;
    }

    public static void setGlobalEndLocation(ElkEdgeSection section, double x, double y) {
        ElkNode container = section.getParent().getContainingNode();
        if (container == null) {
            section.setEndLocation(x, y);
        } else {
            Point2D.Double containerLocation = ElkGlobalCoordinates.getGlobalLocation((ElkShape)container);
            section.setEndLocation(x - containerLocation.x, y - containerLocation.y);
        }
    }

    private static ElkGraphElement getParent(ElkShape shape) {
        ElkNode _switchResult = null;
        ElkShape it = shape;
        boolean _matched = false;
        if (it instanceof ElkNode) {
            _matched = true;
            _switchResult = ((ElkNode)it).getParent();
        }
        if (!_matched && it instanceof ElkPort) {
            _matched = true;
            _switchResult = ((ElkPort)it).getParent();
        }
        if (!_matched && it instanceof ElkLabel) {
            _matched = true;
            _switchResult = ((ElkLabel)it).getParent();
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    public static Point2D.Double translate(Point2D.Double point, double deltaX, double deltaY) {
        point.x += deltaX;
        point.y += deltaY;
        return point;
    }

    public static Rectangle2D.Double translate(Rectangle2D.Double bounds, double deltaX, double deltaY) {
        bounds.x += deltaX;
        bounds.y += deltaY;
        return bounds;
    }
}

