/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.log4j.eclipse;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class EclipseLogAppender
extends AppenderSkeleton {
    private static final String DEFAULT_BUNDLE_ID = "org.apache.log4j";
    private String bundleId = null;
    private ILog eclipseLog = null;

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public void activateOptions() {
        if (this.bundleId == null) {
            this.bundleId = DEFAULT_BUNDLE_ID;
        }
        this.eclipseLog = this.getLog(this.bundleId);
        if (this.eclipseLog == null) {
            String errorMsg = String.format("Log4j-appender %s failed to create Eclipse logger for %s: bundle does not exist", this.name, this.bundleId);
            this.bundleId = DEFAULT_BUNDLE_ID;
            this.eclipseLog = this.getLog(this.bundleId);
            if (this.eclipseLog == null) {
                this.errorHandler.error(errorMsg);
            } else {
                Status status = new Status(2, this.bundleId, errorMsg);
                this.eclipseLog.log((IStatus)status);
            }
        } else {
            String msg = "The Eclipse log log4j-appender is successfully installed";
            Status status = new Status(1, this.bundleId, msg);
            this.eclipseLog.log((IStatus)status);
        }
        super.activateOptions();
    }

    public void close() {
        this.closed = true;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void append(LoggingEvent event) {
        int severity = this.getSeverity(event.getLevel());
        Layout layout = this.getLayout();
        String message = layout == null ? event.getRenderedMessage() : layout.format(event);
        Throwable throwable = this.getThrowable(event);
        Status status = new Status(severity, this.bundleId, message, throwable);
        this.eclipseLog.log((IStatus)status);
    }

    private final int getSeverity(Level level) {
        if (level.isGreaterOrEqual((Priority)Level.ERROR)) {
            return 4;
        }
        if (level.isGreaterOrEqual((Priority)Level.WARN)) {
            return 2;
        }
        return 1;
    }

    private final Throwable getThrowable(LoggingEvent event) {
        ThrowableInformation ti = event.getThrowableInformation();
        return ti == null ? null : ti.getThrowable();
    }

    private final ILog getLog(String bundleId) {
        if (bundleId == null) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            return null;
        }
        return Platform.getLog((Bundle)bundle);
    }
}

