/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.algorithms;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.graph.SingleWeightedGraph;

public final class BellmanFord {
    private BellmanFord() {
    }

    private static <V, E, T> Predicate<V> predHasNoSuccessors(SingleWeightedGraph<V, E, T> graph) {
        return v -> graph.outgoingEdgesOf(v).isEmpty();
    }

    public static <V, E> Tuple<Value, List<E>> runBellmanFord(SingleWeightedGraph<V, E, Value> graph, V source) {
        Optional<Tuple<Map<V, Value>, Map<V, V>>> result = BellmanFord.computeDistPrev(graph, source);
        if (!result.isPresent()) {
            return Tuple.of(Value.NEGATIVE_INFINITY, new LinkedList());
        }
        Map dist = result.get().getLeft();
        Map<V, V> prev = result.get().getRight();
        Set endVertices = graph.getVertices().stream().filter(BellmanFord.predHasNoSuccessors(graph)).collect(Collectors.toSet());
        Object target = Collections.min(endVertices, Comparator.comparing(v -> (Value)dist.get(v)));
        LinkedList path = new LinkedList();
        Object u = target;
        while (prev.containsKey(u)) {
            path.add(0, graph.getEdge(prev.get(u), u));
            u = prev.get(u);
        }
        return Tuple.of(dist.get(target), path);
    }

    public static <V, E> Tuple<Value, List<E>> runBellmanFord(SingleWeightedGraph<V, E, Value> graph, V source, V target) {
        Optional<Tuple<Map<V, Value>, Map<V, V>>> result = BellmanFord.computeDistPrev(graph, source);
        if (!result.isPresent()) {
            return Tuple.of(Value.NEGATIVE_INFINITY, new LinkedList());
        }
        Map<V, Value> dist = result.get().getLeft();
        Map<V, V> prev = result.get().getRight();
        LinkedList path = new LinkedList();
        V u = target;
        while (prev.containsKey(u)) {
            path.add(0, graph.getEdge(prev.get(u), u));
            u = prev.get(u);
        }
        return Tuple.of(dist.get(target), path);
    }

    private static <V, E> Optional<Tuple<Map<V, Value>, Map<V, V>>> computeDistPrev(SingleWeightedGraph<V, E, Value> graph, V source) {
        HashMap dist = new HashMap(graph.getVertices().size());
        HashMap prev = new HashMap(graph.getVertices().size());
        for (Object v : graph.getVertices()) {
            dist.put(v, Value.POSITIVE_INFINITY);
            prev.put(v, null);
        }
        dist.put(source, new Value(0.0));
        prev.remove(source);
        int i = 1;
        while (i < graph.getVertices().size()) {
            for (Object edge : graph.getEdges()) {
                Object u = graph.getEdgeSource(edge);
                Object v = graph.getEdgeTarget(edge);
                Value w = graph.getWeight(edge);
                if (!((Value)dist.get(u)).add(w).smallerThan((Value)dist.get(v))) continue;
                dist.put(v, ((Value)dist.get(u)).add(w));
                prev.put(v, u);
            }
            ++i;
        }
        for (Object edge : graph.getEdges()) {
            Object u = graph.getEdgeSource(edge);
            Object v = graph.getEdgeTarget(edge);
            if (!((Value)dist.get(u)).add(graph.getWeight(edge)).smallerThan((Value)dist.get(v))) continue;
            return Optional.empty();
        }
        return Optional.of(Tuple.of(dist, prev));
    }
}

