/**
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.dispatching.teditor.formatting

import com.google.inject.Inject
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter
import org.eclipse.xtext.formatting.impl.FormattingConfig
import org.eclipse.lsat.dispatching.teditor.services.DispatchingGrammarAccess

/**
 * This class contains custom formatting description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#formatting
 * on how and when to use it 
 * 
 * Also see {@link org.eclipse.xtext.xtext.XtextFormattingTokenSerializer} as an example
 */
class DispatchingFormatter extends AbstractDeclarativeFormatter {
	
	@Inject extension DispatchingGrammarAccess
	
	override protected configureFormatting(FormattingConfig c) {
        c.autoLinewrap = 120;
        for(pair: findKeywordPairs('{', '}')) {
            c.setIndentation(pair.first, pair.second)
            c.setLinewrap(1).after(pair.first)
            c.setLinewrap(1).before(pair.second)
            c.setLinewrap(1).after(pair.second)
        }
        for(pair: findKeywordPairs('[', ']')) {
            c.setNoSpace().before(pair.second)
            c.setNoSpace().after(pair.first)
            c.setNoSpace().before(pair.first)
        }
        for(pair: findKeywordPairs('(', ')')) {
            c.setNoSpace().before(pair.second)
            c.setNoSpace().after(pair.first)
            c.setNoSpace().before(pair.first)
        }
        for(doublecolon: findKeywords(':')) {
            c.setNoLinewrap().before(doublecolon)
            c.setNoSpace().before(doublecolon)
        }

        for(delim: findKeywords('=','.')) {
            c.setNoLinewrap().before(delim)
            c.setNoLinewrap().after(delim)
            c.setNoSpace().before(delim)
            c.setNoSpace().after(delim)
        }

        for(comma: findKeywords(',')) {
            c.setNoLinewrap().before(comma)
            c.setNoLinewrap().after(comma)
            c.setNoSpace().before(comma)
        }

        c.setLinewrap(2, 2, 2).before(dispatchGroupRule)
        c.setLinewrap(2, 2, 2).after(dispatchGroupRule)

        c.setLinewrap(1).after(importRule)
        
        c.setLinewrap(1).before(activityDispatchingAccess.throughputKeyword_2_0)
        
        c.setLinewrap(1).before(dispatchRule)
        c.setLinewrap(1).after(dispatchRule)

        c.setLinewrap(1).before(dispatchGroupAccess.yieldKeyword_6_0)
        c.setLinewrap(1).before(dispatchGroupAccess.offsetKeyword_8_0)
        c.setLinewrap(1).before(resourceYieldMapEntryRule)
                    
		c.setLinewrap(0, 1, 2).before(SL_COMMENTRule)
		c.setLinewrap(0, 1, 2).before(ML_COMMENTRule)
		c.setLinewrap(0, 1, 1).after(ML_COMMENTRule)
	}
}
