/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.resource_throughput.ui.editors.internal;

import activity.Move;
import machine.Axis;
import machine.Peripheral;
import machine.impl.MachineQueries;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.lsat.common.emf.common.ui.BigDecimalCellEditor;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputEditingDomain;
import org.eclipse.lsat.timing.util.MoveHelper;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.swt.widgets.Composite;

public class AxisTargetLocationEditingSupport
extends EditingSupport {
    private final ResourceThroughputEditingDomain editingDomain;
    private final CellEditor cellEditor;
    private final String axisName;

    public AxisTargetLocationEditingSupport(ColumnViewer viewer, String axisName, ResourceThroughputEditingDomain editingDomain) {
        super(viewer);
        this.editingDomain = editingDomain;
        this.axisName = axisName;
        this.cellEditor = new BigDecimalCellEditor((Composite)viewer.getControl());
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected MoveHelper getEditorContext(Object element) {
        if (element instanceof Move) {
            Move move = (Move)element;
            Peripheral peripheral = move.getPeripheral();
            Axis axis = MachineQueries.getAxis((Peripheral)peripheral, (String)this.axisName);
            try {
                return new MoveHelper(move, axis, this.editingDomain.getSettings());
            }
            catch (SpecificationException specificationException) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        return this.getEditorContext(element) != null;
    }

    protected Object getValue(Object element) {
        MoveHelper helper = this.getEditorContext(element);
        return helper == null ? null : helper.getValue();
    }

    protected void setValue(Object element, Object value) {
        MoveHelper helper = this.getEditorContext(element);
        if (helper != null) {
            helper.setValue((EditingDomain)this.editingDomain, value);
        }
    }
}

