/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.mpt.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.emf.common.util.URI;

public class ActivityTransformationOptions {
    private final IFile activityFile;
    private final IFile cifFile;
    private final IWorkspace workspace;
    private final String dispatchingFileExtension;

    public ActivityTransformationOptions(IFile activityFile, IFile cifFile, IWorkspace workspace) {
        this(activityFile, cifFile, "", workspace);
    }

    public ActivityTransformationOptions(IFile activityFile, IFile cifFile, String dispatchingFileExtension, IWorkspace workspace) {
        this.activityFile = activityFile;
        this.cifFile = cifFile;
        this.dispatchingFileExtension = dispatchingFileExtension;
        this.workspace = workspace;
    }

    public IFile getActivityFile() {
        return this.activityFile;
    }

    public IFile getCifFile() {
        return this.cifFile;
    }

    public String getActivityFileName() {
        URI activityFileURI = URI.createPlatformResourceURI((String)this.activityFile.getFullPath().toString(), (boolean)true);
        return activityFileURI.trimFileExtension().lastSegment();
    }

    public String getCifFileName() {
        URI cifFileURI = URI.createPlatformResourceURI((String)this.cifFile.getFullPath().toString(), (boolean)true);
        return cifFileURI.trimFileExtension().lastSegment();
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public String getDispatchingFileExtension() {
        return this.dispatchingFileExtension;
    }
}

