/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.format;

import java.util.ConcurrentModificationException;
import java.util.concurrent.Executor;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.ServerMessageHandler;
import org.eclipse.lsp4e.internal.LSPDocumentAbstractHandler;
import org.eclipse.lsp4e.operations.format.LSPFormatter;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPFormatHandler
extends LSPDocumentAbstractHandler {
    private final LSPFormatter formatter = new LSPFormatter();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITextEditor textEditor = UI.getActiveTextEditor();
        if (textEditor == null) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof ITextSelection var4_5 && !textSelection.isEmpty()) {
            IDocument doc = LSPEclipseUtils.getDocument(textEditor);
            if (doc == null) {
                return null;
            }
            try {
                this.formatter.requestFormatting(doc, (ITextSelection)textSelection).thenAcceptAsync(result -> result.ifPresent(edits -> {
                    try {
                        edits.apply();
                    }
                    catch (ConcurrentModificationException ex) {
                        ServerMessageHandler.showMessage(Messages.LSPFormatHandler_DiscardedFormat, new MessageParams(MessageType.Error, Messages.LSPFormatHandler_DiscardedFormatResponse));
                    }
                    catch (BadLocationException e) {
                        LanguageServerPlugin.logError(e);
                    }
                }), (Executor)UI.getDisplay());
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.setEnabled(LSPFormatter::supportsFormatting, this::hasSelection);
    }
}

