/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.linkedediting;

import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerLifecycle;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.operations.linkedediting.LSPLinkedEditingBase;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LSPLinkedEditingReconcilingStrategy
extends LSPLinkedEditingBase
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
ITextViewerLifecycle {
    private ISourceViewer sourceViewer;
    private IDocument fDocument;
    private EditorSelectionChangedListener editorSelectionChangedListener;
    private Job highlightJob;
    private LinkedModeModel linkedModel;

    /*
     * WARNING - void declaration
     */
    public void install(ITextViewer viewer) {
        ITextViewer iTextViewer = viewer;
        if (iTextViewer instanceof ISourceViewer) {
            void thisViewer;
            ISourceViewer iSourceViewer = (ISourceViewer)iTextViewer;
            ISourceViewer cfr_ignored_0 = (ISourceViewer)iTextViewer;
            super.install();
            this.sourceViewer = thisViewer;
            this.editorSelectionChangedListener = new EditorSelectionChangedListener();
            this.editorSelectionChangedListener.install(this.sourceViewer.getSelectionProvider());
        }
    }

    @Override
    public void uninstall() {
        if (this.sourceViewer != null) {
            this.editorSelectionChangedListener.uninstall(this.sourceViewer.getSelectionProvider());
        }
        super.uninstall();
    }

    @Override
    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        super.preferenceChange(event);
        if (event.getKey().equals("org.eclipse.ui.genericeditor.linkedediting") && this.fEnabled) {
            this.initialReconcile();
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        if (this.sourceViewer != null) {
            ISelectionProvider selectionProvider = this.sourceViewer.getSelectionProvider();
            StyledText textWidget = this.sourceViewer.getTextWidget();
            if (textWidget != null && selectionProvider != null) {
                textWidget.getDisplay().asyncExec(() -> {
                    if (!textWidget.isDisposed()) {
                        this.updateLinkedEditing(selectionProvider.getSelection());
                    }
                });
            }
        }
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void reconcile(IRegion partition) {
    }

    /*
     * WARNING - void declaration
     */
    private void updateLinkedEditing(ISelection selection) {
        ISelection iSelection = selection;
        if (iSelection instanceof ITextSelection) {
            void textSelection;
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            ITextSelection cfr_ignored_0 = (ITextSelection)iSelection;
            this.updateLinkedEditing(textSelection.getOffset());
        }
    }

    private void updateLinkedEditing(int offset) {
        if (this.sourceViewer != null && this.fDocument != null && this.fEnabled && this.linkedModel == null || !this.linkedModel.anyPositionContains(offset)) {
            if (this.linkedModel != null) {
                this.linkedModel.exit(1);
                this.linkedModel = null;
            }
            ((CompletableFuture)this.collectLinkedEditingRanges(this.fDocument, offset).thenAcceptAsync(optional -> optional.ifPresent(this::applyLinkedEdit))).exceptionally(e -> {
                LanguageServerPlugin.logError(e);
                return null;
            });
        }
    }

    private void applyLinkedEdit(final LinkedEditingRanges ranges) {
        if (this.highlightJob != null) {
            this.highlightJob.cancel();
        }
        if (ranges == null) {
            return;
        }
        final Pattern pattern = ranges.getWordPattern() != null ? Pattern.compile(ranges.getWordPattern()) : null;
        this.highlightJob = new UIJob("LSP4E Linked Editing"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                LSPLinkedEditingReconcilingStrategy.this.linkedModel = new LinkedModeModel();
                try {
                    LSPLinkedEditingReconcilingStrategy.this.linkedModel.addGroup(LSPLinkedEditingReconcilingStrategy.this.toJFaceGroup(ranges));
                    LSPLinkedEditingReconcilingStrategy.this.linkedModel.forceInstall();
                    ITextSelection selectionBefore = (ITextSelection)LSPLinkedEditingReconcilingStrategy.this.sourceViewer.getSelectionProvider().getSelection();
                    EditorLinkedModeUI linkedMode = new EditorLinkedModeUI(LSPLinkedEditingReconcilingStrategy.this.linkedModel, (ITextViewer)LSPLinkedEditingReconcilingStrategy.this.sourceViewer);
                    linkedMode.setExitPolicy((arg_0, arg_1, arg_2, arg_3) -> this.lambda$0(pattern, (LinkedModeUI)linkedMode, arg_0, arg_1, arg_2, arg_3));
                    linkedMode.enter();
                    LSPLinkedEditingReconcilingStrategy.this.sourceViewer.getSelectionProvider().setSelection((ISelection)selectionBefore);
                    return Status.OK_STATUS;
                }
                catch (BadLocationException ex) {
                    return new Status(4, "org.eclipse.lsp4e", ex.getMessage(), (Throwable)ex);
                }
            }

            private /* synthetic */ LinkedModeUI.ExitFlags lambda$0(Pattern pattern2, LinkedModeUI linkedModeUI, LinkedModeModel model, VerifyEvent event, int offset, int length) {
                Matcher matcher;
                String valuee;
                if (event.character == '\u0000' || event.character == '\b') {
                    return null;
                }
                if (pattern2 != null ? (valuee = LSPLinkedEditingReconcilingStrategy.this.getValueInRange(linkedModeUI.getSelectedRegion(), event, offset, length)) != null && (matcher = pattern2.matcher(valuee)).matches() : Character.isUnicodeIdentifierPart(event.character) || event.character == '_') {
                    return null;
                }
                return new LinkedModeUI.ExitFlags(1, true);
            }
        };
        this.highlightJob.schedule();
    }

    String getValueInRange(IRegion selectedRegion, VerifyEvent event, int offset, int length) {
        if (offset < selectedRegion.getOffset() || offset > selectedRegion.getOffset() + selectedRegion.getLength()) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder(this.fDocument.get(selectedRegion.getOffset(), selectedRegion.getLength()));
            String newChars = event.character == '\u0000' ? "" : Character.toString(event.character);
            sb.replace(offset - selectedRegion.getOffset(), offset - selectedRegion.getOffset() + selectedRegion.getLength(), newChars);
            return sb.toString();
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
    }

    private LinkedPositionGroup toJFaceGroup(@NonNull LinkedEditingRanges ranges) throws BadLocationException {
        LinkedPositionGroup res = new LinkedPositionGroup();
        for (Range range : ranges.getRanges()) {
            int startOffset = LSPEclipseUtils.toOffset(range.getStart(), this.fDocument);
            int length = LSPEclipseUtils.toOffset(range.getEnd(), this.fDocument) - startOffset;
            res.addPosition(new LinkedPosition(this.fDocument, startOffset, length));
        }
        return res;
    }

    class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        EditorSelectionChangedListener() {
        }

        /*
         * WARNING - void declaration
         */
        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            ISelectionProvider iSelectionProvider = selectionProvider;
            if (iSelectionProvider instanceof IPostSelectionProvider) {
                void provider;
                IPostSelectionProvider iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider;
                IPostSelectionProvider cfr_ignored_0 = (IPostSelectionProvider)iSelectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            ISelectionProvider iSelectionProvider = selectionProvider;
            if (iSelectionProvider instanceof IPostSelectionProvider) {
                void provider;
                IPostSelectionProvider iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider;
                IPostSelectionProvider cfr_ignored_0 = (IPostSelectionProvider)iSelectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            LSPLinkedEditingReconcilingStrategy.this.updateLinkedEditing(event.getSelection());
        }
    }
}

