/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.lsp4e.ConnectDocumentToLanguageServerSetupParticipant;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockWorkspaceService;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class WorkspaceFoldersTest
implements Supplier<ServerCapabilities> {
    @Rule
    public AllCleanRule clear = new AllCleanRule(this);
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        MockLanguageServer.INSTANCE.getWorkspaceService().getWorkspaceFoldersEvents().clear();
        this.project = TestUtils.createProject("WorkspaceFoldersTest" + System.currentTimeMillis());
    }

    @Test
    public void testRecycleLSAfterInitialProjectGotDeletedIfWorkspaceFolders() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, c -> true);
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper1.isActive());
        UI.getActivePage().closeAllEditors(false);
        TestUtils.waitForAndAssertCondition(5000, () -> !MockLanguageServer.INSTANCE.isRunning());
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.project = TestUtils.createProject("LanguageServiceAccessorTest2" + System.currentTimeMillis());
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile2);
        wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile2, c -> true);
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        LanguageServerWrapper wrapper2 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper2.isActive());
        Assert.assertTrue((wrapper1 == wrapper2 ? 1 : 0) != 0);
    }

    @Test
    public void testPojectCreate() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, c -> true);
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        ConnectDocumentToLanguageServerSetupParticipant.waitForAll();
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper1.isActive());
        UI.getActivePage().closeAllEditors(false);
        TestUtils.waitForAndAssertCondition(5000, () -> !MockLanguageServer.INSTANCE.isRunning());
        MockWorkspaceService mockWorkspaceService = MockLanguageServer.INSTANCE.getWorkspaceService();
        List events = mockWorkspaceService.getWorkspaceFoldersEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        List added = ((DidChangeWorkspaceFoldersParams)events.get(0)).getEvent().getAdded();
        Assert.assertEquals((long)1L, (long)added.size());
        Assert.assertEquals((Object)new File(this.project.getLocationURI()), (Object)new File(new URI(((WorkspaceFolder)added.get(0)).getUri()).normalize()));
    }

    @Test
    public void testProjectClose() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        LanguageServiceAccessor.getLSWrappers((IFile)testFile1, capabilities -> true).iterator().next();
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        ConnectDocumentToLanguageServerSetupParticipant.waitForAll();
        TestUtils.JobSynchronizer synchronizer = new TestUtils.JobSynchronizer();
        this.project.close((IProgressMonitor)synchronizer);
        synchronizer.await();
        TestUtils.waitForAndAssertCondition(5000, () -> {
            Assert.assertEquals((long)2L, (long)MockLanguageServer.INSTANCE.getWorkspaceService().getWorkspaceFoldersEvents().size());
            return true;
        });
        MockWorkspaceService mockWorkspaceService = MockLanguageServer.INSTANCE.getWorkspaceService();
        List events = mockWorkspaceService.getWorkspaceFoldersEvents();
        Assert.assertEquals((long)2L, (long)events.size());
        List removed = ((DidChangeWorkspaceFoldersParams)events.get(1)).getEvent().getRemoved();
        Assert.assertEquals((long)1L, (long)removed.size());
        Assert.assertEquals((Object)new File(this.project.getLocationURI()), (Object)new File(new URI(((WorkspaceFolder)removed.get(0)).getUri())));
    }

    @Test
    public void testProjectDelete() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, c -> true);
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        ConnectDocumentToLanguageServerSetupParticipant.waitForAll();
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper1.isActive());
        File expected = new File(this.project.getLocationURI());
        TestUtils.JobSynchronizer synchronizer = new TestUtils.JobSynchronizer();
        this.project.delete(true, true, (IProgressMonitor)synchronizer);
        synchronizer.await();
        MockWorkspaceService mockWorkspaceService = MockLanguageServer.INSTANCE.getWorkspaceService();
        List events = mockWorkspaceService.getWorkspaceFoldersEvents();
        Assert.assertEquals((long)2L, (long)events.size());
        List removed = ((DidChangeWorkspaceFoldersParams)events.get(1)).getEvent().getRemoved();
        Assert.assertEquals((long)1L, (long)removed.size());
        Assert.assertEquals((Object)expected, (Object)new File(new URI(((WorkspaceFolder)removed.get(0)).getUri())));
    }

    @Test
    public void testProjectReopen() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        LanguageServiceAccessor.getLSWrappers((IFile)testFile1, capabilities -> true).iterator().next();
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        ConnectDocumentToLanguageServerSetupParticipant.waitForAll();
        TestUtils.JobSynchronizer synchronizer = new TestUtils.JobSynchronizer();
        this.project.close((IProgressMonitor)synchronizer);
        synchronizer.await();
        TestUtils.waitForAndAssertCondition(5000, () -> !this.project.isOpen());
        TestUtils.JobSynchronizer synchronizer2 = new TestUtils.JobSynchronizer();
        this.project.open((IProgressMonitor)synchronizer2);
        synchronizer2.await();
        TestUtils.waitForAndAssertCondition(5000, () -> this.project.isOpen());
        TestUtils.waitForAndAssertCondition(5000, () -> {
            Assert.assertEquals((long)3L, (long)MockLanguageServer.INSTANCE.getWorkspaceService().getWorkspaceFoldersEvents().size());
            return true;
        });
        MockWorkspaceService mockWorkspaceService = MockLanguageServer.INSTANCE.getWorkspaceService();
        List events = mockWorkspaceService.getWorkspaceFoldersEvents();
        List added = ((DidChangeWorkspaceFoldersParams)events.get(2)).getEvent().getAdded();
        Assert.assertEquals((long)1L, (long)added.size());
        Assert.assertEquals((Object)new File(this.project.getLocationURI()), (Object)new File(new URI(((WorkspaceFolder)added.get(0)).getUri())));
    }

    @Override
    public ServerCapabilities get() {
        ServerCapabilities base = MockLanguageServer.defaultServerCapabilities();
        WorkspaceServerCapabilities wsc = new WorkspaceServerCapabilities();
        WorkspaceFoldersOptions wso = new WorkspaceFoldersOptions();
        wso.setSupported(Boolean.valueOf(true));
        wso.setChangeNotifications(Boolean.valueOf(true));
        wsc.setWorkspaceFolders(wso);
        base.setWorkspace(wsc);
        return base;
    }
}

