/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.callhierarchy;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyContentProvider;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyLabelProvider;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyViewTreeNode;
import org.eclipse.lsp4e.ui.views.HierarchyViewInput;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class CallHierarchyView
extends ViewPart {
    public static final String ID = "org.eclipse.lsp4e.callHierarchy.callHierarchyView";
    protected TreeViewer treeViewer;
    private final CallHierarchyContentProvider contentProvider = new CallHierarchyContentProvider();

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new CallHierarchyLabelProvider()));
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getControl().setEnabled(false);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection iSelection = event.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)iSelection;
                    structuredSelection.iterator().forEachRemaining(selectedObject -> {
                        if (selectedObject instanceof CallHierarchyViewTreeNode) {
                            CallHierarchyViewTreeNode selectedNode = (CallHierarchyViewTreeNode)selectedObject;
                            CallHierarchyItem callContainer = selectedNode.getCallContainer();
                            LSPEclipseUtils.open(callContainer.getUri(), selectedNode.getSelectionRange());
                        }
                    });
                }
            }
        });
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void initialize(IDocument document, int offset) {
        HierarchyViewInput viewInput = new HierarchyViewInput(document, offset);
        this.treeViewer.setInput((Object)viewInput);
    }
}

