/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.jdt;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

class LSJavaProposal
implements IJavaCompletionProposal {
    private static final int LS_DEFAULT_RELEVANCE = 18;
    private static final int MAX_BASE_RELEVANCE = 816;
    private static final int DEFAULT_RELEVANCE = 768;
    private static final int RANGE_WITHIN_CATEGORY = Math.round(12.0f);
    protected ICompletionProposal delegate;
    private boolean relevanceComputed = false;
    private int relevance = -1;

    public LSJavaProposal(ICompletionProposal delegate) {
        this.delegate = delegate;
    }

    public void apply(IDocument document) {
        this.delegate.apply(document);
    }

    public @Nullable String getAdditionalProposalInfo() {
        return this.delegate.getAdditionalProposalInfo();
    }

    public @Nullable IContextInformation getContextInformation() {
        return this.delegate.getContextInformation();
    }

    public String getDisplayString() {
        return this.delegate.getDisplayString();
    }

    public @Nullable Image getImage() {
        return this.delegate.getImage();
    }

    public @Nullable Point getSelection(IDocument document) {
        return this.delegate.getSelection(document);
    }

    public int getRelevance() {
        if (!this.relevanceComputed) {
            ICompletionProposal iCompletionProposal = this.delegate;
            if (iCompletionProposal instanceof LSCompletionProposal) {
                LSCompletionProposal c = (LSCompletionProposal)iCompletionProposal;
                this.relevance = this.computeBaseRelevance(c);
                switch (c.getItem().getKind()) {
                    case Class: {
                        this.relevance += 3;
                        break;
                    }
                    case Field: 
                    case Property: {
                        this.relevance += 5;
                        break;
                    }
                    case Method: {
                        this.relevance += 4;
                        break;
                    }
                    case Variable: 
                    case Value: {
                        this.relevance += 6;
                    }
                }
            }
            this.relevanceComputed = true;
        }
        return this.relevance;
    }

    private int computeBaseRelevance(LSCompletionProposal c) {
        int base = 816 - (c.getRankCategory() - 1) * RANGE_WITHIN_CATEGORY;
        int rank = c.getRankScore();
        return base -= rank >= 0 && rank < RANGE_WITHIN_CATEGORY ? rank : RANGE_WITHIN_CATEGORY;
    }
}

