/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.semanticTokens;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.lsp4e.operations.semanticTokens.StyleRangeHolder;
import org.eclipse.lsp4e.operations.semanticTokens.StyleRangeMerger;
import org.eclipse.lsp4e.test.semanticTokens.SemanticTokensTestUtil;
import org.eclipse.lsp4e.test.utils.AbstractTest;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.junit.Assert;
import org.junit.Test;

public class StyleRangeMergerTest
extends AbstractTest {
    @Test
    public void testSemanticHighlightMergesWithExistingStyleRanges() {
        int length = 2;
        Region rangeA = new Region(2, length);
        Region rangeB = new Region(rangeA.getOffset() + length, length);
        Region rangeC = new Region(rangeB.getOffset() + length, length);
        StyleRange backGroundRangeAB = this.aStyleRange(this.span((IRegion)rangeA, (IRegion)rangeB), null, SemanticTokensTestUtil.GREEN, 0);
        StyleRange boldRedStyleRangeBC = this.aStyleRange(this.span((IRegion)rangeB, (IRegion)rangeC), SemanticTokensTestUtil.RED, null, 1);
        List<StyleRange> resultingStyleRanges = this.mergeStyleRanges(new StyleRange[]{backGroundRangeAB}, new StyleRange[]{boldRedStyleRangeBC});
        Assert.assertEquals((Object)this.aStyleRange((IRegion)rangeA, null, SemanticTokensTestUtil.GREEN, 0), (Object)resultingStyleRanges.get(0));
        Assert.assertEquals((Object)this.aStyleRange((IRegion)rangeB, SemanticTokensTestUtil.RED, SemanticTokensTestUtil.GREEN, 1), (Object)resultingStyleRanges.get(1));
        Assert.assertEquals((Object)this.aStyleRange((IRegion)rangeC, SemanticTokensTestUtil.RED, null, 1), (Object)resultingStyleRanges.get(2));
    }

    @Test
    public void testSemanticHighlightUnBoldsExistingStyleRanges() {
        int length = 2;
        Region rangeA = new Region(2, length);
        Region rangeB = new Region(rangeA.getOffset() + length, length);
        Region rangeC = new Region(rangeB.getOffset() + length, length);
        Region rangeD = new Region(rangeC.getOffset() + length, length);
        StyleRange[] existingRanges = new StyleRange[]{this.aStyleRangeWithFontStyle((IRegion)rangeA, 1), this.aStyleRangeWithFontStyle((IRegion)rangeB, 1), this.aStyleRangeWithFontStyle((IRegion)rangeC, 1), this.aStyleRangeWithFontStyle((IRegion)rangeD, 1)};
        StyleRange[] newRanges = new StyleRange[]{this.aStyleRangeWithFontStyle((IRegion)rangeA, 0), this.aStyleRangeWithFontStyle((IRegion)rangeC, 0), this.aStyleRangeWithFontStyle((IRegion)rangeD, 0)};
        List<StyleRange> resultingStyleRanges = this.mergeStyleRanges(existingRanges, newRanges);
        Assert.assertEquals((Object)this.aStyleRangeWithFontStyle((IRegion)rangeA, 0), (Object)resultingStyleRanges.get(0));
        Assert.assertEquals((Object)this.aStyleRangeWithFontStyle((IRegion)rangeB, 1), (Object)resultingStyleRanges.get(1));
        Assert.assertEquals((Object)this.aStyleRangeWithFontStyle((IRegion)rangeC, 0), (Object)resultingStyleRanges.get(2));
        Assert.assertEquals((Object)this.aStyleRangeWithFontStyle((IRegion)rangeD, 0), (Object)resultingStyleRanges.get(3));
    }

    @Test
    public void testSemanticHighlightMergesWithAndUnBoldsExistingStyleRanges() {
        int length = 2;
        Region rangeA = new Region(0, length);
        Region rangeB = new Region(rangeA.getOffset() + length, length);
        Region rangeC = new Region(rangeB.getOffset() + length, length);
        Region rangeD = new Region(rangeC.getOffset() + length, length);
        Region rangeE = new Region(rangeD.getOffset() + length, length);
        Region rangeF = new Region(rangeE.getOffset() + length, length);
        Region rangeG = new Region(rangeF.getOffset() + length, length);
        Region rangeH = new Region(rangeG.getOffset() + length, length);
        Region rangeI = new Region(rangeH.getOffset() + length, length);
        StyleRange[] existingRanges = new StyleRange[]{this.aStyleRange(this.span((IRegion)rangeA, (IRegion)rangeB), SemanticTokensTestUtil.GREEN, null, 1), this.aStyleRange((IRegion)rangeD, null, null, 1), this.aStyleRange(this.span((IRegion)rangeE, (IRegion)rangeF), null, SemanticTokensTestUtil.GREEN, 1), this.aStyleRange((IRegion)rangeG, null, SemanticTokensTestUtil.GREEN, 0), this.aStyleRange((IRegion)rangeH, null, null, 1)};
        StyleRange[] newRanges = new StyleRange[]{this.aStyleRange((IRegion)rangeA, null, SemanticTokensTestUtil.RED, 1), this.aStyleRange(this.span((IRegion)rangeB, (IRegion)rangeE), SemanticTokensTestUtil.RED, null, 0), this.aStyleRange(this.span((IRegion)rangeG, (IRegion)rangeI), null, null, 0)};
        List<StyleRange> resultingStyleRanges = this.mergeStyleRanges(existingRanges, newRanges);
        Assert.assertEquals((Object)this.aStyleRange((IRegion)rangeA, SemanticTokensTestUtil.GREEN, SemanticTokensTestUtil.RED, 1), (Object)resultingStyleRanges.get(0));
        Assert.assertEquals((Object)this.aStyleRange((IRegion)rangeB, SemanticTokensTestUtil.RED, null, 0), (Object)resultingStyleRanges.get(1));
        Assert.assertEquals((Object)this.aStyleRange((IRegion)rangeC, SemanticTokensTestUtil.RED, null, 0), (Object)resultingStyleRanges.get(2));
        Assert.assertEquals((Object)this.aStyleRange((IRegion)rangeD, SemanticTokensTestUtil.RED, null, 0), (Object)resultingStyleRanges.get(3));
        Assert.assertEquals((Object)this.aStyleRange((IRegion)rangeE, SemanticTokensTestUtil.RED, SemanticTokensTestUtil.GREEN, 0), (Object)resultingStyleRanges.get(4));
        Assert.assertEquals((Object)this.aStyleRange((IRegion)rangeF, null, SemanticTokensTestUtil.GREEN, 1), (Object)resultingStyleRanges.get(5));
        Assert.assertEquals((Object)this.aStyleRange((IRegion)rangeG, null, SemanticTokensTestUtil.GREEN, 0), (Object)resultingStyleRanges.get(6));
        Assert.assertEquals((Object)this.aStyleRange((IRegion)rangeH, null, null, 0), (Object)resultingStyleRanges.get(7));
        Assert.assertEquals((Object)this.aStyleRange((IRegion)rangeI, null, null, 0), (Object)resultingStyleRanges.get(8));
    }

    @Test
    public void testSemanticHighlightCombinesItalicAndBoldWithExistingStyleRanges() {
        int length = 2;
        Region rangeA = new Region(0, length);
        Region rangeB = new Region(rangeA.getOffset() + length, length);
        Region rangeC = new Region(rangeB.getOffset() + length, length);
        Region rangeD = new Region(rangeC.getOffset() + length, length);
        StyleRange[] existingRanges = new StyleRange[]{this.aStyleRangeWithFontStyle((IRegion)rangeA, 3), this.aStyleRangeWithFontStyle((IRegion)rangeB, 1), this.aStyleRangeWithFontStyle((IRegion)rangeC, 1), this.aStyleRangeWithFontStyle((IRegion)rangeD, 2)};
        StyleRange[] newRanges = new StyleRange[]{this.aStyleRangeWithFontStyle((IRegion)rangeA, 0), this.aStyleRangeWithFontStyle((IRegion)rangeB, 2), this.aStyleRangeWithFontStyle((IRegion)rangeC, 3), this.aStyleRangeWithFontStyle((IRegion)rangeD, 1)};
        List<StyleRange> resultingStyleRanges = this.mergeStyleRanges(existingRanges, newRanges);
        Assert.assertEquals((Object)this.aStyleRangeWithFontStyle((IRegion)rangeA, 2), (Object)resultingStyleRanges.get(0));
        Assert.assertEquals((Object)this.aStyleRangeWithFontStyle((IRegion)rangeB, 2), (Object)resultingStyleRanges.get(1));
        Assert.assertEquals((Object)this.aStyleRangeWithFontStyle((IRegion)rangeC, 3), (Object)resultingStyleRanges.get(2));
        Assert.assertEquals((Object)this.aStyleRangeWithFontStyle((IRegion)rangeD, 3), (Object)resultingStyleRanges.get(3));
    }

    private List<StyleRange> mergeStyleRanges(StyleRange[] existingRanges, StyleRange[] newRanges) {
        TextPresentation textPresentation = new TextPresentation();
        textPresentation.replaceStyleRanges(existingRanges);
        StyleRangeHolder styleRangeHolder = new StyleRangeHolder();
        styleRangeHolder.saveStyles(List.of(newRanges));
        StyleRangeMerger semanticMergeStrategy = new StyleRangeMerger(true, false);
        semanticMergeStrategy.mergeStyleRanges(textPresentation, styleRangeHolder);
        ArrayList<StyleRange> resultingStyleRanges = new ArrayList<StyleRange>();
        textPresentation.getNonDefaultStyleRangeIterator().forEachRemaining(resultingStyleRanges::add);
        return resultingStyleRanges;
    }

    private StyleRange aStyleRangeWithFontStyle(IRegion region, int fontStyle) {
        return new StyleRange(region.getOffset(), region.getLength(), null, null, fontStyle);
    }

    private StyleRange aStyleRange(IRegion region, Color foreground, Color background, int fontStyle) {
        return new StyleRange(region.getOffset(), region.getLength(), foreground, background, fontStyle);
    }

    private IRegion span(IRegion a, IRegion b) {
        return new Region(a.getOffset(), b.getOffset() + b.getLength() - a.getOffset());
    }
}

