/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.jdt;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.text.java.ISemanticTokensProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.internal.CancellationUtil;
import org.eclipse.lsp4e.jdt.JavaSemanticTokensProcessor;
import org.eclipse.lsp4e.jdt.LanguageServerJdtPlugin;
import org.eclipse.lsp4e.operations.semanticTokens.SemanticTokensClient;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensLegend;

public class LSJavaSemanticTokensProvider
implements ISemanticTokensProvider {
    private static final int TIMEOUT_SEMANTIC_TOKENS = 300;

    public Collection<ISemanticTokensProvider.SemanticToken> computeSemanticTokens(CompilationUnit ast) {
        block8: {
            IPreferenceStore prefStore = LanguageServerPlugin.getDefault().getPreferenceStore();
            LanguageServerJdtPlugin plugin = LanguageServerJdtPlugin.getDefault();
            if (plugin == null) {
                throw new IllegalStateException("Plugin hasn't been started!");
            }
            IPreferenceStore jstPrefStore = plugin.getPreferenceStore();
            if (prefStore.getBoolean("semanticHighlightReconciler.disabled") || !jstPrefStore.getBoolean("semanticHighlightReconciler.java.enabled")) {
                return Collections.emptyList();
            }
            IResource resource = ast.getTypeRoot().getResource();
            if (resource == null) {
                return Collections.emptyList();
            }
            IDocument theDocument = LSPEclipseUtils.getDocument((IResource)resource);
            if (theDocument == null) {
                return Collections.emptyList();
            }
            try {
                return (Collection)((CompletableFuture)SemanticTokensClient.DEFAULT.requestFullSemanticTokens(theDocument, (legend, semanticTokens) -> this.convertTokens((SemanticTokensLegend)legend, theDocument, (SemanticTokens)semanticTokens)).thenApply(o -> o.orElse(Collections.emptyList()))).get(300L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                LanguageServerPlugin.logWarning((String)"Timed out after waiting for %dms for semantic tokens from Language Servers".formatted(300), (Throwable)e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError((Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (CancellationUtil.isRequestCancelledException((Throwable)e)) break block8;
                LanguageServerPlugin.logError((String)"Failed to fetch semantic tokens for '%s' from Language Servers".formatted(resource.getLocation()), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private List<ISemanticTokensProvider.SemanticToken> convertTokens(@Nullable SemanticTokensLegend legend, IDocument theDocument, @Nullable SemanticTokens semanticTokens) {
        if (semanticTokens == null) {
            return Collections.emptyList();
        }
        if (legend == null) {
            return Collections.emptyList();
        }
        return new JavaSemanticTokensProcessor(this::mapToTokenType, p -> {
            try {
                return LSPEclipseUtils.toOffset((Position)p, (IDocument)theDocument);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }).getTokensData(semanticTokens.getData(), legend);
    }

    private ISemanticTokensProvider.TokenType mapToTokenType(String tokeTypeStr) {
        return switch (tokeTypeStr) {
            case "method" -> ISemanticTokensProvider.TokenType.METHOD;
            case "comment" -> ISemanticTokensProvider.TokenType.SINGLE_LINE_COMMENT;
            case "variable" -> ISemanticTokensProvider.TokenType.LOCAL_VARIABLE;
            case "type" -> ISemanticTokensProvider.TokenType.CLASS;
            case "property" -> ISemanticTokensProvider.TokenType.FIELD;
            case "keyword" -> ISemanticTokensProvider.TokenType.KEYWORD;
            case "operator" -> ISemanticTokensProvider.TokenType.OPERATOR;
            case "number" -> ISemanticTokensProvider.TokenType.NUMBER;
            case "string" -> ISemanticTokensProvider.TokenType.STRING;
            case "enum" -> ISemanticTokensProvider.TokenType.ENUM;
            case "class" -> ISemanticTokensProvider.TokenType.CLASS;
            case "macro" -> ISemanticTokensProvider.TokenType.STATIC_METHOD_INVOCATION;
            case "parameter" -> ISemanticTokensProvider.TokenType.PARAMETER_VARIABLE;
            default -> ISemanticTokensProvider.TokenType.DEFAULT;
        };
    }
}

