/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.debugmodel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.jdt.annotation.Nullable;

public class JsonParserWithStringSubstitution {
    private final IStringVariableManager stringVariableManager;

    public JsonParserWithStringSubstitution(IStringVariableManager stringVariableManager) {
        this.stringVariableManager = stringVariableManager;
    }

    public Map<String, @Nullable Object> parseJsonObject(String json) throws IllegalStateException, CoreException {
        JsonElement jsonElement = JsonParser.parseString((String)json);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        return this.processJsonObject(jsonObject);
    }

    public Map<String, Object> parseJsonObjectAndRemoveNulls(String json) throws IllegalStateException, CoreException {
        Map<String, @Nullable Object> map = this.parseJsonObject(json);
        map.values().removeIf(Objects::isNull);
        return map;
    }

    private Map<String, @Nullable Object> processJsonObject(JsonObject jsonObject) throws CoreException {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            resultMap.put(key, this.handleJsonElement(value));
        }
        return resultMap;
    }

    private @Nullable Object handleJsonElement(JsonElement value) throws CoreException {
        if (value.isJsonObject()) {
            return this.processJsonObject(value.getAsJsonObject());
        }
        if (value.isJsonArray()) {
            return this.processJsonArray(value.getAsJsonArray());
        }
        if (value.isJsonPrimitive()) {
            return this.handleJsonPrimitive(value.getAsJsonPrimitive());
        }
        return null;
    }

    private Object handleJsonPrimitive(JsonPrimitive primitive) throws CoreException {
        if (primitive.isString()) {
            return this.stringVariableManager.performStringSubstitution(primitive.getAsString());
        }
        return primitive;
    }

    private Object processJsonArray(JsonArray array) throws CoreException {
        ArrayList<Object> resultArray = new ArrayList<Object>();
        for (JsonElement element : array) {
            resultArray.add(this.handleJsonElement(element));
        }
        return resultArray;
    }
}

