/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import org.eclipse.m2e.wtp.IPackagingConfiguration;
import org.eclipse.m2e.wtp.internal.AntPathMatcher;

public class PackagingConfiguration
implements IPackagingConfiguration {
    String[] packagingIncludes;
    String[] packagingExcludes;
    private AntPathMatcher matcher;

    public PackagingConfiguration(String[] packagingIncludes, String[] packagingExcludes) {
        this.packagingIncludes = this.toPortablePathArray(packagingIncludes);
        this.packagingExcludes = this.toPortablePathArray(packagingExcludes);
        this.matcher = new AntPathMatcher();
    }

    public boolean isPackaged(String virtualPath) {
        int n;
        int n2;
        String[] stringArray;
        if (virtualPath == null) {
            return false;
        }
        virtualPath = this.toPortablePath(virtualPath);
        if (this.packagingIncludes != null) {
            stringArray = this.packagingExcludes;
            n2 = this.packagingExcludes.length;
            n = 0;
            while (n < n2) {
                String excl = stringArray[n];
                if (this.matcher.match(excl, virtualPath)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.packagingIncludes == null || this.packagingIncludes.length == 0) {
            return true;
        }
        stringArray = this.packagingIncludes;
        n2 = this.packagingIncludes.length;
        n = 0;
        while (n < n2) {
            String incl = stringArray[n];
            if (this.matcher.match(incl, virtualPath)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String[] toPortablePathArray(String[] patterns) {
        if (patterns == null) {
            return null;
        }
        String[] newPatterns = new String[patterns.length];
        int i = 0;
        while (i < patterns.length) {
            newPatterns[i] = this.toPortablePath(patterns[i]);
            ++i;
        }
        return newPatterns;
    }

    private String toPortablePath(String path) {
        return path == null ? null : path.replace("\\", "/");
    }
}

