/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.maven.cli.internal.BootstrapCoreExtensionManager;
import org.apache.maven.cli.internal.ExtensionResolutionException;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.internal.extension.model.io.xpp3.CoreExtensionsXpp3Reader;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.scope.internal.MojoExecutionScopeModule;
import org.apache.maven.extension.internal.CoreExports;
import org.apache.maven.extension.internal.CoreExtensionEntry;
import org.apache.maven.session.scope.internal.SessionScopeModule;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.LoggerManager;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.IComponentLookup;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.embedder.ExtensionModule;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

@Component(service={PlexusContainerManager.class})
public class PlexusContainerManager {
    static final String MVN_FOLDER = ".mvn";
    private static final String EXTENSIONS_FILENAME = ".mvn/extensions.xml";
    private static final String CONTAINER_CONFIGURATION_NAME = "maven";
    private static final String MAVEN_EXTENSION_REALM_PREFIX = "maven.ext.";
    private static final String PLEXUS_CORE_REALM = "plexus.core";
    private static final ClassWorld CLASS_WORLD = new ClassWorld("plexus.core", ClassWorld.class.getClassLoader());
    private static final ClassRealm CORE_REALM;
    private static final CoreExtensionEntry CORE_ENTRY;
    private static final AtomicLong REALM_ID_SEQUENCE;
    private PlexusContainer nonRootedContainer;
    private final Map<File, PlexusContainer> containerMap = new HashMap<File, PlexusContainer>();
    @Reference
    private LoggerManager loggerManager;
    @Reference
    private IMavenConfiguration mavenConfiguration;
    @Reference
    private IWorkspace workspace;

    static {
        REALM_ID_SEQUENCE = new AtomicLong();
        try {
            CORE_REALM = CLASS_WORLD.getRealm(PLEXUS_CORE_REALM);
            CORE_ENTRY = CoreExtensionEntry.discoverFrom((ClassRealm)CORE_REALM);
        }
        catch (NoSuchRealmException ex) {
            throw new AssertionError("Should never happen", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    void dispose() {
        Map<File, PlexusContainer> map = this.containerMap;
        synchronized (map) {
            this.containerMap.values().forEach(PlexusContainer::dispose);
            this.containerMap.clear();
            if (this.nonRootedContainer != null) {
                this.nonRootedContainer.dispose();
                this.nonRootedContainer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        Map<File, PlexusContainer> map = this.containerMap;
        synchronized (map) {
            this.containerMap.entrySet().removeIf(entry -> {
                if (!new File((File)entry.getKey(), MVN_FOLDER).isDirectory()) {
                    ((PlexusContainer)entry.getValue()).dispose();
                    return true;
                }
                return false;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlexusContainer aquire() throws Exception {
        Map<File, PlexusContainer> map = this.containerMap;
        synchronized (map) {
            this.cleanup();
            if (this.nonRootedContainer == null) {
                this.nonRootedContainer = PlexusContainerManager.newPlexusContainer(null, this.loggerManager, this.mavenConfiguration);
            }
            return this.nonRootedContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlexusContainer aquire(File basedir) throws Exception {
        File directory = PlexusContainerManager.computeMultiModuleProjectDirectory(basedir);
        if (directory == null) {
            return this.aquire();
        }
        File canonicalDirectory = directory.getCanonicalFile();
        Map<File, PlexusContainer> map = this.containerMap;
        synchronized (map) {
            this.cleanup();
            PlexusContainer plexusContainer = this.containerMap.get(canonicalDirectory);
            if (plexusContainer == null) {
                try {
                    plexusContainer = PlexusContainerManager.newPlexusContainer(canonicalDirectory, this.loggerManager, this.mavenConfiguration);
                    this.containerMap.put(canonicalDirectory, plexusContainer);
                }
                catch (ExtensionResolutionException e) {
                    CoreExtension extension = e.getExtension();
                    throw new PlexusContainerException("can't create plexus container for basedir = " + basedir.getAbsolutePath() + " because the extension " + extension.getGroupId() + ":" + extension.getArtifactId() + ":" + extension.getVersion() + " can't be loaded (defined in " + new File(directory, EXTENSIONS_FILENAME).getAbsolutePath() + ").", (Throwable)e);
                }
            }
            return plexusContainer;
        }
    }

    public IComponentLookup getComponentLookup() {
        try {
            return new PlexusComponentLookup(this.aquire());
        }
        catch (Exception ex) {
            return new ExceptionalLookup(ex);
        }
    }

    public IComponentLookup getComponentLookup(File basedir) {
        try {
            return new PlexusComponentLookup(this.aquire(basedir));
        }
        catch (Exception ex) {
            return new ExceptionalLookup(ex);
        }
    }

    private static DefaultPlexusContainer newPlexusContainer(File multiModuleProjectDirectory, LoggerManager loggerManager, IMavenConfiguration mavenConfiguration) throws Exception {
        List<CoreExtensionEntry> extensions = PlexusContainerManager.loadCoreExtensions(multiModuleProjectDirectory, loggerManager, mavenConfiguration);
        List<File> extClassPath = List.of();
        ClassRealm containerRealm = PlexusContainerManager.setupContainerRealm(extClassPath, extensions);
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(CLASS_WORLD).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName(CONTAINER_CONFIGURATION_NAME);
        HashSet exportedArtifacts = new HashSet(CORE_ENTRY.getExportedArtifacts());
        HashSet exportedPackages = new HashSet(CORE_ENTRY.getExportedPackages());
        for (CoreExtensionEntry extension : extensions) {
            exportedArtifacts.addAll(extension.getExportedArtifacts());
            exportedPackages.addAll(extension.getExportedPackages());
        }
        final CoreExports exports = new CoreExports(containerRealm, exportedArtifacts, exportedPackages);
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)LoggerFactory.getILoggerFactory());
                this.bind(CoreExports.class).toInstance((Object)exports);
            }
        }, new ExtensionModule()});
        container.setLookupRealm(null);
        Thread thread = Thread.currentThread();
        ClassLoader ccl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader((ClassLoader)container.getContainerRealm());
            container.setLoggerManager(loggerManager);
            for (CoreExtensionEntry extension : extensions) {
                container.discoverComponents(extension.getClassRealm(), new Module[]{new SessionScopeModule((PlexusContainer)container), new MojoExecutionScopeModule((PlexusContainer)container)});
            }
        }
        finally {
            thread.setContextClassLoader(ccl);
        }
        return container;
    }

    private static ClassRealm setupContainerRealm(List<File> extClassPath, List<CoreExtensionEntry> extensions) throws Exception {
        if (extClassPath.isEmpty() && extensions.isEmpty()) {
            return CORE_REALM;
        }
        ClassRealm extRealm = CLASS_WORLD.newRealm(MAVEN_EXTENSION_REALM_PREFIX + REALM_ID_SEQUENCE.getAndIncrement(), null);
        extRealm.setParentRealm(CORE_REALM);
        for (File file : extClassPath) {
            extRealm.addURL(file.toURI().toURL());
        }
        int i = extensions.size() - 1;
        while (i >= 0) {
            CoreExtensionEntry entry = extensions.get(i);
            Set exportedPackages = entry.getExportedPackages();
            ClassRealm realm = entry.getClassRealm();
            for (String exportedPackage : exportedPackages) {
                extRealm.importFrom((ClassLoader)realm, exportedPackage);
            }
            if (exportedPackages.isEmpty()) {
                extRealm.importFrom((ClassLoader)realm, realm.getId());
            }
            --i;
        }
        return extRealm;
    }

    private static List<CoreExtensionEntry> loadCoreExtensions(File multiModuleProjectDirectory, LoggerManager loggerManager, IMavenConfiguration mavenConfiguration) throws Exception {
        List extensions;
        if (multiModuleProjectDirectory == null) {
            return Collections.emptyList();
        }
        File extensionsXml = new File(multiModuleProjectDirectory, EXTENSIONS_FILENAME);
        if (!extensionsXml.isFile()) {
            return Collections.emptyList();
        }
        Throwable throwable = null;
        Object var6_6 = null;
        try (FileInputStream is = new FileInputStream(extensionsXml);){
            extensions = new CoreExtensionsXpp3Reader().read((InputStream)is).getExtensions();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (extensions.isEmpty()) {
            return Collections.emptyList();
        }
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(CLASS_WORLD).setRealm(CORE_REALM).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName(CONTAINER_CONFIGURATION_NAME);
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)LoggerFactory.getILoggerFactory());
            }
        }});
        Thread thread = Thread.currentThread();
        ClassLoader ccl = thread.getContextClassLoader();
        try {
            container.setLookupRealm(null);
            container.setLoggerManager(loggerManager);
            thread.setContextClassLoader((ClassLoader)container.getContainerRealm());
            MavenExecutionRequest request = MavenExecutionContext.createExecutionRequest(mavenConfiguration, new PlexusComponentLookup((PlexusContainer)container), MavenPluginActivator.getDefault().getMaven());
            ((MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class)).populateDefaults(request);
            request.setBaseDirectory(multiModuleProjectDirectory);
            request.setMultiModuleProjectDirectory(multiModuleProjectDirectory);
            BootstrapCoreExtensionManager resolver = (BootstrapCoreExtensionManager)container.lookup(BootstrapCoreExtensionManager.class);
            List list = resolver.loadCoreExtensions(request, CORE_ENTRY.getExportedArtifacts(), extensions);
            return list;
        }
        finally {
            thread.setContextClassLoader(ccl);
            container.dispose();
        }
    }

    public static File computeMultiModuleProjectDirectory(File file) {
        if (file == null) {
            return null;
        }
        File basedir = file.isDirectory() ? file : file.getParentFile();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File workspaceRoot = workspace.getRoot().getLocation().toFile();
        File current = basedir;
        while (current != null && !current.equals(workspaceRoot)) {
            if (new File(current, MVN_FOLDER).isDirectory()) {
                return current;
            }
            current = current.getParentFile();
        }
        return null;
    }

    private static final class ExceptionalLookup
    implements IComponentLookup {
        private Exception exception;

        public ExceptionalLookup(Exception exception) {
            this.exception = exception;
        }

        @Override
        public <C> C lookup(Class<C> type) throws CoreException {
            throw this.throwException();
        }

        @Override
        public <C> Collection<C> lookupCollection(Class<C> type) throws CoreException {
            throw this.throwException();
        }

        private CoreException throwException() {
            if (this.exception instanceof CoreException) {
                return (CoreException)((Object)this.exception);
            }
            return new CoreException(Status.error((String)"container creation failed", (Throwable)this.exception));
        }
    }

    private static final class PlexusComponentLookup
    implements IComponentLookup {
        private PlexusContainer container;

        public PlexusComponentLookup(PlexusContainer container) {
            this.container = container;
        }

        @Override
        public <C> C lookup(Class<C> type) throws CoreException {
            try {
                return (C)this.container.lookup(type);
            }
            catch (ComponentLookupException ex) {
                throw new CoreException(Status.error((String)Messages.MavenImpl_error_lookup, (Throwable)ex));
            }
        }

        @Override
        public <C> Collection<C> lookupCollection(Class<C> type) {
            try {
                return this.container.lookupList(type);
            }
            catch (ComponentLookupException ex) {
                return List.of();
            }
        }
    }
}

