/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.equinox.internal.p2.updatesite.SiteBundle;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteIU;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;

public class SiteModel {
    private List<URLEntry> archiveReferences;
    private Map<String, SiteCategory> categories;
    private URLEntry description;
    private List<SiteFeature> features;
    private List<SiteBundle> bundles;
    private List<SiteIU> ius;
    private URI locationURI;
    private String locationURIString;
    private String mirrorsURIString;
    private String statsURIString;
    private String type;
    private URLEntry[] associateSites;
    private String digestURIString;
    private List<String> messageKeys;
    private Map<Locale, Map<String, String>> localizations;
    private List<RepositoryReference> repositoryReferences;
    private List<SiteFeature> statsFeatures;
    private List<SiteBundle> statsBundles;

    public void addArchive(URLEntry archiveReference) {
        if (this.archiveReferences == null) {
            this.archiveReferences = new ArrayList<URLEntry>();
        }
        if (!this.archiveReferences.contains(archiveReference)) {
            this.archiveReferences.add(archiveReference);
        }
    }

    public void addCategory(SiteCategory category) {
        if (this.categories == null) {
            this.categories = new HashMap<String, SiteCategory>();
        }
        if (!this.categories.containsKey(category.getName())) {
            this.categories.put(category.getName(), category);
            if (this.localizations != null && !this.localizations.isEmpty()) {
                category.setLocalizations(this.localizations);
            }
        }
    }

    public void addFeature(SiteFeature featureReference) {
        if (this.features == null) {
            this.features = new ArrayList<SiteFeature>();
        }
        this.features.add(featureReference);
    }

    public void addBundle(SiteBundle bundleReference) {
        if (this.bundles == null) {
            this.bundles = new ArrayList<SiteBundle>();
        }
        this.bundles.add(bundleReference);
    }

    public void addStatsFeature(SiteFeature featureReference) {
        if (this.statsFeatures == null) {
            this.statsFeatures = new ArrayList<SiteFeature>();
        }
        this.statsFeatures.add(featureReference);
    }

    public void addStatsBundle(SiteBundle bundleReference) {
        if (this.statsBundles == null) {
            this.statsBundles = new ArrayList<SiteBundle>();
        }
        this.statsBundles.add(bundleReference);
    }

    public void addIU(SiteIU iu) {
        if (this.ius == null) {
            this.ius = new ArrayList<SiteIU>();
        }
        this.ius.add(iu);
    }

    public void addRepositoryReference(RepositoryReference ref) {
        if (this.repositoryReferences == null) {
            this.repositoryReferences = new ArrayList<RepositoryReference>();
        }
        this.repositoryReferences.add(ref);
    }

    public URLEntry[] getArchives() {
        if (this.archiveReferences == null || this.archiveReferences.size() == 0) {
            return new URLEntry[0];
        }
        return this.archiveReferences.toArray(new URLEntry[0]);
    }

    public URLEntry[] getAssociatedSites() {
        return this.associateSites;
    }

    public SiteCategory[] getCategories() {
        if (this.categories == null || this.categories.size() == 0) {
            return new SiteCategory[0];
        }
        return this.categories.values().toArray(new SiteCategory[0]);
    }

    public SiteCategory getCategory(String name) {
        return this.categories == null ? null : this.categories.get(name);
    }

    public URLEntry getDescription() {
        return this.description;
    }

    public SiteFeature[] getFeatures() {
        if (this.features == null || this.features.size() == 0) {
            return new SiteFeature[0];
        }
        return this.features.toArray(new SiteFeature[0]);
    }

    public SiteBundle[] getBundles() {
        if (this.bundles == null || this.bundles.size() == 0) {
            return new SiteBundle[0];
        }
        return this.bundles.toArray(new SiteBundle[0]);
    }

    public SiteFeature[] getStatsFeatures() {
        if (this.statsFeatures == null || this.statsFeatures.size() == 0) {
            return new SiteFeature[0];
        }
        return this.statsFeatures.toArray(new SiteFeature[0]);
    }

    public SiteBundle[] getStatsBundles() {
        if (this.statsBundles == null || this.statsBundles.size() == 0) {
            return new SiteBundle[0];
        }
        return this.statsBundles.toArray(new SiteBundle[0]);
    }

    public SiteIU[] getIUs() {
        if (this.ius == null || this.ius.size() == 0) {
            return new SiteIU[0];
        }
        return this.ius.toArray(new SiteIU[0]);
    }

    public RepositoryReference[] getRepositoryReferences() {
        if (this.repositoryReferences == null || this.repositoryReferences.size() == 0) {
            return new RepositoryReference[0];
        }
        return this.repositoryReferences.toArray(new RepositoryReference[this.repositoryReferences.size()]);
    }

    public String getStatsURI() {
        return this.statsURIString;
    }

    public Map<Locale, Map<String, String>> getLocalizations() {
        return this.localizations;
    }

    public URI getLocationURI() {
        if (this.locationURI == null && this.locationURIString != null) {
            try {
                this.locationURI = new URI(this.locationURIString);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return this.locationURI;
    }

    public String getLocationURIString() {
        return this.locationURIString;
    }

    public List<String> getMessageKeys() {
        return this.messageKeys;
    }

    public String getMirrorsURI() {
        return this.mirrorsURIString;
    }

    public String getType() {
        return this.type;
    }

    public void setDescription(URLEntry description) {
        this.description = description;
    }

    public void setLocalizations(Map<Locale, Map<String, String>> localizations) {
        this.localizations = localizations;
        if (localizations != null && !localizations.isEmpty() && this.categories != null && !this.categories.isEmpty()) {
            for (SiteCategory category : this.categories.values()) {
                category.setLocalizations(localizations);
            }
        }
    }

    public void setLocationURIString(String locationURIString) {
        this.locationURIString = locationURIString;
    }

    public void setMessageKeys(List<String> keys) {
        this.messageKeys = keys;
    }

    public void setMirrorsURIString(String mirrorsURI) {
        this.mirrorsURIString = mirrorsURI;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAssociateSites(URLEntry[] associateSites) {
        this.associateSites = associateSites;
    }

    public void setDigestURIString(String digestURIString) {
        this.digestURIString = digestURIString;
    }

    public String getDigestURIString() {
        return this.digestURIString;
    }

    public void setStatsURIString(String statsURI) {
        this.statsURIString = statsURI;
    }
}

