/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LatLonPointDistanceFeatureQuery;
import org.apache.lucene.document.LatLonPointDistanceQuery;
import org.apache.lucene.document.LatLonPointQuery;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Circle;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Point;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public class LatLonPoint
extends Field {
    public static final int BYTES = 4;
    public static final FieldType TYPE = new FieldType();

    public void setLocationValue(double latitude, double longitude) {
        byte[] bytes;
        if (this.fieldsData == null) {
            bytes = new byte[8];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        int latitudeEncoded = GeoEncodingUtils.encodeLatitude(latitude);
        int longitudeEncoded = GeoEncodingUtils.encodeLongitude(longitude);
        NumericUtils.intToSortableBytes(latitudeEncoded, bytes, 0);
        NumericUtils.intToSortableBytes(longitudeEncoded, bytes, 4);
    }

    public LatLonPoint(String name, double latitude, double longitude) {
        super(name, TYPE);
        this.setLocationValue(latitude, longitude);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        byte[] bytes = ((BytesRef)this.fieldsData).bytes;
        result.append(GeoEncodingUtils.decodeLatitude(bytes, 0));
        result.append(',');
        result.append(GeoEncodingUtils.decodeLongitude(bytes, 4));
        result.append('>');
        return result.toString();
    }

    private static byte[] encode(double latitude, double longitude) {
        byte[] bytes = new byte[8];
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(latitude), bytes, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(longitude), bytes, 4);
        return bytes;
    }

    private static byte[] encodeCeil(double latitude, double longitude) {
        byte[] bytes = new byte[8];
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitudeCeil(latitude), bytes, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitudeCeil(longitude), bytes, 4);
        return bytes;
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getPointDimensionCount() != 0 && fieldInfo.getPointDimensionCount() != TYPE.pointDimensionCount()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with numDims=" + fieldInfo.getPointDimensionCount() + " but this point type has numDims=" + TYPE.pointDimensionCount() + ", is the field really a LatLonPoint?");
        }
        if (fieldInfo.getPointNumBytes() != 0 && fieldInfo.getPointNumBytes() != TYPE.pointNumBytes()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with bytesPerDim=" + fieldInfo.getPointNumBytes() + " but this point type has bytesPerDim=" + TYPE.pointNumBytes() + ", is the field really a LatLonPoint?");
        }
    }

    public static Query newBoxQuery(String field, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        if (minLatitude == 90.0) {
            return new MatchNoDocsQuery("LatLonPoint.newBoxQuery with minLatitude=90.0");
        }
        if (minLongitude == 180.0) {
            if (maxLongitude == 180.0) {
                return new MatchNoDocsQuery("LatLonPoint.newBoxQuery with minLongitude=maxLongitude=180.0");
            }
            if (maxLongitude < minLongitude) {
                minLongitude = -180.0;
            }
        }
        byte[] lower = LatLonPoint.encodeCeil(minLatitude, minLongitude);
        byte[] upper = LatLonPoint.encode(maxLatitude, maxLongitude);
        if (maxLongitude < minLongitude) {
            BooleanQuery.Builder q = new BooleanQuery.Builder();
            byte[] leftOpen = (byte[])lower.clone();
            NumericUtils.intToSortableBytes(Integer.MIN_VALUE, leftOpen, 4);
            Query left = LatLonPoint.newBoxInternal(field, leftOpen, upper);
            q.add(new BooleanClause(left, BooleanClause.Occur.SHOULD));
            byte[] rightOpen = (byte[])upper.clone();
            NumericUtils.intToSortableBytes(Integer.MAX_VALUE, rightOpen, 4);
            Query right = LatLonPoint.newBoxInternal(field, lower, rightOpen);
            q.add(new BooleanClause(right, BooleanClause.Occur.SHOULD));
            return new ConstantScoreQuery(q.build());
        }
        return LatLonPoint.newBoxInternal(field, lower, upper);
    }

    private static Query newBoxInternal(String field, byte[] min, byte[] max) {
        return new PointRangeQuery(field, min, max, 2){

            @Override
            protected String toString(int dimension, byte[] value) {
                if (dimension == 0) {
                    return Double.toString(GeoEncodingUtils.decodeLatitude(value, 0));
                }
                if (dimension == 1) {
                    return Double.toString(GeoEncodingUtils.decodeLongitude(value, 0));
                }
                throw new AssertionError();
            }
        };
    }

    public static Query newDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        return new LatLonPointDistanceQuery(field, latitude, longitude, radiusMeters);
    }

    public static Query newPolygonQuery(String field, Polygon ... polygons) {
        return LatLonPoint.newGeometryQuery(field, ShapeField.QueryRelation.INTERSECTS, polygons);
    }

    public static Query newGeometryQuery(String field, ShapeField.QueryRelation queryRelation, LatLonGeometry ... latLonGeometries) {
        if (queryRelation == ShapeField.QueryRelation.INTERSECTS && latLonGeometries.length == 1) {
            if (latLonGeometries[0] instanceof Rectangle) {
                Rectangle rect = (Rectangle)latLonGeometries[0];
                return LatLonPoint.newBoxQuery(field, rect.minLat, rect.maxLat, rect.minLon, rect.maxLon);
            }
            if (latLonGeometries[0] instanceof Circle) {
                Circle circle = (Circle)latLonGeometries[0];
                return LatLonPoint.newDistanceQuery(field, circle.getLat(), circle.getLon(), circle.getRadius());
            }
        }
        if (queryRelation == ShapeField.QueryRelation.CONTAINS) {
            return LatLonPoint.makeContainsGeometryQuery(field, latLonGeometries);
        }
        return new LatLonPointQuery(field, queryRelation, latLonGeometries);
    }

    private static Query makeContainsGeometryQuery(String field, LatLonGeometry ... latLonGeometries) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (LatLonGeometry geometry : latLonGeometries) {
            if (!(geometry instanceof Point)) {
                return new MatchNoDocsQuery("Contains LatLonPoint.newGeometryQuery with non-point geometries");
            }
            builder.add(new LatLonPointQuery(field, ShapeField.QueryRelation.CONTAINS, geometry), BooleanClause.Occur.MUST);
        }
        return new ConstantScoreQuery(builder.build());
    }

    public static Query newDistanceFeatureQuery(String field, float weight, double originLat, double originLon, double pivotDistanceMeters) {
        Query query = new LatLonPointDistanceFeatureQuery(field, originLat, originLon, pivotDistanceMeters);
        if (weight != 1.0f) {
            query = new BoostQuery(query, weight);
        }
        return query;
    }

    static {
        TYPE.setDimensions(2, 4);
        TYPE.freeze();
    }
}

