/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.engine;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.engine.DebugHelper;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class ProvisioningContext {
    private IProvisioningAgent agent;
    private URI[] artifactRepositories;
    private final List<IInstallableUnit> extraIUs = Collections.synchronizedList(new ArrayList());
    private URI[] metadataRepositories;
    private final Map<String, String> properties = new HashMap<String, String>();
    private Map<String, URI> referencedArtifactRepositories = null;
    private Map<URI, IArtifactRepository> loadedArtifactRepositories = new HashMap<URI, IArtifactRepository>();
    private Map<URI, IMetadataRepository> loadedMetadataRepositories = new HashMap<URI, IMetadataRepository>();
    private Map<URI, IMetadataRepository> allLoadedMetadataRepositories;
    private Map<URI, IArtifactRepository> allLoadedArtifactRepositories;
    private Set<URI> failedArtifactRepositories = new HashSet<URI>();
    private Set<URI> failedMetadataRepositories = new HashSet<URI>();
    private static final String FILE_PROTOCOL = "file";
    private static final Comparator<URI> LOCAL_FIRST_COMPARATOR = (arg0, arg1) -> {
        String protocol0 = arg0.getScheme();
        String protocol1 = arg1.getScheme();
        if (FILE_PROTOCOL.equals(protocol0) && !FILE_PROTOCOL.equals(protocol1)) {
            return -1;
        }
        if (!FILE_PROTOCOL.equals(protocol0) && FILE_PROTOCOL.equals(protocol1)) {
            return 1;
        }
        return 0;
    };
    public static final String FOLLOW_REPOSITORY_REFERENCES = "org.eclipse.equinox.p2.director.followRepositoryReferences";
    public static final String CHECK_AUTHORITIES = "org.eclipse.equinox.p2.director.checkAuthorities";
    private static final String FOLLOW_ARTIFACT_REPOSITORY_REFERENCES = "org.eclipse.equinox.p2.director.followArtifactRepositoryReferences";
    private static final Comparator<IArtifactKey> ARTIFACT_KEY_COMPARATOR = Comparator.comparing(IArtifactKey::getId).thenComparing(IArtifactKey::getVersion);

    public ProvisioningContext(IProvisioningAgent agent) {
        this.agent = agent;
        this.metadataRepositories = null;
        this.artifactRepositories = null;
        this.setProperty(FOLLOW_ARTIFACT_REPOSITORY_REFERENCES, Boolean.TRUE.toString());
    }

    public IQueryable<IArtifactKey> getArtifactKeys(IProgressMonitor monitor) {
        return QueryUtil.compoundQueryable(this.getLoadedArtifactRepositories(monitor));
    }

    public IQueryable<IArtifactDescriptor> getArtifactDescriptors(IProgressMonitor monitor) {
        List<IArtifactRepository> repos = this.getLoadedArtifactRepositories(monitor);
        ArrayList<IQueryable> descriptorQueryables = new ArrayList<IQueryable>();
        for (IArtifactRepository repo : repos) {
            descriptorQueryables.add(repo.descriptorQueryable());
        }
        return QueryUtil.compoundQueryable(descriptorQueryables);
    }

    public IQueryable<IArtifactRepository> getArtifactRepositories(IProgressMonitor monitor) {
        return new ArtifactRepositoryQueryable(this.getLoadedArtifactRepositories(monitor));
    }

    private List<IArtifactRepository> getLoadedArtifactRepositories(IProgressMonitor monitor) {
        IArtifactRepositoryManager repoManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.class);
        URI[] repositories = this.artifactRepositories == null ? repoManager.getKnownRepositories(0) : this.artifactRepositories;
        Arrays.sort(repositories, LOCAL_FIRST_COMPARATOR);
        ArrayList<IArtifactRepository> repos = new ArrayList<IArtifactRepository>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length + 1));
        URI[] uRIArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            URI location = uRIArray[n2];
            this.getLoadedRepository(location, repoManager, repos, (IProgressMonitor)sub.split(1));
            if (this.referencedArtifactRepositories != null && location != null) {
                this.referencedArtifactRepositories.remove(location.toString());
            }
            ++n2;
        }
        if (this.referencedArtifactRepositories != null && this.referencedArtifactRepositories.size() > 0 && this.shouldFollowArtifactReferences()) {
            SubMonitor innerSub = SubMonitor.convert((IProgressMonitor)sub.split(1), (int)this.referencedArtifactRepositories.size());
            for (URI referencedURI : this.referencedArtifactRepositories.values()) {
                this.getLoadedRepository(referencedURI, repoManager, repos, (IProgressMonitor)innerSub.split(1));
            }
        }
        return repos;
    }

    private void getLoadedRepository(URI location, IArtifactRepositoryManager repoManager, List<IArtifactRepository> repos, IProgressMonitor monitor) {
        if (this.failedArtifactRepositories.contains(location)) {
            return;
        }
        try {
            IArtifactRepository repository = this.loadedArtifactRepositories.get(location);
            if (repository == null) {
                repository = repoManager.loadRepository(location, monitor);
                this.loadedArtifactRepositories.put(location, repository);
            }
            repos.add(repository);
        }
        catch (ProvisionException provisionException) {
            this.failedArtifactRepositories.add(location);
        }
    }

    private Set<IMetadataRepository> getLoadedMetadataRepositories(IProgressMonitor monitor) {
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
        URI[] repositories = this.metadataRepositories == null ? repoManager.getKnownRepositories(0) : this.metadataRepositories;
        HashMap<String, IMetadataRepository> repos = new HashMap<String, IMetadataRepository>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)repositories.length);
        this.referencedArtifactRepositories = new HashMap<String, URI>();
        URI[] uRIArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            URI repositorie = uRIArray[n2];
            this.loadMetadataRepository(repoManager, repositorie, repos, this.shouldFollowReferences(), (IProgressMonitor)sub.split(1));
            ++n2;
        }
        return new HashSet<IMetadataRepository>(repos.values());
    }

    private void loadMetadataRepository(IMetadataRepositoryManager manager, URI location, Map<String, IMetadataRepository> repos, boolean followMetadataRepoReferences, IProgressMonitor monitor) {
        if (repos.containsKey(location.toString()) || this.failedMetadataRepositories.contains(location)) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IMetadataRepository repository = this.loadedMetadataRepositories.get(location);
        if (repository == null) {
            try {
                repository = manager.loadRepository(location, (IProgressMonitor)subMonitor.split(1));
                this.loadedMetadataRepositories.put(location, repository);
            }
            catch (ProvisionException provisionException) {
                this.failedMetadataRepositories.add(location);
                return;
            }
        }
        repos.put(location.toString(), repository);
        Collection references = repository.getReferences();
        if (!references.isEmpty()) {
            IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.class);
            SubMonitor repoMon = SubMonitor.convert((IProgressMonitor)subMonitor.split(1), (int)references.size());
            for (IRepositoryReference ref : references) {
                try {
                    if (ref.getType() == 0 && followMetadataRepoReferences && this.isEnabled((IRepositoryManager)manager, ref)) {
                        this.loadMetadataRepository(manager, ref.getLocation(), repos, followMetadataRepoReferences, (IProgressMonitor)repoMon.split(1));
                        continue;
                    }
                    if (ref.getType() != 1 || !this.isEnabled((IRepositoryManager)artifactManager, ref)) continue;
                    this.referencedArtifactRepositories.put(ref.getLocation().toString(), ref.getLocation());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    private boolean isEnabled(IRepositoryManager manager, IRepositoryReference reference) {
        return manager.contains(reference.getLocation()) && manager.isEnabled(reference.getLocation()) || !manager.contains(reference.getLocation()) && (reference.getOptions() & 1) == 1;
    }

    private boolean shouldFollowReferences() {
        return Boolean.parseBoolean(this.getProperty(FOLLOW_REPOSITORY_REFERENCES));
    }

    private boolean shouldFollowArtifactReferences() {
        return Boolean.parseBoolean(this.getProperty(FOLLOW_ARTIFACT_REPOSITORY_REFERENCES));
    }

    public IQueryable<IInstallableUnit> getMetadata(IProgressMonitor monitor) {
        return QueryUtil.compoundQueryable(this.getLoadedMetadataRepositories(monitor));
    }

    public Map<URI, Set<IInstallableUnit>> getInstallableUnitSources(Collection<? extends IInstallableUnit> ius, IProgressMonitor monitor) {
        TreeMap<URI, Set<IInstallableUnit>> result = new TreeMap<URI, Set<IInstallableUnit>>();
        Transport transport = (Transport)this.agent.getService(Transport.class);
        for (IMetadataRepository repository : this.getAllLoadedMetadataRepositories(monitor)) {
            if (repository instanceof ICompositeRepository) continue;
            URI location = this.getSecureLocation(repository.getLocation(), transport);
            TreeSet repositoryIUs = new TreeSet(repository.query(QueryUtil.ALL_UNITS, monitor).toUnmodifiableSet());
            repositoryIUs.retainAll(ius);
            result.put(location, repositoryIUs);
        }
        return result;
    }

    private URI getSecureLocation(URI uri, Transport transport) {
        try {
            return transport.getSecureLocation(uri);
        }
        catch (CoreException coreException) {
            return uri;
        }
    }

    private Collection<IMetadataRepository> getAllLoadedMetadataRepositories(IProgressMonitor monitor) {
        if (this.allLoadedMetadataRepositories == null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
            this.getLoadedMetadataRepositories((IProgressMonitor)subMonitor.split(1));
            this.allLoadedMetadataRepositories = this.getAllLoadedRepositories((IRepositoryManager)repoManager, (Map)this.loadedMetadataRepositories, this.failedMetadataRepositories, (IProgressMonitor)subMonitor.split(1));
        }
        return this.allLoadedMetadataRepositories.values();
    }

    private Collection<IArtifactRepository> getAllLoadedArtifactRepositories(IProgressMonitor monitor) {
        if (this.allLoadedArtifactRepositories == null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            IArtifactRepositoryManager repoManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.class);
            this.getLoadedArtifactRepositories((IProgressMonitor)subMonitor.split(1));
            this.allLoadedArtifactRepositories = this.getAllLoadedRepositories((IRepositoryManager)repoManager, (Map)this.loadedArtifactRepositories, this.failedArtifactRepositories, (IProgressMonitor)subMonitor.split(1));
        }
        return this.allLoadedArtifactRepositories.values();
    }

    private <T, R extends IRepository<T>> Map<URI, R> getAllLoadedRepositories(IRepositoryManager<T> manager, Map<URI, R> loadedRepositories, Set<URI> failedRepositories, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)loadedRepositories.size());
        HashMap<URI, R> allLoadedRepositories = new HashMap<URI, R>(loadedRepositories);
        for (IRepository repository : loadedRepositories.values()) {
            this.loadComposites(manager, repository, allLoadedRepositories, failedRepositories, (IProgressMonitor)subMonitor.split(1));
        }
        return allLoadedRepositories;
    }

    /*
     * WARNING - void declaration
     */
    private <T, R extends IRepository<T>> void loadComposites(IRepositoryManager<T> manager, R repository, Map<URI, R> repos, Set<URI> failedRepositories, IProgressMonitor monitor) {
        R r = repository;
        if (r instanceof ICompositeRepository) {
            void composite;
            ICompositeRepository iCompositeRepository = (ICompositeRepository)r;
            ICompositeRepository cfr_ignored_0 = (ICompositeRepository)r;
            List children = composite.getChildren();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)children.size());
            for (URI location : children) {
                this.loadRepository(manager, location, repos, failedRepositories, (IProgressMonitor)subMonitor.split(1));
            }
        }
    }

    private <T, R extends IRepository<T>> void loadRepository(IRepositoryManager<T> manager, URI location, Map<URI, R> repos, Set<URI> failedRepositories, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (this.failedMetadataRepositories.contains(location)) {
            return;
        }
        if (!repos.containsKey(location)) {
            try {
                IRepository repository = manager.loadRepository(location, (IProgressMonitor)subMonitor.split(1));
                repos.put(location, repository);
                this.loadComposites(manager, repository, repos, failedRepositories, (IProgressMonitor)subMonitor.split(1));
            }
            catch (ProvisionException provisionException) {
                this.failedMetadataRepositories.add(location);
            }
        }
    }

    public Map<URI, Set<IArtifactKey>> getArtifactSources(Collection<? extends IArtifactKey> keys, IProgressMonitor monitor) {
        Transport transport = (Transport)this.agent.getService(Transport.class);
        TreeMap<URI, Set<IArtifactKey>> result = new TreeMap<URI, Set<IArtifactKey>>();
        for (IArtifactRepository repository : this.getAllLoadedArtifactRepositories(monitor)) {
            if (repository instanceof ICompositeRepository) continue;
            URI location = this.getSecureLocation(repository.getLocation(), transport);
            for (IArtifactKey iArtifactKey : keys) {
                if (!repository.contains(iArtifactKey)) continue;
                result.computeIfAbsent(location, it -> new TreeSet<IArtifactKey>(ARTIFACT_KEY_COMPARATOR)).add(iArtifactKey);
            }
        }
        return result;
    }

    public List<IInstallableUnit> getExtraInstallableUnits() {
        return this.extraIUs;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setArtifactRepositories(URI ... artifactRepositories) {
        this.artifactRepositories = artifactRepositories;
    }

    public void setMetadataRepositories(URI ... metadataRepositories) {
        this.metadataRepositories = metadataRepositories;
    }

    public void setExtraInstallableUnits(List<IInstallableUnit> extraIUs) {
        this.extraIUs.clear();
        if (extraIUs != null) {
            this.extraIUs.addAll(extraIUs);
        }
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{artifactRepos=" + DebugHelper.formatArray(this.artifactRepositories != null ? Arrays.asList(this.artifactRepositories) : null, true, false));
        buffer.append(", metadataRepos=" + DebugHelper.formatArray(this.metadataRepositories != null ? Arrays.asList(this.metadataRepositories) : null, true, false));
        buffer.append(", properties=" + String.valueOf(this.getProperties()) + "}");
        return buffer.toString();
    }

    class ArtifactRepositoryQueryable
    implements IQueryable<IArtifactRepository> {
        List<IArtifactRepository> repositories;

        ArtifactRepositoryQueryable(List<IArtifactRepository> repositories) {
            this.repositories = repositories;
        }

        public IQueryResult<IArtifactRepository> query(IQuery<IArtifactRepository> query, IProgressMonitor mon) {
            return query.perform(this.repositories.listIterator());
        }

        public boolean contains(IArtifactRepository element) {
            return this.repositories.contains(element);
        }
    }
}

