/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.model.IArray;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@Subject(value="char[]")
@CommandName(value="waste_in_char_arrays")
@Icon(value="/META-INF/icons/waste.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/component_report.html#ref_inspections_component_report__strings")
public class WasteInCharArraysQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument
    public int minimumWaste = 50;

    public IResult execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "DTFJ-PHD");
        ArrayInt result = new ArrayInt();
        Collection<IClass> classes = this.snapshot.getClassesByName("char[]", false);
        if (classes != null) {
            for (IClass clasz : classes) {
                int[] objectIds = clasz.getObjectIds();
                listener.beginTask(Messages.WasteInCharArraysQuery_CheckingCharArrays, objectIds.length / 10);
                int ii = 0;
                while (ii < objectIds.length) {
                    int id;
                    IArray array;
                    int length;
                    if (ii % 10 == 0) {
                        if (listener.isCanceled()) {
                            throw new IProgressListener.OperationCanceledException();
                        }
                        listener.worked(1);
                    }
                    if ((length = (array = (IArray)this.snapshot.getObject(id = objectIds[ii])).getLength()) >= this.minimumWaste && this.hasWaste(id, length)) {
                        result.add(id);
                    }
                    ++ii;
                }
            }
        }
        return new ObjectListResult.Inbound(this.snapshot, result.toArray());
    }

    private boolean hasWaste(int charArrayId, int length) throws SnapshotException {
        int[] inbounds = this.snapshot.getInboundRefererIds(charArrayId);
        ArrayList<Fragment> fragments = null;
        int[] nArray = inbounds;
        int n = inbounds.length;
        int n2 = 0;
        while (n2 < n) {
            Integer count;
            int inbound = nArray[n2];
            if (!this.isString(inbound)) {
                return false;
            }
            IObject string = this.snapshot.getObject(inbound);
            Integer offset = (Integer)string.resolveValue("offset");
            if (offset == null) {
                offset = 0;
            }
            if ((count = (Integer)string.resolveValue("count")) == null) {
                count = length - offset;
            }
            if (length - count < this.minimumWaste) {
                return false;
            }
            if (inbounds.length == 1) {
                return true;
            }
            if (fragments == null) {
                fragments = new ArrayList<Fragment>();
                fragments.add(new Fragment(offset, offset + count));
            } else {
                boolean isMerged = false;
                for (Fragment fragment : fragments) {
                    if (offset >= fragment.start && offset <= fragment.end) {
                        fragment.end = Math.max(offset + count, fragment.end);
                        isMerged = true;
                        break;
                    }
                    if (offset + count < fragment.start || offset + count > fragment.end) continue;
                    fragment.start = offset;
                    fragment.end = Math.max(offset + count, fragment.end);
                    isMerged = true;
                    break;
                }
                if (!isMerged) {
                    fragments.add(new Fragment(offset, offset + count));
                }
            }
            ++n2;
        }
        if (fragments != null) {
            for (Fragment ff : fragments) {
                length -= ff.end - ff.start;
            }
        }
        return length > this.minimumWaste;
    }

    private boolean isString(int inbound) throws SnapshotException {
        IClass clazz = this.snapshot.getClassOf(inbound);
        return "java.lang.String".equals(clazz.getName());
    }

    private static class Fragment {
        int start;
        int end;

        public Fragment(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

