/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql;

import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.oql.compiler.CompilerImpl;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.parser.internal.oql.compiler.Query;
import org.eclipse.mat.parser.internal.oql.parser.OQLParser;
import org.eclipse.mat.parser.internal.oql.parser.ParseException;
import org.eclipse.mat.parser.internal.oql.parser.TokenMgrError;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.snapshot.IOQLQuery;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.OQLParseException;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.PatternUtil;
import org.eclipse.mat.util.SilentProgressListener;
import org.eclipse.mat.util.SimpleMonitor;
import org.eclipse.mat.util.VoidProgressListener;

public class OQLQueryImpl
implements IOQLQuery {
    Query query;
    EvaluationContext ctx;

    private static ArrayInt distinctList(CustomTableResultSet table, IProgressListener listener) {
        LinkedHashSet hs = new LinkedHashSet();
        ArrayInt newrows = new ArrayInt();
        int i = 0;
        for (Object row : table) {
            if (hs.add(row)) {
                newrows.add(i);
            }
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            ++i;
        }
        hs.clear();
        return newrows;
    }

    private static Column buildColumn(Query.SelectItem column, Object columnValue) {
        String name = column.getName();
        if (name == null) {
            name = column.getExpression().toString();
        }
        Class type = columnValue != null ? columnValue.getClass() : Object.class;
        return new Column(name, type).noTotals();
    }

    public static String OQLLiteral(Object subject) {
        if (subject instanceof Character) {
            return "'" + subject + "'";
        }
        if (subject instanceof String) {
            return "\"" + subject + "\"";
        }
        if (subject instanceof Boolean || subject instanceof Integer) {
            return String.valueOf(subject);
        }
        if (subject instanceof Float) {
            float f = ((Float)subject).floatValue();
            if (Float.isFinite(f)) {
                return String.valueOf(f);
            }
            if (f == Float.POSITIVE_INFINITY) {
                return "1E99F";
            }
            if (f == Float.NEGATIVE_INFINITY) {
                return "-1E99F";
            }
            return "0.0F / 0.0F";
        }
        if (subject instanceof Double) {
            double d = (Double)subject;
            if (Double.isFinite(d)) {
                float f1 = (float)d;
                double d2 = d - (double)f1;
                if (d2 == 0.0) {
                    return String.valueOf(String.valueOf(f1)) + "F + 0.0";
                }
                float f2 = (float)d2;
                double d3 = d - ((double)f1 + (double)f2);
                if (d3 == 0.0) {
                    return String.valueOf(String.valueOf(f1)) + "F + " + String.valueOf(f2) + "F";
                }
                float f3 = (float)d3;
                double d4 = d - ((double)f1 + (double)f2 / 1.0 + (double)f3);
                if (d4 == 0.0) {
                    return String.valueOf(String.valueOf(f1)) + "F + " + String.valueOf(f2) + "F + " + String.valueOf(f3) + "F";
                }
                return String.valueOf(String.valueOf(d)) + "D";
            }
            if (d == Double.POSITIVE_INFINITY) {
                return "1.0D / 0.0D";
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return "-1.0D / 0.0D";
            }
            return "0.0D / 0.0D";
        }
        if (subject == null) {
            return "null";
        }
        if (subject instanceof Long) {
            return String.valueOf(Long.toString((Long)subject)) + "L";
        }
        if (subject instanceof IObject) {
            IObject obj = (IObject)subject;
            try {
                return "${snapshot}.getObject(" + Integer.toString(obj.getObjectId()) + ")";
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof SnapshotException) {
                    return "eval((SELECT * FROM OBJECTS 0x" + Long.toHexString(obj.getObjectAddress()) + "))[0]";
                }
                throw e;
            }
        }
        return null;
    }

    public static String OQLforSubject(String select, Object subject, String alias) {
        String from;
        if (subject instanceof IObject) {
            from = "0x" + Long.toHexString(((IObject)subject).getObjectAddress());
        } else {
            String literal = OQLQueryImpl.OQLLiteral(subject);
            if (literal != null) {
                from = "(" + literal + ")";
            } else if (subject instanceof AbstractCustomTableResultSet.RowMap) {
                AbstractCustomTableResultSet.RowMap rm = (AbstractCustomTableResultSet.RowMap)subject;
                StringBuilder buf = new StringBuilder();
                for (Map.Entry<String, Object> e : rm.entrySet()) {
                    boolean quote;
                    Object val = e.getValue();
                    String v1 = val == null ? "(SELECT * FROM \"\")" : OQLQueryImpl.OQLLiteral(val);
                    if (v1 == null) {
                        v1 = OQLQueryImpl.OQLforSubject("*", val, "");
                        if (v1 == null) {
                            return null;
                        }
                        v1 = "(" + v1 + ")";
                    }
                    if (buf.length() == 0) {
                        buf.append("SELECT ");
                    } else {
                        buf.append(", ");
                    }
                    buf.append(v1).append(" AS ");
                    String name = e.getKey();
                    boolean bl = quote = !name.matches("[A-Za-z$_][A-Za-z0-9$_]*");
                    if (quote) {
                        buf.append('\"');
                    }
                    buf.append(name);
                    if (!quote) continue;
                    buf.append('\"');
                }
                buf.append(" FROM OBJECTS (null)");
                from = buf.toString();
                if (select.equals("*")) {
                    return from;
                }
                from = "(" + from + ")";
            } else {
                return null;
            }
        }
        return "SELECT " + select + " FROM OBJECTS " + from + alias;
    }

    public OQLQueryImpl(EvaluationContext parent, Query query) {
        this.init(parent, query);
    }

    public OQLQueryImpl(String queryString) throws OQLParseException {
        try {
            OQLParser p = new OQLParser(new StringReader(queryString));
            p.setCompiler(new CompilerImpl());
            Query query = p.ParseQuery();
            this.init(null, query);
        }
        catch (ParseException e) {
            int line = e.currentToken.next.beginLine;
            int column = e.currentToken.next.beginColumn;
            throw new OQLParseException(e.getMessage(), null, line, column);
        }
        catch (TokenMgrError e) {
            String msg = e.getMessage();
            int line = 1;
            int column = 1;
            Pattern pattern = Pattern.compile("Lexical error at line ([0-9]*), column ([0-9]*)\\..*");
            Matcher matcher = pattern.matcher(msg);
            if (matcher.matches()) {
                line = Integer.parseInt(matcher.group(1));
                column = Integer.parseInt(matcher.group(2));
            }
            throw new OQLParseException(msg, null, line, column);
        }
    }

    private void init(EvaluationContext parent, Query query) {
        this.query = query;
        this.ctx = new EvaluationContext(parent);
        if (query.getFromClause() != null) {
            this.ctx.setAlias(query.getFromClause().getAlias());
        }
    }

    private void initSnapshot(ISnapshot snapshot) {
        this.ctx.setSnapshot(snapshot);
    }

    public Object execute(ISnapshot snapshot, IProgressListener monitor) throws SnapshotException {
        if (snapshot == null) {
            throw new NullPointerException(Messages.OQLQueryImpl_Error_MissingSnapshot);
        }
        this.initSnapshot(snapshot);
        if (monitor == null) {
            monitor = this.ctx.getProgressListener() != null ? new SilentProgressListener(this.ctx.getProgressListener()) : new VoidProgressListener();
        }
        IProgressListener old = this.ctx.getProgressListener();
        this.ctx.setProgressListener((IProgressListener)monitor);
        Object result = this.internalExecute((IProgressListener)monitor);
        this.ctx.setProgressListener(old);
        return result instanceof IntResult ? (Object)((IntResult)result).toArray() : result;
    }

    protected Object internalExecute(IProgressListener monitor) throws SnapshotException {
        CustomTableResultSet rs;
        int[] percentages = new int[1 + (this.query.getUnionQueries() != null ? this.query.getUnionQueries().size() : 0)];
        Arrays.fill(percentages, 100);
        SimpleMonitor listener = new SimpleMonitor(this.query.toString(), monitor, percentages);
        Object result = null;
        result = this.query.getFromClause().getSubSelect() != null ? this.doSubQuery(listener.nextMonitor()) : (this.query.getFromClause().getCall() != null ? this.doMethodCall(listener.nextMonitor()) : this.doFromItem(listener.nextMonitor()));
        if (result instanceof CustomTableResultSet && (rs = (CustomTableResultSet)result).getColumns().length == 1 && rs.getColumns()[0].getLabel().isEmpty()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < rs.size()) {
                Object o = rs.get(i);
                if (o instanceof AbstractCustomTableResultSet.RowMap) {
                    AbstractCustomTableResultSet.RowMap rm = (AbstractCustomTableResultSet.RowMap)o;
                    if (rm.size() > 1 || !rm.containsKey("")) {
                        list = null;
                        break;
                    }
                    list.add(rm.get(""));
                } else {
                    list.add(o);
                }
                ++i;
            }
            if (list != null) {
                result = list;
            }
        }
        if (this.query.getUnionQueries() != null) {
            result = this.union(listener, result);
        }
        monitor.done();
        return result;
    }

    private Object union(SimpleMonitor monitor, Object result) throws SnapshotException, OQLParseException {
        UnionResultSet unionResultSet = null;
        IntArrayResult unionIntResult = null;
        ArrayList<IObject> unionListResult = null;
        if (result instanceof CustomTableResultSet) {
            unionResultSet = new UnionResultSet(this);
            unionResultSet.addResultSet(this.query, (CustomTableResultSet)result);
        } else if (result instanceof IntResult) {
            IntResult intResult = (IntResult)result;
            unionIntResult = new IntArrayResult(intResult.size());
            unionIntResult.addAll(intResult);
        } else if (result instanceof List) {
            unionListResult = new ArrayList<IObject>((List)result);
        } else if (!this.query.getSelectClause().getSelectList().isEmpty() && !this.query.getSelectClause().isAsObjects()) {
            unionResultSet = new UnionResultSet(this);
            unionResultSet.addResultSet(this.query, new ResultSet(this.getSelectQuery(), new int[0]));
        }
        for (Query q : this.query.getUnionQueries()) {
            OQLQueryImpl unionQuery;
            Object unionResult;
            if (this.query.getSelectClause().getSelectList().isEmpty() || this.query.getSelectClause().isAsObjects()) {
                if (!q.getSelectClause().getSelectList().isEmpty() && !q.getSelectClause().isAsObjects()) {
                    throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_QueryMustReturnObjects, (Object[])new Object[]{q}));
                }
            } else if (q.getSelectClause().getSelectList().size() != this.query.getSelectClause().getSelectList().size()) {
                throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_QueryMustHaveIdenticalSelectItems, (Object[])new Object[]{q}));
            }
            if ((unionResult = (unionQuery = new OQLQueryImpl(this.ctx, q)).internalExecute(monitor.nextMonitor())) != null) {
                if (unionResultSet != null) {
                    unionResultSet.addResultSet(q, (CustomTableResultSet)unionResult);
                    continue;
                }
                if (unionIntResult != null) {
                    if (unionResult instanceof List) {
                        List list = (List)unionResult;
                        unionListResult = new ArrayList(unionIntResult.size() + list.size());
                        IntIterator it = unionIntResult.iterator();
                        while (it.hasNext()) {
                            unionListResult.add(this.ctx.getSnapshot().getObject(it.nextInt()));
                            unionIntResult = null;
                            unionListResult.addAll(list);
                        }
                        continue;
                    }
                    unionIntResult.addAll((IntResult)unionResult);
                    continue;
                }
                if (unionListResult != null) {
                    if (unionResult instanceof List) {
                        unionListResult.addAll((List)unionResult);
                        continue;
                    }
                    IntIterator it = ((IntResult)unionResult).iterator();
                    while (it.hasNext()) {
                        unionListResult.add(this.ctx.getSnapshot().getObject(it.nextInt()));
                    }
                    continue;
                }
                if (this.query.getSelectClause().getSelectList().isEmpty() || this.query.getSelectClause().isAsObjects()) {
                    unionIntResult = new IntArrayResult(0);
                    unionIntResult.addAll((IntResult)unionResult);
                    continue;
                }
                unionResultSet = new UnionResultSet(this);
                unionResultSet.addResultSet(q, (CustomTableResultSet)unionResult);
                continue;
            }
            if (unionResultSet == null) continue;
            unionResultSet.addResultSet(q, new ResultSet(unionQuery, new int[0]));
        }
        return unionResultSet != null ? (unionResultSet.getRowCount() > 0 ? unionResultSet : null) : (unionIntResult != null ? unionIntResult : unionListResult);
    }

    private Object doSubQuery(IProgressListener monitor) throws SnapshotException {
        int[] nArray;
        if (this.query.getWhereClause() == null) {
            int[] nArray2 = new int[2];
            nArray2[0] = 300;
            nArray = nArray2;
            nArray2[1] = 100;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 200;
            nArray = nArray3;
            nArray3[1] = 200;
        }
        int[] percentages = nArray;
        SimpleMonitor listener = new SimpleMonitor(this.query.toString(), monitor, percentages);
        OQLQueryImpl subQuery = new OQLQueryImpl(this.ctx, this.query.getFromClause().getSubSelect());
        Object result = subQuery.internalExecute(listener.nextMonitor());
        monitor = listener.nextMonitor();
        if (this.query.getFromClause().includeObjects() && !this.query.getFromClause().includeSubClasses()) {
            if (result == null) {
                return null;
            }
            if (result instanceof AbstractCustomTableResultSet) {
                return this.filterAndSelect((AbstractCustomTableResultSet)result, monitor);
            }
            if (result instanceof Iterable) {
                ArrayList<Object> r = new ArrayList<Object>();
                if (result instanceof Collection) {
                    int count = ((Collection)result).size();
                    String task = this.query.getWhereClause() != null ? "WHERE " + this.query.getWhereClause() : Messages.OQLQueryImpl_Selecting;
                    monitor.beginTask(task, count);
                }
                for (Object obj : (Iterable)result) {
                    if (this.accept(obj, monitor)) {
                        r.add(obj);
                    }
                    if (monitor.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    if (!(result instanceof Collection)) continue;
                    monitor.worked(1);
                }
                return r.isEmpty() ? null : this.select(r, monitor);
            }
            if (result.getClass().isArray()) {
                ArrayList<Object> r = new ArrayList<Object>();
                int length = Array.getLength(result);
                String task = this.query.getWhereClause() != null ? "WHERE " + this.query.getWhereClause() : Messages.OQLQueryImpl_Selecting;
                monitor.beginTask(task, length);
                int ii = 0;
                while (ii < length) {
                    Object obj = Array.get(result, ii);
                    if (this.accept(obj, monitor)) {
                        r.add(obj);
                    }
                    if (monitor.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    monitor.worked(1);
                    ++ii;
                }
                return r.isEmpty() ? null : this.select(r, monitor);
            }
            if (result instanceof IResultTable || result instanceof IResultTree) {
                return this.filterAndSelect((IStructuredResult)result, monitor);
            }
            if (!(result instanceof IntResult)) {
                return this.accept(result, monitor) ? this.select(result, monitor) : null;
            }
        }
        if (!(result instanceof IntResult)) {
            throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_MustReturnObjectList, (Object[])new Object[]{this.query.getFromClause().getSubSelect()}));
        }
        IntResult baseSet = (IntResult)result;
        if (this.query.getFromClause().includeObjects() && !this.query.getFromClause().includeSubClasses()) {
            return this.filterAndSelect(baseSet, monitor);
        }
        try {
            ArrayList<IClass> classes = new ArrayList<IClass>(baseSet.size());
            IntIterator iter = baseSet.iterator();
            while (iter.hasNext()) {
                int id = iter.nextInt();
                IObject o = this.ctx.getSnapshot().getObject(id);
                if (!(o instanceof IClass)) {
                    throw new SnapshotException(Messages.OQLQueryImpl_Error_ClassCastExceptionOccured);
                }
                IClass subjectClass = (IClass)o;
                classes.add(subjectClass);
                if (!this.query.getFromClause().includeSubClasses()) continue;
                classes.addAll(subjectClass.getAllSubclasses());
            }
            return this.filterClasses(monitor, classes);
        }
        catch (ClassCastException e) {
            throw new SnapshotException(Messages.OQLQueryImpl_Error_ClassCastExceptionOccured, (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Object doFromItem(IProgressListener listener) throws SnapshotException {
        classes = null;
        if (this.query.getFromClause().getClassName() != null) {
            classes = this.ctx.getSnapshot().getClassesByName(this.query.getFromClause().getClassName(), this.query.getFromClause().includeSubClasses());
        } else {
            if (this.query.getFromClause().getClassNamePattern() != null) {
                try {
                    pattern = Pattern.compile(PatternUtil.smartFix((String)this.query.getFromClause().getClassNamePattern(), (boolean)false));
                    classes = this.ctx.getSnapshot().getClassesByName(pattern, this.query.getFromClause().includeSubClasses());
                }
                catch (PatternSyntaxException e) {
                    throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_InvalidClassNamePattern, (Object[])new Object[]{this.query.getFromClause().getClassNamePattern()}), (Throwable)e);
                }
            }
            if (this.query.getFromClause().getObjectIds() != null) {
                if (this.query.getFromClause().includeObjects() && !this.query.getFromClause().includeSubClasses()) {
                    return this.filterAndSelect(new IntArrayResult(this.query.getFromClause().getObjectIds().toArray()), listener);
                }
                classes = new ArrayList<E>();
                ee = this.query.getFromClause().getObjectIds().iterator();
                while (ee.hasNext()) {
                    subject = this.ctx.getSnapshot().getObject(ee.next());
                    if (subject instanceof IClass) {
                        subjectClass = (IClass)subject;
                        classes.add(subjectClass);
                        if (!this.query.getFromClause().includeSubClasses()) continue;
                        classes.addAll(subjectClass.getAllSubclasses());
                        continue;
                    }
                    throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Errot_IsNotClass, (Object[])new Object[]{Long.toHexString(subject.getObjectAddress())}));
                }
            } else if (this.query.getFromClause().getObjectAddresses() != null) {
                objectAddresses = this.query.getFromClause().getObjectAddresses();
                result = new IntArrayResult(objectAddresses.size());
                resultRefs = null;
                for (long addr : objectAddresses) {
                    block22: {
                        if (resultRefs == null) {
                            try {
                                objId = this.ctx.getSnapshot().mapAddressToId(addr);
                                result.add(objId);
                                break block22;
                            }
                            catch (SnapshotException e) {
                                resultRefs = new ArrayList<ObjectReference>();
                                ii = result.iterator();
                                ** while (ii.hasNext())
                            }
lbl-1000:
                            // 1 sources

                            {
                                ref = new ObjectReference(this.ctx.getSnapshot(), this.ctx.getSnapshot().mapIdToAddress(ii.nextInt()));
                                resultRefs.add(ref);
                                continue;
                            }
                        }
                    }
                    if (resultRefs == null) continue;
                    ref = new ObjectReference(this.ctx.getSnapshot(), addr);
                    resultRefs.add(ref);
                }
                if (this.query.getFromClause().includeObjects() && !this.query.getFromClause().includeSubClasses()) {
                    if (resultRefs != null) {
                        return this.filterAndSelect(resultRefs, listener);
                    }
                    return this.filterAndSelect(result, listener);
                }
                classes = new ArrayList<E>();
                iter = result.iterator();
                while (iter.hasNext()) {
                    subject = this.ctx.getSnapshot().getObject(iter.nextInt());
                    if (subject instanceof IClass) {
                        subjectClass = (IClass)subject;
                        classes.add(subjectClass);
                        if (!this.query.getFromClause().includeSubClasses()) continue;
                        classes.addAll(subjectClass.getAllSubclasses());
                        continue;
                    }
                    throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Errot_IsNotClass, (Object[])new Object[]{Long.toHexString(subject.getObjectAddress())}));
                }
            }
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        if (classes == null || classes.isEmpty()) {
            return null;
        }
        return this.filterClasses(listener, classes);
    }

    private Object doMethodCall(IProgressListener listener) throws SnapshotException {
        ArrayList<IClass> classes;
        block41: {
            Object result;
            block40: {
                int[] percentages = new int[]{300, 100};
                SimpleMonitor smlistener = new SimpleMonitor(this.query.toString(), listener, percentages);
                Expression method = this.query.getFromClause().getCall();
                this.ctx.setSubject(this.ctx.getSnapshot());
                IProgressListener old = this.ctx.getProgressListener();
                this.ctx.setProgressListener(smlistener.nextMonitor());
                this.ctx.getProgressListener().subTask("FROM " + this.query.getFromClause().toString());
                result = method.compute(this.ctx);
                this.ctx.getProgressListener().done();
                this.ctx.setProgressListener(old);
                listener = smlistener.nextMonitor();
                if (this.query.getFromClause().includeObjects() && !this.query.getFromClause().includeSubClasses()) {
                    if (result == null) {
                        return null;
                    }
                    if (result instanceof Iterable) {
                        ArrayList<Object> r = new ArrayList<Object>();
                        if (result instanceof Collection) {
                            int length = ((Collection)result).size();
                            String task = this.query.getWhereClause() != null ? "WHERE " + this.query.getWhereClause() : Messages.OQLQueryImpl_Selecting;
                            listener.beginTask(task, length);
                        }
                        for (Object obj : (Iterable)result) {
                            if (this.accept(obj, listener)) {
                                r.add(obj);
                            }
                            if (listener.isCanceled()) {
                                throw new IProgressListener.OperationCanceledException();
                            }
                            if (!(result instanceof Collection)) continue;
                            listener.worked(1);
                        }
                        return r.isEmpty() ? null : this.select(r, listener);
                    }
                    if (result.getClass().isArray()) {
                        ArrayList<Object> r = new ArrayList<Object>();
                        int length = Array.getLength(result);
                        String task = this.query.getWhereClause() != null ? "WHERE " + this.query.getWhereClause() : Messages.OQLQueryImpl_Selecting;
                        listener.beginTask(task, length);
                        int ii = 0;
                        while (ii < length) {
                            Object obj = Array.get(result, ii);
                            if (this.accept(obj, listener)) {
                                r.add(obj);
                            }
                            if (listener.isCanceled()) {
                                throw new IProgressListener.OperationCanceledException();
                            }
                            listener.worked(1);
                            ++ii;
                        }
                        return r.isEmpty() ? null : this.select(r, listener);
                    }
                    if (result instanceof IResultTable || result instanceof IResultTree) {
                        return this.filterAndSelect((IStructuredResult)result, listener);
                    }
                    return this.accept(result, listener) ? this.select(result, listener) : null;
                }
                classes = new ArrayList<IClass>();
                if (result != null) break block40;
                return null;
            }
            try {
                if (result instanceof Iterable) {
                    for (Object obj : (Iterable)result) {
                        if (obj == null) continue;
                        if (obj instanceof Integer) {
                            IObject o = this.ctx.getSnapshot().getObject(((Integer)obj).intValue());
                            if (!(o instanceof IClass)) {
                                throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_ElementIsNotClass, (Object[])new Object[]{this.query.getFromClause().toString(), o.getClass().getName()}));
                            }
                            IClass subjectClass = (IClass)o;
                            classes.add(subjectClass);
                            if (!this.query.getFromClause().includeSubClasses()) continue;
                            classes.addAll(subjectClass.getAllSubclasses());
                            continue;
                        }
                        if (obj instanceof int[]) {
                            int[] nArray = (int[])obj;
                            int n = nArray.length;
                            int subjectClass = 0;
                            while (subjectClass < n) {
                                int id = nArray[subjectClass];
                                IObject o = this.ctx.getSnapshot().getObject(id);
                                if (!(o instanceof IClass)) {
                                    throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_ElementIsNotClass, (Object[])new Object[]{this.query.getFromClause().toString(), o.getClass().getName()}));
                                }
                                IClass subjectClass2 = (IClass)o;
                                classes.add(subjectClass2);
                                if (this.query.getFromClause().includeSubClasses()) {
                                    classes.addAll(subjectClass2.getAllSubclasses());
                                }
                                ++subjectClass;
                            }
                            continue;
                        }
                        if (obj instanceof IClass) {
                            IClass subjectClass = (IClass)obj;
                            classes.add(subjectClass);
                            if (!this.query.getFromClause().includeSubClasses()) continue;
                            classes.addAll(subjectClass.getAllSubclasses());
                            continue;
                        }
                        throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_ElementIsNotClass, (Object[])new Object[]{this.query.getFromClause().toString(), obj.getClass().getName()}));
                    }
                    break block41;
                }
                if (result.getClass().isArray()) {
                    int length = Array.getLength(result);
                    int ii = 0;
                    while (ii < length) {
                        Object obj = Array.get(result, ii);
                        if (obj != null) {
                            if (obj instanceof Integer) {
                                IObject o = this.ctx.getSnapshot().getObject(((Integer)obj).intValue());
                                if (!(o instanceof IClass)) {
                                    throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_ElementIsNotClass, (Object[])new Object[]{this.query.getFromClause().toString(), o.getClass().getName()}));
                                }
                                IClass subjectClass = (IClass)o;
                                classes.add(subjectClass);
                                if (this.query.getFromClause().includeSubClasses()) {
                                    classes.addAll(subjectClass.getAllSubclasses());
                                }
                            } else if (obj instanceof int[]) {
                                int[] nArray = (int[])obj;
                                int n = nArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    int id = nArray[n2];
                                    IClass subjectClass = (IClass)this.ctx.getSnapshot().getObject(id);
                                    classes.add(subjectClass);
                                    if (this.query.getFromClause().includeSubClasses()) {
                                        classes.addAll(subjectClass.getAllSubclasses());
                                    }
                                    ++n2;
                                }
                            } else if (obj instanceof IClass) {
                                IClass subjectClass = (IClass)obj;
                                classes.add(subjectClass);
                                if (this.query.getFromClause().includeSubClasses()) {
                                    classes.addAll(subjectClass.getAllSubclasses());
                                }
                            } else {
                                throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_ElementIsNotClass, (Object[])new Object[]{this.query.getFromClause().toString(), obj.getClass().getName()}));
                            }
                        }
                        ++ii;
                    }
                    break block41;
                }
                if (result instanceof IClass) {
                    IClass subjectClass = (IClass)result;
                    classes.add(subjectClass);
                    if (this.query.getFromClause().includeSubClasses()) {
                        classes.addAll(subjectClass.getAllSubclasses());
                    }
                    break block41;
                }
                throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_ElementIsNotClass, (Object[])new Object[]{this.query.getFromClause().toString(), result.getClass().getName()}));
            }
            catch (ClassCastException e) {
                throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_ElementIsNotClass, (Object[])new Object[]{this.query.getFromClause().toString(), e.getMessage()}), (Throwable)e);
            }
        }
        return this.filterClasses(listener, classes);
    }

    private Object filterClasses(IProgressListener listener, Collection<IClass> classes) throws SnapshotException {
        boolean countObjs;
        if (this.query.getFromClause().includeObjects()) {
            listener.beginTask(Messages.OQLQueryImpl_SelectingObjects, classes.size());
            IntResult filteredSet = this.createIntResult(classes.size());
            for (IClass clasz : classes) {
                if (this.accept(clasz.getObjectId(), listener)) {
                    filteredSet.add(clasz.getObjectId());
                }
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                listener.worked(1);
            }
            return filteredSet.isEmpty() ? null : this.select(filteredSet, listener);
        }
        int work = classes.size();
        boolean bl = countObjs = work < 1000;
        if (countObjs) {
            work = 0;
            for (IClass clasz : classes) {
                work += clasz.getNumberOfObjects();
            }
            if (work < classes.size()) {
                countObjs = false;
                work = classes.size();
            }
        }
        listener.beginTask(Messages.OQLQueryImpl_CollectingObjects, work);
        IntResult filteredSet = this.createIntResult(classes.size() * 100);
        for (IClass clasz : classes) {
            int[] ids;
            listener.subTask(MessageUtil.format((String)Messages.OQLQueryImpl_CheckingClass, (Object[])new Object[]{clasz.getName()}));
            int[] nArray = ids = clasz.getObjectIds();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                if (this.accept(id, listener)) {
                    filteredSet.add(id);
                }
                if (countObjs) {
                    listener.worked(1);
                }
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                ++n2;
            }
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            if (countObjs) continue;
            listener.worked(1);
        }
        return filteredSet.isEmpty() ? null : this.select(filteredSet, listener);
    }

    private boolean accept(int objectId, IProgressListener mon) throws SnapshotException {
        if (this.query.getWhereClause() == null) {
            return true;
        }
        return this.accept(this.ctx.getSnapshot().getObject(objectId), mon);
    }

    private boolean accept(Object object, IProgressListener mon) throws SnapshotException {
        if (this.query.getWhereClause() == null) {
            return true;
        }
        this.ctx.setSubject(object);
        IProgressListener old = this.ctx.getProgressListener();
        this.ctx.setProgressListener((IProgressListener)new SilentProgressListener(mon));
        Boolean result = (Boolean)this.query.getWhereClause().compute(this.ctx);
        this.ctx.setProgressListener(old);
        return result == null ? false : result;
    }

    private Object filterAndSelect(IntResult objectIds, IProgressListener listener) throws SnapshotException {
        String task = this.query.getWhereClause() != null ? "WHERE " + this.query.getWhereClause() : Messages.OQLQueryImpl_Selecting;
        listener.beginTask(task, objectIds.size());
        IntResult filteredSet = this.createIntResult(objectIds.size());
        IntIterator iter = objectIds.iterator();
        while (iter.hasNext()) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            int id = iter.nextInt();
            if (this.accept(id, listener)) {
                filteredSet.add(id);
            }
            listener.worked(1);
        }
        return filteredSet.isEmpty() ? null : this.select(filteredSet, listener);
    }

    private Object filterAndSelect(List<ObjectReference> objectRefs, IProgressListener listener) throws SnapshotException {
        String task = this.query.getWhereClause() != null ? "WHERE " + this.query.getWhereClause() : Messages.OQLQueryImpl_Selecting;
        listener.beginTask(task, objectRefs.size());
        LinkedHashSet<IObject> filteredSet = this.query.getSelectClause().isDistinct() || this.query.getSelectClause().isRetainedSet() ? new LinkedHashSet<IObject>() : new ArrayList(objectRefs.size());
        Iterator<ObjectReference> iter = objectRefs.iterator();
        while (iter.hasNext()) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            ObjectReference ref = iter.next();
            IObject obj = ref.getObject();
            if (this.accept(obj, listener)) {
                filteredSet.add(obj);
            }
            listener.worked(1);
        }
        ArrayList<Object> list = !(filteredSet instanceof List) ? new ArrayList<Object>(filteredSet) : (ArrayList<Object>)((Object)filteredSet);
        return filteredSet.isEmpty() ? null : this.select(list, listener);
    }

    private Object select(IntResult objectIds, IProgressListener listener) throws SnapshotException {
        Query.SelectClause select = this.query.getSelectClause();
        if (select.isRetainedSet()) {
            objectIds = new IntArrayResult(this.ctx.getSnapshot().getRetainedSet(objectIds.toArray(), (IProgressListener)new SilentProgressListener(listener)));
        }
        if (select.getSelectList().isEmpty()) {
            return objectIds;
        }
        if (select.isAsObjects()) {
            ResultSet temp = new ResultSet(this.getSelectQuery(), objectIds.toArray());
            IntResult r = this.createIntResult(objectIds.size());
            AbstractCollection r2 = r instanceof IntSetResult ? new LinkedHashSet() : new ArrayList();
            this.convertToObjects(temp, r, r2, listener);
            if (!(r2 instanceof List)) {
                r2 = new ArrayList<IObject>(r2);
            }
            return r2.size() > 0 ? r2 : r;
        }
        if (select.isDistinct()) {
            int[] ids = objectIds.toArray();
            ResultSet r1 = new ResultSet(this.getSelectQuery(), ids);
            ArrayInt aa = OQLQueryImpl.distinctList(r1, listener);
            int i = 0;
            while (i < aa.size()) {
                aa.set(i, ids[aa.get(i)]);
                ++i;
            }
            return new ResultSet(this.getSelectQuery(), aa.toArray());
        }
        return new ResultSet(this.getSelectQuery(), objectIds.toArray());
    }

    private Object select(Collection<Object> objects, IProgressListener listener) throws SnapshotException {
        Query.SelectClause select = this.query.getSelectClause();
        if (select.isRetainedSet()) {
            return this.select(this.convertToObjectIds(objects), listener);
        }
        if (select.getSelectList().isEmpty()) {
            return objects;
        }
        if (select.isAsObjects()) {
            ObjectResultSet temp = new ObjectResultSet(this.getSelectQuery(), objects);
            IntResult r = this.createIntResult(temp.getRowCount());
            AbstractCollection r2 = r instanceof IntSetResult ? new LinkedHashSet() : new ArrayList();
            this.convertToObjects(temp, r, r2, listener);
            if (!(r2 instanceof List)) {
                r2 = new ArrayList<IObject>(r2);
            }
            return r2.size() > 0 ? r2 : r;
        }
        if (select.isDistinct()) {
            LinkedHashSet<Object> so = new LinkedHashSet<Object>(objects);
            Object[] objs = so.toArray(new Object[so.size()]);
            so.clear();
            ObjectResultSet s1 = new ObjectResultSet(this.getSelectQuery(), objs);
            ArrayInt aa = OQLQueryImpl.distinctList(s1, listener);
            Object[] objs2 = new Object[aa.size()];
            int i = 0;
            while (i < aa.size()) {
                objs2[i] = objs[aa.get(i)];
                ++i;
            }
            return new ObjectResultSet(this.getSelectQuery(), objs2);
        }
        return new ObjectResultSet(this.getSelectQuery(), objects);
    }

    private Object filterAndSelect(IStructuredResult result, IProgressListener listener) throws SnapshotException {
        IStructuredResult irt = result;
        List elements = irt instanceof IResultTree ? ((IResultTree)irt).getElements() : null;
        int count = irt instanceof IResultTable ? ((IResultTable)irt).getRowCount() : elements.size();
        LinkedHashSet<Object> r = this.query.getSelectClause().isDistinct() || this.query.getSelectClause().isRetainedSet() ? new LinkedHashSet<Object>(count) : new ArrayList(count);
        String task = this.query.getWhereClause() != null ? "WHERE " + this.query.getWhereClause() : Messages.OQLQueryImpl_Selecting;
        listener.beginTask(task, count);
        int ii = 0;
        while (ii < count) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            AbstractCustomTableResultSet.RowMap rowobj = new AbstractCustomTableResultSet.RowMap(irt, ii);
            if (this.accept(rowobj, listener)) {
                r.add(rowobj);
            }
            listener.worked(1);
            ++ii;
        }
        listener.done();
        return r.isEmpty() ? null : this.select(r, listener);
    }

    private Object filterAndSelect(AbstractCustomTableResultSet result, IProgressListener listener) throws SnapshotException {
        AbstractCollection r = this.query.getSelectClause().isDistinct() || this.query.getSelectClause().isRetainedSet() ? new LinkedHashSet(result.size()) : new ArrayList(result.size());
        String task = this.query.getWhereClause() != null ? "WHERE " + this.query.getWhereClause() : Messages.OQLQueryImpl_Selecting;
        listener.beginTask(task, result.getRowCount() * 2);
        IProgressListener old = this.ctx.getProgressListener();
        this.ctx.setProgressListener((IProgressListener)new SilentProgressListener(listener));
        for (final AbstractCustomTableResultSet.RowMap rowobj : result) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            int maxlen = -1;
            for (Object v : rowobj.values()) {
                int ll;
                if (v instanceof List) {
                    ll = ((List)v).size();
                    if (ll <= maxlen) continue;
                    maxlen = ll;
                    continue;
                }
                if (v == null || !v.getClass().isArray() || (ll = Array.getLength(v)) <= maxlen) continue;
                maxlen = ll;
            }
            listener.worked(1);
            if (maxlen >= 0) {
                if (maxlen == 0) {
                    maxlen = 1;
                }
                int i = 0;
                while (i < maxlen) {
                    final int ix = i;
                    AbstractCustomTableResultSet.RowMap rm2 = new AbstractCustomTableResultSet.RowMap((IStructuredResult)result, rowobj.index, i){

                        @Override
                        public Object get(Object key) {
                            Object v = rowobj.get(key);
                            if (v instanceof List) {
                                if (ix >= ((List)v).size()) {
                                    return null;
                                }
                                return ((List)v).get(ix);
                            }
                            if (v != null && v.getClass().isArray()) {
                                if (ix >= Array.getLength(v)) {
                                    return null;
                                }
                                return Array.get(v, ix);
                            }
                            return v;
                        }
                    };
                    if (this.accept(rm2, listener)) {
                        r.add(rm2);
                    }
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    ++i;
                }
            } else if (this.accept(rowobj, listener)) {
                r.add(rowobj);
            }
            listener.worked(1);
        }
        this.ctx.setProgressListener(old);
        listener.done();
        return r.isEmpty() ? null : this.select(r, listener);
    }

    private Object select(Object object, IProgressListener listener) throws SnapshotException {
        Query.SelectClause select = this.query.getSelectClause();
        if (select.isRetainedSet()) {
            return this.select(this.convertToObjectIds(Arrays.asList(object)), listener);
        }
        if (select.getSelectList().isEmpty()) {
            return object;
        }
        if (select.isAsObjects()) {
            ObjectResultSet temp = new ObjectResultSet(this.getSelectQuery(), Arrays.asList(object));
            IntResult r = this.createIntResult(temp.getRowCount());
            AbstractCollection r2 = r instanceof IntSetResult ? new LinkedHashSet() : new ArrayList();
            this.convertToObjects(temp, r, r2, listener);
            if (!(r2 instanceof List)) {
                r2 = new ArrayList<IObject>(r2);
            }
            return r2.size() > 0 ? r2 : r;
        }
        return new ObjectResultSet(this.getSelectQuery(), Arrays.asList(object));
    }

    private OQLQueryImpl getSelectQuery() {
        Query q2 = new Query();
        q2.setSelectClause(this.query.getSelectClause());
        q2.setFromClause(this.query.getFromClause());
        q2.setWhereClause(this.query.getWhereClause());
        OQLQueryImpl qi = new OQLQueryImpl(this.ctx, q2);
        return qi;
    }

    private IntArrayResult convertToObjectIds(Collection<?> objects) throws SnapshotException {
        ArrayInt a = new ArrayInt();
        for (Object object : objects) {
            if (object == null) continue;
            if (object instanceof Integer) {
                a.add(((Integer)object).intValue());
                continue;
            }
            if (object instanceof IObject) {
                a.add(((IObject)object).getObjectId());
                continue;
            }
            if (object instanceof ObjectReference) {
                a.add(((ObjectReference)object).getObjectId());
                continue;
            }
            if (object instanceof int[]) {
                a.addAll((int[])object);
                continue;
            }
            throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_CannotCalculateRetainedSet, (Object[])new Object[]{object}));
        }
        return new IntArrayResult(a);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void convertToObjects(CustomTableResultSet set, IntResult resultSet, Collection<IObject> resultList, IProgressListener listener) throws SnapshotException {
        if (set.getColumns().length != 1) {
            throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_QueryCannotBeConverted, (Object[])new Object[]{set.getOQLQuery()}));
        }
        old = this.ctx.getProgressListener();
        this.ctx.setProgressListener((IProgressListener)new SilentProgressListener(listener));
        resultListSize0 = resultList != null ? resultList.size() : 0;
        count = set.getRowCount();
        ii = 0;
        while (ii < count) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            rowObject = set.getColumnValue(set.getRow(ii), 0);
            it /* !! */  = rowObject instanceof Iterable != false ? (Set<Object>)rowObject : (rowObject instanceof Object[] != false ? Arrays.asList((Object[])rowObject) : Collections.singleton(rowObject));
            for (T object : it /* !! */ ) {
                if (object == null) continue;
                if (object instanceof Integer) {
                    resultSet.add((Integer)object);
                    continue;
                }
                if (object instanceof int[]) {
                    resultSet.addAll((int[])object);
                    continue;
                }
                if (object instanceof IObject) {
                    block31: {
                        if (resultList == null) {
                            resultSet.add(((IObject)object).getObjectId());
                            continue;
                        }
                        try {
                            resultSet.add(((IObject)object).getObjectId());
                            continue;
                        }
                        catch (RuntimeException e) {
                            if (!(e.getCause() instanceof SnapshotException)) break block31;
                            it2 = resultSet.iterator();
                            ** while (it2.hasNext())
                        }
lbl-1000:
                        // 1 sources

                        {
                            resultList.add(this.ctx.getSnapshot().getObject(it2.nextInt()));
                            continue;
                        }
lbl35:
                        // 1 sources

                        resultSet = this.createIntResult(count - ii);
                        resultList.add((IObject)object);
                        continue;
                    }
                    throw e;
                }
                if (object instanceof Long) {
                    addr = (Long)object;
                    if (addr == 0L) continue;
                    if (resultList == null) {
                        id = this.ctx.getSnapshot().mapAddressToId(addr);
                        resultSet.add(id);
                        continue;
                    }
                    try {
                        id = this.ctx.getSnapshot().mapAddressToId(addr);
                        resultSet.add(id);
                        continue;
                    }
                    catch (SnapshotException e) {
                        it2 = resultSet.iterator();
                        ** while (it2.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        resultList.add(this.ctx.getSnapshot().getObject(it2.nextInt()));
                        continue;
                    }
lbl58:
                    // 1 sources

                    resultSet = this.createIntResult(count - ii);
                    ref = new ObjectReference(this.ctx.getSnapshot(), addr);
                    resultList.add(ref.getObject());
                    continue;
                }
                if (object instanceof ObjectReference) {
                    if (resultList == null) {
                        id = ((ObjectReference)object).getObjectId();
                        resultSet.add(id);
                        continue;
                    }
                    try {
                        id = ((ObjectReference)object).getObjectId();
                        resultSet.add(id);
                        continue;
                    }
                    catch (SnapshotException e) {
                        it2 = resultSet.iterator();
                        ** while (it2.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        resultList.add(this.ctx.getSnapshot().getObject(it2.nextInt()));
                        continue;
                    }
lbl78:
                    // 1 sources

                    resultSet = this.createIntResult(count - ii);
                    resultList.add(((ObjectReference)object).getObject());
                    continue;
                }
                if (object instanceof long[]) {
                    var17_27 = (long[])object;
                    var16_26 = var17_27.length;
                    var15_24 = 0;
                    while (var15_24 < var16_26) {
                        block32: {
                            addr = var17_27[var15_24];
                            if (addr != 0L) {
                                if (resultList == null) {
                                    id = this.ctx.getSnapshot().mapAddressToId(addr);
                                    resultSet.add(id);
                                } else {
                                    try {
                                        id = this.ctx.getSnapshot().mapAddressToId(addr);
                                        resultSet.add(id);
                                        break block32;
                                    }
                                    catch (SnapshotException e) {
                                        it2 = resultSet.iterator();
                                        ** while (it2.hasNext())
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        resultList.add(this.ctx.getSnapshot().getObject(it2.nextInt()));
                                        continue;
                                    }
lbl103:
                                    // 1 sources

                                    resultSet = this.createIntResult(count - ii);
                                    ref = new ObjectReference(this.ctx.getSnapshot(), addr);
                                    resultList.add(ref.getObject());
                                }
                            }
                        }
                        ++var15_24;
                    }
                    continue;
                }
                throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_ResultMustReturnObjectList, (Object[])new Object[]{set.getOQLQuery(), String.valueOf(rowObject)}));
            }
            ++ii;
        }
        if (resultList != null && resultList.size() > resultListSize0) {
            it2 = resultSet.iterator();
            while (it2.hasNext()) {
                resultList.add(this.ctx.getSnapshot().getObject(it2.nextInt()));
            }
        }
        this.ctx.setProgressListener(old);
    }

    private IntResult createIntResult(int capacity) {
        return this.query.getSelectClause().isDistinct() || this.query.getSelectClause().isRetainedSet() ? new IntSetResult(capacity) : new IntArrayResult(capacity);
    }

    public String toString() {
        return this.query.toString();
    }

    private static abstract class AbstractCustomTableResultSet
    extends AbstractList<RowMap>
    implements CustomTableResultSet {
        protected OQLQueryImpl source;
        protected Column[] columns;

        public AbstractCustomTableResultSet(OQLQueryImpl source) {
            this.source = source;
        }

        static int getObjectId(Object o) {
            try {
                if (o instanceof IObject) {
                    return ((IObject)o).getObjectId();
                }
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof SnapshotException) {
                    return -1;
                }
                throw e;
            }
            return -1;
        }

        @Override
        public RowMap get(int index) {
            Object ret;
            if (this.getColumns().length == 1 && this.getColumns()[0].getLabel().isEmpty() && (ret = this.getColumnValue(this.getRow(index), 0)) instanceof RowMap) {
                return (RowMap)ret;
            }
            return new RowMap((IStructuredResult)this, index);
        }

        @Override
        public int size() {
            return this.getRowCount();
        }

        protected ResultMetaData getResultMetaData(OQLQueryImpl source) {
            final Query query = source.query;
            Column[] columns = this.getColumns();
            final int objectCount = source.ctx.getSnapshot().getSnapshotInfo().getNumberOfObjects();
            ResultMetaData.Builder builder = new ResultMetaData.Builder();
            int prov = 0;
            int ii = 0;
            while (ii < columns.length) {
                Object sample;
                Object object = sample = this.getRowCount() > 0 ? this.getColumnValue(this.getRow(0), ii) : null;
                if (AbstractCustomTableResultSet.getObjectId(sample) != -1 || sample instanceof IObject || sample instanceof Iterable && ((Iterable)sample).iterator().hasNext() && AbstractCustomTableResultSet.getObjectId(((Iterable)sample).iterator().next()) != -1 || sample instanceof int[]) {
                    if (prov == 0 && this.getContext(this.getRow(0)) != null) {
                        Query.FromClause fc = query.getFromClause();
                        String alias = fc.getAlias();
                        String label = alias != null ? alias : fc.toString();
                        label = "SELECT ... " + label;
                        builder.addContext(new ContextProvider(label){

                            public IContextObject getContext(Object row) {
                                return this.getContext(row);
                            }
                        });
                        ++prov;
                    }
                    final int columnIndex = ii;
                    builder.addContext(new ContextProvider(columns[ii].getLabel()){

                        public IContextObject getContext(final Object row) {
                            IContextObject cx;
                            final Object o = this.getColumnValue(row, columnIndex);
                            final int objectId = AbstractCustomTableResultSet.getObjectId(o);
                            boolean goodContext = false;
                            if (objectId == -1 && !(o instanceof Iterable) && !(o instanceof int[]) && (cx = this.getContext(row)) != null) {
                                int selectId = cx.getObjectId();
                                if (selectId != -1) {
                                    goodContext = true;
                                } else if (cx instanceof IContextObjectSet && ((IContextObjectSet)cx).getOQL() != null) {
                                    goodContext = true;
                                }
                            }
                            if (objectId != -1 || o instanceof IObject || goodContext) {
                                return new IContextObjectSet(){

                                    public int getObjectId() {
                                        return objectId;
                                    }

                                    public int[] getObjectIds() {
                                        if (objectId != -1) {
                                            return new int[]{objectId};
                                        }
                                        return new int[0];
                                    }

                                    public String getOQL() {
                                        String alias = query.getFromClause().getAlias();
                                        String alias2 = alias == null ? "" : " " + alias;
                                        Query.SelectItem column = query.getSelectClause().getSelectList().get(columnIndex);
                                        IContextObject cx = this.getContext(row);
                                        if (cx != null) {
                                            IContextObjectSet cs;
                                            String oqlsource;
                                            int selectId = cx.getObjectId();
                                            if (selectId != -1) {
                                                return "SELECT " + column.toString() + " FROM OBJECTS " + selectId + alias2;
                                            }
                                            if (cx instanceof IContextObjectSet && (oqlsource = (cs = (IContextObjectSet)cx).getOQL()) != null) {
                                                try {
                                                    OQLQueryImpl q2 = new OQLQueryImpl(oqlsource);
                                                    q2.query.getSelectClause().setSelectList(Collections.emptyList());
                                                    return "SELECT " + column.toString() + " FROM " + q2.query.getFromClause();
                                                }
                                                catch (OQLParseException oQLParseException) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (objectId != -1) {
                                            return OQL.forObjectId((int)objectId);
                                        }
                                        return OQLQueryImpl.OQLforSubject("*", o, "");
                                    }
                                };
                            }
                            if (o instanceof Iterable || o instanceof int[]) {
                                return new IContextObjectSet(){

                                    public int getObjectId() {
                                        IContextObject cx = this.getContext(row);
                                        if (cx != null) {
                                            return cx.getObjectId();
                                        }
                                        return -1;
                                    }

                                    public int[] getObjectIds() {
                                        if (o instanceof int[]) {
                                            int[] nArray = (int[])o;
                                            int n = nArray.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                int ix = nArray[n2];
                                                if (ix < 0 || ix >= objectCount) {
                                                    return new int[0];
                                                }
                                                ++n2;
                                            }
                                            return (int[])o;
                                        }
                                        ArrayInt ai = new ArrayInt();
                                        if (o instanceof Iterable) {
                                            Iterable l = (Iterable)o;
                                            for (Object o2 : l) {
                                                int objectId = AbstractCustomTableResultSet.getObjectId(o2);
                                                if (objectId == -1) continue;
                                                ai.add(objectId);
                                            }
                                        }
                                        return ai.toArray();
                                    }

                                    public String getOQL() {
                                        IContextObjectSet cs;
                                        String oqlsource;
                                        String alias = query.getFromClause().getAlias();
                                        String alias2 = alias == null ? "" : " " + alias;
                                        Query.SelectItem column = query.getSelectClause().getSelectList().get(columnIndex);
                                        int selectId = this.getObjectId();
                                        if (selectId != -1) {
                                            return "SELECT " + column.toString() + " FROM OBJECTS " + selectId + alias2;
                                        }
                                        IContextObject cx = this.getContext(row);
                                        if (cx instanceof IContextObjectSet && (oqlsource = (cs = (IContextObjectSet)cx).getOQL()) != null) {
                                            try {
                                                OQLQueryImpl q2 = new OQLQueryImpl(oqlsource);
                                                q2.query.getSelectClause().setSelectList(Collections.emptyList());
                                                String oqlsource2 = q2.query.toString();
                                                return "SELECT " + column.toString() + " FROM OBJECTS (" + oqlsource2 + ") " + alias2;
                                            }
                                            catch (OQLParseException oQLParseException) {
                                                // empty catch block
                                            }
                                        }
                                        return OQL.forObjectIds((int[])this.getObjectIds());
                                    }
                                };
                            }
                            return null;
                        }
                    });
                    ++prov;
                }
                ++ii;
            }
            return builder.build();
        }

        @Override
        public String toString() {
            int ncols = this.getColumns() != null ? this.getColumns().length : 0;
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(System.identityHashCode(this)));
            sb.append('[').append(this.getRowCount()).append(']');
            sb.append('[').append(ncols).append(']');
            sb.append('[');
            int maxRows = 2;
            int i = 0;
            while (i < Math.min(2, this.getRowCount())) {
                sb.append(this.get(i).toString());
                if (i + 1 < this.getRowCount()) {
                    sb.append(',');
                }
                ++i;
            }
            if (this.getRowCount() > 2) {
                sb.append("...");
            }
            sb.append(']');
            return sb.toString();
        }

        private static class RowMap
        extends AbstractMap<String, Object> {
            private static final Object NULL_VALUE = new Object();
            IStructuredResult isr;
            IResultTable irtb;
            IResultTree irtr;
            int index;
            int subindex;

            public RowMap(IStructuredResult irt, int index) {
                this(irt, index, -1);
            }

            public RowMap(IStructuredResult irt, int index, int subindex) {
                this.isr = irt;
                if (this.isr instanceof IResultTable) {
                    this.irtb = (IResultTable)irt;
                }
                if (this.isr instanceof IResultTree) {
                    this.irtr = (IResultTree)irt;
                }
                this.index = index;
                this.subindex = subindex;
            }

            @Override
            public int size() {
                return this.isr.getColumns().length;
            }

            @Override
            public Object get(Object colname) {
                int col = 0;
                while (col < this.isr.getColumns().length) {
                    if (this.isr.getColumns()[col].getLabel().equals(colname)) {
                        Object row;
                        if (this.irtb != null) {
                            row = this.irtb.getRow(this.index);
                        } else if (this.irtr != null) {
                            row = this.irtr.getElements().get(this.index);
                        } else {
                            return null;
                        }
                        return this.isr.getColumnValue(row, col);
                    }
                    ++col;
                }
                return null;
            }

            public int getObjectId() {
                IContextObject cx = this.isr.getContext((Object)this.index);
                if (cx != null) {
                    return cx.getObjectId();
                }
                return -1;
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                AbstractSet<Map.Entry<String, Object>> set = new AbstractSet<Map.Entry<String, Object>>(){

                    @Override
                    public Iterator<Map.Entry<String, Object>> iterator() {
                        return new Iterator<Map.Entry<String, Object>>(){
                            int col;

                            @Override
                            public boolean hasNext() {
                                return this.col < this.size();
                            }

                            @Override
                            public Map.Entry<String, Object> next() {
                                if (this.col >= this.size()) {
                                    throw new NoSuchElementException(Integer.toString(this.col));
                                }
                                return new ColEntry(this.col++);
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return isr.getColumns().length;
                    }
                };
                return set;
            }

            private final class ColEntry
            implements Map.Entry<String, Object> {
                int col2;
                Object value;

                private ColEntry(int col) {
                    this.col2 = col;
                }

                @Override
                public String getKey() {
                    return RowMap.this.isr.getColumns()[this.col2].getLabel();
                }

                @Override
                public Object getValue() {
                    Object row;
                    Object o = this.value;
                    if (o == NULL_VALUE) {
                        return null;
                    }
                    if (o != null) {
                        return o;
                    }
                    if (RowMap.this.irtb != null) {
                        row = RowMap.this.irtb.getRow(RowMap.this.index);
                    } else if (RowMap.this.irtr != null) {
                        row = RowMap.this.irtr.getElements().get(RowMap.this.index);
                    } else {
                        return null;
                    }
                    o = RowMap.this.isr.getColumnValue(row, this.col2);
                    this.value = o == null ? NULL_VALUE : o;
                    return o;
                }

                @Override
                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int hashCode() {
                    return Objects.hash(this.getKey(), this.getValue());
                }

                @Override
                public boolean equals(Object o) {
                    if (o instanceof Map.Entry) {
                        Map.Entry ox = (Map.Entry)o;
                        return Objects.equals(this.getKey(), ox.getKey()) && Objects.equals(this.getValue(), ox.getValue());
                    }
                    return false;
                }
            }
        }
    }

    private static interface CustomTableResultSet
    extends IOQLQuery.Result,
    IResultTable,
    List<AbstractCustomTableResultSet.RowMap> {
    }

    private static class IntArrayResult
    implements IntResult {
        ArrayInt arrayInt;

        public IntArrayResult(int capacity) {
            this.arrayInt = new ArrayInt(capacity);
        }

        public IntArrayResult(int[] initialValues) {
            this.arrayInt = new ArrayInt(initialValues);
        }

        public IntArrayResult(ArrayInt values) {
            this.arrayInt = values;
        }

        @Override
        public void add(int id) {
            this.arrayInt.add(id);
        }

        @Override
        public void addAll(int[] ids) {
            this.arrayInt.addAll(ids);
        }

        @Override
        public void addAll(IntResult intResult) {
            if (intResult instanceof IntArrayResult) {
                this.arrayInt.addAll(((IntArrayResult)intResult).arrayInt);
            } else {
                IntIterator iter = intResult.iterator();
                while (iter.hasNext()) {
                    this.arrayInt.add(iter.nextInt());
                }
            }
        }

        @Override
        public int size() {
            return this.arrayInt.size();
        }

        @Override
        public int[] toArray() {
            return this.arrayInt.toArray();
        }

        @Override
        public boolean isEmpty() {
            return this.arrayInt.isEmpty();
        }

        @Override
        public IntIterator iterator() {
            return new IntIterator(){
                int nextIndex = 0;

                @Override
                public boolean hasNext() {
                    return this.nextIndex < arrayInt.size();
                }

                @Override
                public int nextInt() {
                    return arrayInt.get(this.nextIndex++);
                }
            };
        }
    }

    private static interface IntIterator {
        public int nextInt();

        public boolean hasNext();
    }

    private static interface IntResult {
        public void add(int var1);

        public void addAll(int[] var1);

        public void addAll(IntResult var1);

        public int size();

        public int[] toArray();

        public boolean isEmpty();

        public IntIterator iterator();
    }

    private static class IntSetResult
    implements IntResult {
        SetInt setInt;

        public IntSetResult(int capacity) {
            this.setInt = new SetInt(capacity);
        }

        @Override
        public void add(int id) {
            this.setInt.add(id);
        }

        @Override
        public void addAll(int[] ids) {
            int[] nArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                this.setInt.add(id);
                ++n2;
            }
        }

        @Override
        public void addAll(IntResult intResult) {
            IntIterator iter = intResult.iterator();
            while (iter.hasNext()) {
                this.setInt.add(iter.nextInt());
            }
        }

        @Override
        public int size() {
            return this.setInt.size();
        }

        @Override
        public int[] toArray() {
            return this.setInt.toArray();
        }

        @Override
        public boolean isEmpty() {
            return this.setInt.isEmpty();
        }

        @Override
        public IntIterator iterator() {
            return new IntIterator(){
                IteratorInt intEnum;
                {
                    this.intEnum = intSetResult.setInt.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.intEnum.hasNext();
                }

                @Override
                public int nextInt() {
                    return this.intEnum.next();
                }
            };
        }
    }

    private static class ObjectResultSet
    extends AbstractCustomTableResultSet {
        private static final Object NULL_VALUE = new Object();
        Object[] objects;

        ObjectResultSet(OQLQueryImpl source, Collection<Object> objects) throws SnapshotException {
            this(source, objects.toArray());
        }

        ObjectResultSet(OQLQueryImpl source, Object[] objects) throws SnapshotException {
            super(source);
            this.objects = objects;
            List<Query.SelectItem> selectList = source.query.getSelectClause().getSelectList();
            this.columns = new Column[selectList.size()];
            try {
                int ii = 0;
                while (ii < this.columns.length) {
                    this.columns[ii] = OQLQueryImpl.buildColumn(selectList.get(ii), this.getRowCount() > 0 ? this.getColumnValue(this.getRow(0), ii) : null);
                    ++ii;
                }
            }
            catch (RuntimeException e) {
                throw SnapshotException.rethrow((Throwable)e);
            }
        }

        public ResultMetaData getResultMetaData() {
            return this.getResultMetaData(this.source);
        }

        public Column[] getColumns() {
            return this.columns;
        }

        public int getRowCount() {
            return this.objects.length;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            int index = (Integer)row;
            if (!(this.objects[index] instanceof ValueHolder)) {
                this.resolve(index);
            }
            ValueHolder holder = (ValueHolder)this.objects[index];
            if (holder.values[columnIndex] == null) {
                try {
                    this.source.ctx.setSubject(holder.subject);
                    IProgressListener old = this.source.ctx.getProgressListener();
                    this.source.ctx.setProgressListener((IProgressListener)new SilentProgressListener(old));
                    Query.SelectItem column = this.source.query.getSelectClause().getSelectList().get(columnIndex);
                    Object v = column.getExpression().compute(this.source.ctx);
                    this.source.ctx.setProgressListener(old);
                    holder.values[columnIndex] = v == null ? NULL_VALUE : v;
                }
                catch (SnapshotException e) {
                    throw new RuntimeException(e);
                }
            }
            return holder.values[columnIndex] == NULL_VALUE ? null : holder.values[columnIndex];
        }

        public IContextObjectSet getContext(Object row) {
            Object subject;
            int objectId;
            int index = (Integer)row;
            if (!(this.objects[index] instanceof ValueHolder)) {
                this.resolve(index);
            }
            if ((objectId = ObjectResultSet.getObjectId(subject = ((ValueHolder)this.objects[index]).subject)) != -1 || subject instanceof IObject || subject == null || subject instanceof Character || subject instanceof Integer || subject instanceof Long || subject instanceof Float || subject instanceof Double || subject instanceof Boolean || subject instanceof String || subject instanceof AbstractCustomTableResultSet.RowMap) {
                if (objectId == -1 && OQLQueryImpl.OQLforSubject("*", subject, "") == null) {
                    return null;
                }
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return objectId;
                    }

                    public int[] getObjectIds() {
                        if (this.getObjectId() != -1) {
                            return new int[]{this.getObjectId()};
                        }
                        return new int[0];
                    }

                    public String getOQL() {
                        String alias = source.query.getFromClause().getAlias();
                        String alias2 = alias == null ? "" : " " + alias;
                        Query.SelectClause sc = source.query.getSelectClause();
                        if (sc.isRetainedSet()) {
                            Query.SelectClause sc2 = new Query.SelectClause();
                            sc2.setAsObjects(sc.isAsObjects());
                            sc2.setSelectList(sc.getSelectList());
                            sc = sc2;
                        }
                        if (this.getObjectId() == -1) {
                            return OQLQueryImpl.OQLforSubject(sc.toString(), subject, alias2);
                        }
                        String from = String.valueOf(this.getObjectId());
                        return "SELECT " + sc.toString() + " FROM OBJECTS " + from + alias2;
                    }
                };
            }
            return null;
        }

        public Object getRow(int index) {
            return index;
        }

        public String getOQLQuery() {
            return this.source.toString();
        }

        private void resolve(int index) {
            ValueHolder answer = new ValueHolder(this.objects[index], new Object[this.columns.length]);
            this.objects[index] = answer;
        }

        private static class ValueHolder {
            Object subject;
            Object[] values;

            public ValueHolder(Object subject, Object[] values) {
                this.subject = subject;
                this.values = values;
            }
        }
    }

    private static class ResultSet
    extends AbstractCustomTableResultSet {
        private static final Object NULL_VALUE = new Object();
        int[] objectIds;
        ValueHolder[] objects;

        public ResultSet(OQLQueryImpl source, int[] objectIds) throws SnapshotException {
            super(source);
            this.objectIds = objectIds;
            this.objects = new ValueHolder[objectIds.length];
            List<Query.SelectItem> selectList = source.query.getSelectClause().getSelectList();
            this.columns = new Column[selectList.size()];
            try {
                int ii = 0;
                while (ii < this.columns.length) {
                    this.columns[ii] = OQLQueryImpl.buildColumn(selectList.get(ii), this.getRowCount() > 0 ? this.getColumnValue(this.getRow(0), ii) : null);
                    ++ii;
                }
            }
            catch (RuntimeException e) {
                throw SnapshotException.rethrow((Throwable)e);
            }
        }

        public ResultMetaData getResultMetaData() {
            return this.getResultMetaData(this.source);
        }

        public int getRowCount() {
            return this.objectIds.length;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            Object value;
            int index = (Integer)row;
            if (this.objects[index] == null) {
                this.objects[index] = new ValueHolder(new Object[this.columns.length]);
            }
            if (this.objects[index].values[columnIndex] == null) {
                try {
                    IObject object = this.source.ctx.getSnapshot().getObject(this.objectIds[index]);
                    this.source.ctx.setSubject(object);
                    IProgressListener old = this.source.ctx.getProgressListener();
                    this.source.ctx.setProgressListener((IProgressListener)new SilentProgressListener(old));
                    List<Query.SelectItem> selectList = this.source.query.getSelectClause().getSelectList();
                    Object value2 = selectList.get(columnIndex).getExpression().compute(this.source.ctx);
                    this.source.ctx.setProgressListener(old);
                    this.objects[index].values[columnIndex] = value2 != null ? value2 : NULL_VALUE;
                }
                catch (SnapshotException e) {
                    throw new RuntimeException(e);
                }
            }
            return (value = this.objects[index].values[columnIndex]) == NULL_VALUE ? null : value;
        }

        public IContextObjectSet getContext(final Object row) {
            return new IContextObjectSet(){

                public int getObjectId() {
                    return objectIds[(Integer)row];
                }

                public int[] getObjectIds() {
                    return new int[]{this.getObjectId()};
                }

                public String getOQL() {
                    String alias = source.query.getFromClause().getAlias();
                    String alias2 = alias == null ? "" : " " + alias;
                    Query.SelectClause sc = source.query.getSelectClause();
                    if (sc.isRetainedSet()) {
                        Query.SelectClause sc2 = new Query.SelectClause();
                        sc2.setAsObjects(sc.isAsObjects());
                        sc2.setSelectList(sc.getSelectList());
                        sc = sc2;
                    }
                    return "SELECT " + sc.toString() + " FROM OBJECTS " + this.getObjectId() + alias2;
                }
            };
        }

        public Object getRow(int index) {
            return index;
        }

        public Column[] getColumns() {
            return this.columns;
        }

        public String getOQLQuery() {
            return this.source.query.toString();
        }

        private static class ValueHolder {
            Object[] values;

            public ValueHolder(Object[] values) {
                this.values = values;
            }
        }
    }

    private static class UnionResultSet
    extends AbstractCustomTableResultSet
    implements IOQLQuery.Result,
    IResultTable {
        int size = 0;
        List<Query> queries = new ArrayList<Query>();
        List<CustomTableResultSet> resultSets = new ArrayList<CustomTableResultSet>();
        ArrayInt sizes = new ArrayInt(5);

        public UnionResultSet(OQLQueryImpl source) {
            super(source);
        }

        public void addResultSet(Query query, CustomTableResultSet resultSet) {
            this.queries.add(query);
            this.sizes.add(this.size);
            this.size += resultSet.getRowCount();
            this.resultSets.add(resultSet);
        }

        /*
         * WARNING - void declaration
         */
        public ResultMetaData getResultMetaData() {
            Column[] columns = this.getColumns();
            final int objectCount = this.source.ctx.getSnapshot().getSnapshotInfo().getNumberOfObjects();
            ResultMetaData.Builder builder = new ResultMetaData.Builder();
            int prov = 0;
            int ii = 0;
            while (ii < columns.length) {
                Object sample = null;
                IContextObject sampleContext = null;
                for (IResultTable iResultTable : this.resultSets) {
                    Object o;
                    Object object = o = iResultTable.getRowCount() > 0 ? iResultTable.getColumnValue(iResultTable.getRow(0), ii) : null;
                    if (o == null) continue;
                    sample = o;
                    if (prov != 0) break;
                    sampleContext = iResultTable.getContext(iResultTable.getRow(0));
                    break;
                }
                if (UnionResultSet.getObjectId(sample) != -1 || sample instanceof Iterable && ((Iterable)sample).iterator().hasNext() && UnionResultSet.getObjectId(((Iterable)sample).iterator().next()) != -1 || sample instanceof int[]) {
                    if (prov == 0 && sampleContext != null) {
                        void var8_11;
                        Query.FromClause fc = this.queries.get(0).getFromClause();
                        String alias = fc.getAlias();
                        if (alias != null) {
                            String string = alias;
                        } else {
                            String string = fc.toString();
                        }
                        String string = "SELECT ... " + (String)var8_11;
                        builder.addContext(new ContextProvider(string){

                            public IContextObject getContext(Object row) {
                                return this.getContext(row);
                            }
                        });
                        ++prov;
                    }
                    final int n = ii;
                    builder.addContext(new ContextProvider(columns[ii].getLabel()){

                        public IContextObject getContext(final Object row) {
                            IContextObject cx;
                            final Object o = this.getColumnValue(row, n);
                            final int objectId = UnionResultSet.getObjectId(o);
                            boolean goodContext = false;
                            if (objectId == -1 && !(o instanceof Iterable) && !(o instanceof int[]) && (cx = this.getContext(row)) != null) {
                                int selectId = cx.getObjectId();
                                if (selectId != -1) {
                                    goodContext = true;
                                } else if (cx instanceof IContextObjectSet && ((IContextObjectSet)cx).getOQL() != null) {
                                    goodContext = true;
                                }
                            }
                            if (objectId != -1 || goodContext) {
                                return new IContextObjectSet(){

                                    public int getObjectId() {
                                        return objectId;
                                    }

                                    public int[] getObjectIds() {
                                        if (objectId != -1) {
                                            return new int[]{objectId};
                                        }
                                        return new int[0];
                                    }

                                    public String getOQL() {
                                        String alias = ((ValueHolder)row).query.getFromClause().getAlias();
                                        String alias2 = alias == null ? "" : " " + alias;
                                        Query.SelectItem column = ((ValueHolder)row).query.getSelectClause().getSelectList().get(n);
                                        IContextObject cx = this.getContext(row);
                                        if (cx != null) {
                                            IContextObjectSet cs;
                                            String oqlsource;
                                            int selectId = cx.getObjectId();
                                            if (selectId != -1) {
                                                return "SELECT " + column.toString() + " FROM OBJECTS " + selectId + alias2;
                                            }
                                            if (cx instanceof IContextObjectSet && (oqlsource = (cs = (IContextObjectSet)cx).getOQL()) != null) {
                                                try {
                                                    OQLQueryImpl q2 = new OQLQueryImpl(oqlsource);
                                                    q2.query.getSelectClause().setSelectList(Collections.emptyList());
                                                    String oqlsource2 = q2.query.toString();
                                                    return "SELECT " + column.toString() + " FROM OBJECTS (" + oqlsource2 + ") " + alias2;
                                                }
                                                catch (OQLParseException oQLParseException) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (objectId != -1) {
                                            return OQL.forObjectId((int)objectId);
                                        }
                                        return OQLQueryImpl.OQLforSubject("*", o, "");
                                    }
                                };
                            }
                            if (o instanceof Iterable || o instanceof int[]) {
                                return new IContextObjectSet(){

                                    public int getObjectId() {
                                        IContextObject cx = this.getContext(row);
                                        if (cx != null) {
                                            return cx.getObjectId();
                                        }
                                        return -1;
                                    }

                                    public int[] getObjectIds() {
                                        if (o instanceof int[]) {
                                            int[] nArray = (int[])o;
                                            int n3 = nArray.length;
                                            int n2 = 0;
                                            while (n2 < n3) {
                                                int ix = nArray[n2];
                                                if (ix < 0 || ix >= objectCount) {
                                                    return new int[0];
                                                }
                                                ++n2;
                                            }
                                            return (int[])o;
                                        }
                                        ArrayInt ai = new ArrayInt();
                                        if (o instanceof Iterable) {
                                            Iterable l = (Iterable)o;
                                            for (Object o2 : l) {
                                                int objectId = UnionResultSet.getObjectId(o2);
                                                if (objectId == -1) continue;
                                                ai.add(objectId);
                                            }
                                        }
                                        return ai.toArray();
                                    }

                                    public String getOQL() {
                                        IContextObjectSet cs;
                                        String oqlsource;
                                        String alias = ((ValueHolder)row).query.getFromClause().getAlias();
                                        String alias2 = alias == null ? "" : " " + alias;
                                        Query.SelectItem column = ((ValueHolder)row).query.getSelectClause().getSelectList().get(n);
                                        int selectId = this.getObjectId();
                                        if (selectId != -1) {
                                            return "SELECT " + column.toString() + " FROM OBJECTS " + selectId + alias2;
                                        }
                                        IContextObject cx = this.getContext(row);
                                        if (cx instanceof IContextObjectSet && (oqlsource = (cs = (IContextObjectSet)cx).getOQL()) != null) {
                                            try {
                                                OQLQueryImpl q2 = new OQLQueryImpl(oqlsource);
                                                q2.query.getSelectClause().setSelectList(Collections.emptyList());
                                                String oqlsource2 = q2.query.toString();
                                                return "SELECT " + column.toString() + " FROM OBJECTS (" + oqlsource2 + ") " + alias2;
                                            }
                                            catch (OQLParseException oQLParseException) {
                                                // empty catch block
                                            }
                                        }
                                        return OQL.forObjectIds((int[])this.getObjectIds());
                                    }
                                };
                            }
                            return null;
                        }
                    });
                    ++prov;
                }
                ++ii;
            }
            return builder.build();
        }

        public Column[] getColumns() {
            return this.resultSets.get(0).getColumns();
        }

        public int getRowCount() {
            return this.size;
        }

        public Object getRow(int index) {
            int ii = this.findPageFor(index);
            Query query = this.queries.get(ii);
            IResultTable rs = this.resultSets.get(ii);
            Object value = rs.getRow(index - this.sizes.get(ii));
            return new ValueHolder(query, rs, value);
        }

        public Object getColumnValue(Object row, int columnIndex) {
            ValueHolder holder = (ValueHolder)row;
            return holder.source.getColumnValue(holder.row, columnIndex);
        }

        public IContextObject getContext(Object row) {
            ValueHolder holder = (ValueHolder)row;
            return holder.source.getContext(holder.row);
        }

        private int findPageFor(int rowNo) {
            int pageIndex = 0;
            while (pageIndex + 1 < this.sizes.size() && rowNo >= this.sizes.get(pageIndex + 1)) {
                ++pageIndex;
            }
            return pageIndex;
        }

        public String getOQLQuery() {
            StringBuilder buf = new StringBuilder();
            for (IOQLQuery.Result result : this.resultSets) {
                OQL.union((StringBuilder)buf, (String)result.getOQLQuery());
            }
            return buf.toString();
        }

        private static class ValueHolder {
            Query query;
            IResultTable source;
            Object row;

            public ValueHolder(Query query, IResultTable source, Object row) {
                this.query = query;
                this.source = source;
                this.row = row;
            }
        }
    }
}

