/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.model;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;

public class ObjectReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient ISnapshot snapshot;
    private long address;

    public ObjectReference(ISnapshot snapshot, long address) {
        this.snapshot = snapshot;
        this.address = address;
    }

    public long getObjectAddress() {
        return this.address;
    }

    public int getObjectId() throws SnapshotException {
        return this.snapshot.mapAddressToId(this.address);
    }

    public IObject getObject() throws SnapshotException {
        int objectId;
        try {
            objectId = this.getObjectId();
        }
        catch (SnapshotException e) {
            ObjectReference proxy = this.snapshot.getSnapshotAddons(ObjectReference.class);
            if (proxy != null) {
                proxy.address = this.getObjectAddress();
                return proxy.getObject();
            }
            throw e;
        }
        return this.snapshot.getObject(objectId);
    }

    public String toString() {
        return "0x" + Long.toHexString(this.address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectReference other = (ObjectReference)obj;
        return this.address == other.address;
    }
}

