/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.hprof.CompressedRandomAccessFile;
import org.eclipse.mat.hprof.EnhancerRegistry;
import org.eclipse.mat.hprof.HprofParserHandlerImpl;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.Pass1Parser;
import org.eclipse.mat.hprof.Pass2Parser;
import org.eclipse.mat.hprof.extension.IParsingEnhancer;
import org.eclipse.mat.hprof.ui.HprofPreferences;
import org.eclipse.mat.parser.IIndexBuilder;
import org.eclipse.mat.parser.IPreliminaryIndex;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexWriter;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

public class HprofIndexBuilder
implements IIndexBuilder {
    private File file;
    private String prefix;
    private IIndexReader.IOne2LongIndex id2position;
    private List<IParsingEnhancer> enhancers;

    public void init(File file, String prefix) {
        this.file = file;
        this.prefix = prefix;
        this.enhancers = new ArrayList<IParsingEnhancer>();
        for (EnhancerRegistry.Enhancer enhancer : EnhancerRegistry.instance().delegates()) {
            IParsingEnhancer parsingEnhancer = enhancer.parser();
            if (parsingEnhancer == null) continue;
            this.enhancers.add(parsingEnhancer);
        }
    }

    public void fill(IPreliminaryIndex preliminary, IProgressListener listener) throws SnapshotException, IOException {
        HprofPreferences.HprofStrictness strictnessPreference = HprofPreferences.getCurrentStrictness();
        SimpleMonitor monitor = new SimpleMonitor(MessageUtil.format((String)Messages.HprofIndexBuilder_Parsing, (Object[])new Object[]{this.file.getAbsolutePath()}), listener, new int[]{500, 1500});
        HprofParserHandlerImpl handler = new HprofParserHandlerImpl();
        handler.beforePass1(preliminary.getSnapshotInfo());
        long estimatedLength = CompressedRandomAccessFile.estimatedLength(this.file);
        int pass1Work = (int)(CompressedRandomAccessFile.estimateWork(this.file) / 1000L);
        SimpleMonitor.Listener mon = (SimpleMonitor.Listener)monitor.nextMonitor();
        mon.beginTask(MessageUtil.format((String)Messages.HprofIndexBuilder_Scanning, (Object[])new Object[]{this.file.getAbsolutePath()}), pass1Work);
        Pass1Parser pass1 = new Pass1Parser(handler, mon, strictnessPreference);
        Serializable id = preliminary.getSnapshotInfo().getProperty("$runtimeId");
        String dumpNrToRead = id instanceof String ? (String)((Object)id) : pass1.determineDumpNumber();
        pass1.read(this.file, this.prefix, dumpNrToRead, estimatedLength);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        mon.done();
        handler.beforePass2(listener);
        long streamLength = pass1.streamLength();
        mon = (SimpleMonitor.Listener)monitor.nextMonitor();
        mon.beginTask(MessageUtil.format((String)Messages.HprofIndexBuilder_ExtractingObjects, (Object[])new Object[]{this.file.getAbsolutePath()}), (int)(streamLength / 1000L));
        long biggestArrays = pass1.biggestArrays();
        long memestimate = biggestArrays * 24L;
        Runtime runtime = Runtime.getRuntime();
        long maxFree = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        if (maxFree <= memestimate) {
            runtime.gc();
            maxFree = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        }
        boolean parallel = maxFree > memestimate;
        Pass2Parser pass2 = new Pass2Parser(handler, mon, strictnessPreference, streamLength, parallel);
        pass2.stackFrameAlign = pass1.stackFrameAlign;
        pass2.stackFrameBase = pass1.stackFrameBase;
        pass2.read(this.file, this.prefix, dumpNrToRead);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        mon.done();
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        for (IParsingEnhancer enhancer : this.enhancers) {
            enhancer.onParsingCompleted((SnapshotInfo)handler.getSnapshotInfo());
        }
        this.id2position = handler.fillIn(preliminary, listener);
    }

    public void clean(int[] purgedMapping, IProgressListener listener) throws IOException {
        File indexFile = new File(String.valueOf(this.prefix) + "o2hprof.index");
        listener.subTask(MessageUtil.format((String)Messages.HprofIndexBuilder_Writing, (Object[])new Object[]{indexFile.getAbsolutePath()}));
        IIndexReader.IOne2LongIndex newIndex = new IndexWriter.LongIndexStreamer().writeTo(indexFile, (IteratorLong)new IndexIterator(this.id2position, purgedMapping));
        try {
            newIndex.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.id2position.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.id2position.delete();
        this.id2position = null;
    }

    public void cancel() {
        if (this.id2position != null) {
            try {
                this.id2position.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.id2position.delete();
        }
    }

    private static final class IndexIterator
    implements IteratorLong {
        private final IIndexReader.IOne2LongIndex id2position;
        private final int[] purgedMapping;
        private int nextIndex = -1;

        private IndexIterator(IIndexReader.IOne2LongIndex id2position, int[] purgedMapping) {
            this.id2position = id2position;
            this.purgedMapping = purgedMapping;
            this.findNext();
        }

        public boolean hasNext() {
            return this.nextIndex < this.purgedMapping.length;
        }

        public long next() {
            long answer = this.id2position.get(this.nextIndex);
            this.findNext();
            return answer;
        }

        protected void findNext() {
            ++this.nextIndex;
            while (this.nextIndex < this.purgedMapping.length && this.purgedMapping[this.nextIndex] < 0) {
                ++this.nextIndex;
            }
        }
    }
}

