/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.Encounter;
import org.eclipse.mdht.uml.cda.Entry;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.cda.util.ValidationResult;
import org.eclipse.mdht.uml.hl7.datatypes.CE;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.vocab.ActClass;
import org.eclipse.mdht.uml.hl7.vocab.NullFlavor;
import org.eclipse.mdht.uml.hl7.vocab.x_DocumentEncounterMood;

public class Main {
    public static void testSDTCDischargeDispositionCodes() throws Exception {
        ClinicalDocument doc = CDAFactory.eINSTANCE.createClinicalDocument();
        Section section = CDAFactory.eINSTANCE.createSection();
        doc.addSection(section);
        Encounter encounter = CDAFactory.eINSTANCE.createEncounter();
        encounter.getRealmCodes().add((Object)DatatypesFactory.eINSTANCE.createCS());
        encounter.setTypeId(CDAFactory.eINSTANCE.createInfrastructureRootTypeId());
        encounter.getTemplateIds().add((Object)DatatypesFactory.eINSTANCE.createII());
        encounter.getIds().add((Object)DatatypesFactory.eINSTANCE.createII());
        encounter.setCode(DatatypesFactory.eINSTANCE.createCD());
        encounter.setText(DatatypesFactory.eINSTANCE.createED());
        encounter.setStatusCode(DatatypesFactory.eINSTANCE.createCS());
        encounter.setEffectiveTime(DatatypesFactory.eINSTANCE.createIVL_TS());
        encounter.getSDTCDischargeDispositionCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("1", "1"));
        encounter.getSDTCDischargeDispositionCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("2", "1"));
        encounter.getSDTCDischargeDispositionCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("3", "1"));
        encounter.getSDTCDischargeDispositionCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("4", "1"));
        encounter.getSDTCDischargeDispositionCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("5", "1"));
        encounter.getSDTCDischargeDispositionCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("6", "1"));
        encounter.setPriorityCode(DatatypesFactory.eINSTANCE.createCE());
        encounter.setSubject(CDAFactory.eINSTANCE.createSubject());
        encounter.getSpecimens().add((Object)CDAFactory.eINSTANCE.createSpecimen());
        encounter.getPerformers().add((Object)CDAFactory.eINSTANCE.createPerformer2());
        encounter.getAuthors().add((Object)CDAFactory.eINSTANCE.createAuthor());
        encounter.getInformants().add((Object)CDAFactory.eINSTANCE.createInformant12());
        encounter.getParticipants().add((Object)CDAFactory.eINSTANCE.createParticipant2());
        encounter.addAct(CDAFactory.eINSTANCE.createAct());
        encounter.addEncounter(CDAFactory.eINSTANCE.createEncounter());
        encounter.addObservation(CDAFactory.eINSTANCE.createObservation());
        encounter.addObservationMedia(CDAFactory.eINSTANCE.createObservationMedia());
        encounter.addOrganizer(CDAFactory.eINSTANCE.createOrganizer());
        encounter.addProcedure(CDAFactory.eINSTANCE.createProcedure());
        encounter.addRegionOfInterest(CDAFactory.eINSTANCE.createRegionOfInterest());
        encounter.addSubstanceAdministration(CDAFactory.eINSTANCE.createSubstanceAdministration());
        encounter.addSupply(CDAFactory.eINSTANCE.createSupply());
        encounter.getReferences().add((Object)CDAFactory.eINSTANCE.createReference());
        encounter.getPreconditions().add((Object)CDAFactory.eINSTANCE.createPrecondition());
        encounter.setNullFlavor(NullFlavor.ASKU);
        encounter.setClassCode(ActClass.ACCM);
        encounter.setMoodCode(x_DocumentEncounterMood.APT);
        section.addEncounter(encounter);
        CDAUtil.save(doc, new FileOutputStream("samples/sdtcdischargedispositioncodes.xml"));
        ClinicalDocument clinicalDocument = CDAUtil.load(new FileInputStream("samples/sdtcdischargedispositioncodes.xml"));
        for (Section s : clinicalDocument.getSections()) {
            for (Entry e : s.getEntries()) {
                if (e.getEncounter() == null) continue;
                for (CE ce : e.getEncounter().getSDTCDischargeDispositionCodes()) {
                    System.out.println("Test Codes " + ce.getCode());
                }
            }
        }
        CDAUtil.save(clinicalDocument, new FileOutputStream("samples/sdtcdischargedispositioncodes2.xml"));
    }

    public static void main(String[] args) throws Exception {
        ValidationResult result = new ValidationResult();
        ClinicalDocument clinicalDocument = CDAUtil.load((InputStream)new FileInputStream("samples/Sample_CCDA_CCD_b1_Ambulatory_v2.xml"), (CDAUtil.ValidationHandler)result);
        System.out.println("\n***** Reserialization of sample *****");
        System.out.println(clinicalDocument);
        CDAUtil.save(clinicalDocument, System.out);
        System.out.println();
        System.out.println("\n***** Sample validation results *****");
        for (Diagnostic diagnostic : result.getErrorDiagnostics()) {
            System.out.println("ERROR: " + diagnostic.getMessage());
        }
        for (Diagnostic diagnostic : result.getWarningDiagnostics()) {
            System.out.println("WARNING: " + diagnostic.getMessage());
        }
        System.out.println("Number of Schema Validation Diagnostics: " + result.getSchemaValidationDiagnostics().size());
        System.out.println("Number of EMF Resource Diagnostics: " + result.getEMFResourceDiagnostics().size());
        System.out.println("Number of EMF Validation Diagnostics: " + result.getEMFValidationDiagnostics().size());
        System.out.println("Number of Total Diagnostics: " + result.getAllDiagnostics().size());
        if (!result.hasErrors()) {
            System.out.println("Document is valid");
        } else {
            System.out.println("Document is invalid");
        }
        Main.testSDTCDischargeDispositionCodes();
    }
}

