/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.mdht.cda.xml.CDAValidationReport;
import org.eclipse.mdht.cda.xml.ui.Activator;
import org.eclipse.mdht.emf.runtime.resource.FleXMLResourceSet;
import org.eclipse.mdht.uml.cda.DocumentRoot;
import org.eclipse.mdht.uml.cda.ui.util.DocumentClassDialog;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.cda.util.ValidationResult;
import org.eclipse.mdht.uml.cda.validate.XPathIndexer;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.xml.core.internal.validation.XMLNestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.AbstractNestedValidator;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xml.core.internal.validation.eclipse.XMLMessageInfoHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Validator
extends AbstractNestedValidator {
    private static final String CDA_VALIDATOR_CONTEXT = "org.eclipse.mdht.cda.xml.validatorContext";

    private static void parse(CDAValidationReport valreport, String cdauri, IPath filePath) {
        String DELIMITER = "~";
        try {
            BufferedReader br = new BufferedReader(new FileReader(filePath.toFile()));
            String strLine = "";
            while ((strLine = br.readLine()) != null) {
                String[] diagnostic = strLine.split("~");
                int diagnosticLine = Integer.valueOf(diagnostic[1]);
                int diagnosticColumn = Integer.valueOf(diagnostic[2]);
                if ("error".equals(diagnostic[0])) {
                    valreport.addError(diagnostic[3], diagnosticLine, diagnosticColumn, cdauri);
                }
                if (!"warning".equals(diagnostic[0])) continue;
                valreport.addWarning(diagnostic[3], diagnosticLine, diagnosticColumn, cdauri);
            }
            br.close();
        }
        catch (Exception e) {
            valreport.addError(e.getMessage(), 0, 0, cdauri);
        }
    }

    protected void addInfoToMessage(ValidationMessage validationMessage, IMessage message) {
        String key = validationMessage.getKey();
        if (key != null) {
            XMLMessageInfoHelper messageInfoHelper = new XMLMessageInfoHelper();
            String[] messageInfo = messageInfoHelper.createMessageInfo(key, validationMessage.getMessageArguments());
            message.setAttribute("columnNumber", (Object)new Integer(validationMessage.getColumnNumber()));
            message.setAttribute("squiggleSelectionStrategy", (Object)messageInfo[0]);
            message.setAttribute("squiggleNameOrValue", (Object)messageInfo[1]);
        }
    }

    protected NestedValidatorContext getNestedContext(ValidationState state, boolean create) {
        XMLNestedValidatorContext context = null;
        Object o = state.get(CDA_VALIDATOR_CONTEXT);
        if (o instanceof XMLNestedValidatorContext) {
            context = (XMLNestedValidatorContext)o;
        } else if (create) {
            context = new XMLNestedValidatorContext();
        }
        return context;
    }

    protected void setupValidation(NestedValidatorContext context) {
        super.setupValidation(context);
    }

    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context) {
        return this.validate(uri, inputstream, context, null);
    }

    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context, org.eclipse.wst.validation.ValidationResult result) {
        CDAValidationReport valreport = new CDAValidationReport(uri);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(uri);
            Element docElement = doc.getDocumentElement();
            if (!"ClinicalDocument".equals(docElement.getLocalName()) || !"urn:hl7-org:v3".equals(docElement.getNamespaceURI())) {
                return valreport;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IProject activeProject = null;
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        URI cdaDocumentURI = URI.createURI((String)uri.replace(".doc", ""));
        cdaDocumentURI = URI.createURI((String)uri.replace(".model", ""));
        String[] xmlDocumentSegments = cdaDocumentURI.segments();
        int segmentCtr = 0;
        IProject[] iProjectArray = myWorkspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                URI projectURI = URI.createURI((String)project.getLocationURI().getPath());
                String[] projectSegments = projectURI.segments();
                segmentCtr = 0;
                while (segmentCtr < xmlDocumentSegments.length && segmentCtr < projectSegments.length) {
                    if (!xmlDocumentSegments[segmentCtr].equals(projectSegments[segmentCtr])) break;
                    ++segmentCtr;
                }
                if (segmentCtr == projectSegments.length) {
                    activeProject = project;
                    break;
                }
            }
            ++n2;
        }
        IPath validationsPath = Activator.getDefault().getStateLocation().append(String.valueOf(cdaDocumentURI.segment(cdaDocumentURI.segmentCount() - 1)) + "validations");
        DocumentClassDialog docClassDialog = new DocumentClassDialog();
        String documentClassQName = docClassDialog.selectDocumentClass();
        if (!DocumentClassDialog.CANCELLED.equals(documentClassQName)) {
            if (docClassDialog.isWorkspaceMode()) {
                this.validateWorkspaceMode(activeProject, uri, validationsPath, documentClassQName, valreport);
            } else {
                this.validatePluginMode(activeProject, uri, validationsPath, documentClassQName, valreport);
            }
        }
        return valreport;
    }

    private static String getPath(EObject eObject) {
        String path = "";
        while (eObject != null && !(eObject instanceof DocumentRoot)) {
            EStructuralFeature feature = eObject.eContainingFeature();
            EObject container = eObject.eContainer();
            Object value = container.eGet(feature);
            if (feature.isMany()) {
                List list = (List)value;
                int index = list.indexOf(eObject) + 1;
                path = "/" + feature.getName() + "[" + index + "]" + path;
            } else {
                path = "/" + feature.getName() + "[1]" + path;
            }
            eObject = eObject.eContainer();
        }
        return path;
    }

    private void validatePluginMode(IProject activeProject, String uri, IPath validationsPath, String documentClassQName, CDAValidationReport valreport) {
        try {
            XPathIndexer.ElementLocationData eld;
            String path;
            XMLReader parser = XMLReaderFactory.createXMLReader();
            XPathIndexer xpathIndexer = new XPathIndexer();
            URI cdaURI = URI.createURI((String)uri);
            parser.setContentHandler((ContentHandler)xpathIndexer);
            parser.parse(cdaURI.path());
            ValidationResult vr = new ValidationResult();
            FleXMLResourceSet rset = CDAUtil.createResourceSet((String)documentClassQName);
            CDAUtil.load((ResourceSet)rset, (URI)cdaURI, (CDAUtil.ValidationHandler)vr);
            for (Diagnostic diagnostic : vr.getErrorDiagnostics()) {
                path = "";
                if (diagnostic.getData().size() > 0 && diagnostic.getData().get(0) instanceof EObject) {
                    path = Validator.getPath((EObject)diagnostic.getData().get(0));
                }
                if ((eld = xpathIndexer.getElementLocationByPath(path.toUpperCase())) != null) {
                    valreport.addError(diagnostic.getMessage(), eld.line, eld.column, uri);
                    continue;
                }
                valreport.addError(diagnostic.getMessage(), 0, 0, uri);
            }
            for (Diagnostic diagnostic : vr.getWarningDiagnostics()) {
                path = "";
                if (diagnostic.getData().size() > 0 && diagnostic.getData().get(0) instanceof EObject) {
                    path = Validator.getPath((EObject)diagnostic.getData().get(0));
                }
                if ((eld = xpathIndexer.getElementLocationByPath(path.toUpperCase())) != null) {
                    valreport.addWarning(diagnostic.getMessage(), eld.line, eld.column, uri);
                    continue;
                }
                valreport.addWarning(diagnostic.getMessage(), 0, 0, uri);
            }
            for (Diagnostic diagnostic : vr.getInfoDiagnostics()) {
                path = "";
                if (diagnostic.getData().size() > 0 && diagnostic.getData().get(0) instanceof EObject) {
                    path = Validator.getPath((EObject)diagnostic.getData().get(0));
                }
                if ((eld = xpathIndexer.getElementLocationByPath(path.toUpperCase())) != null) {
                    valreport.addWarning(diagnostic.getMessage(), eld.line, eld.column, uri);
                    continue;
                }
                valreport.addWarning(diagnostic.getMessage(), 0, 0, uri);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateWorkspaceMode(IProject activeProject, String uri, IPath validationsPath, String documentClassQName, CDAValidationReport valreport) {
        ILaunch launch = null;
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, "ValidateCDA");
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.mdht.uml.cda.validate.Validate");
            String validateArguments = String.format(" \"%s\" \"%s\" \"%s\"  ", uri, validationsPath.toOSString(), documentClassQName);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, validateArguments);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, activeProject.getName());
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS", true);
            workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
            File validationFile = validationsPath.toFile();
            validationFile.delete();
            launch = workingCopy.launch("run", null);
            boolean terminated = false;
            while (!terminated) {
                IProcess[] iProcessArray = launch.getProcesses();
                int n = iProcessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess process = iProcessArray[n2];
                    terminated = process.isTerminated();
                    ++n2;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    terminated = true;
                }
            }
            Validator.parse(valreport, uri, validationsPath);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
        if (project != null) {
            super.validationFinishing(project, state, monitor);
            NestedValidatorContext context = this.getNestedContext(state, false);
            if (context != null) {
                this.teardownValidation(context);
                state.put(CDA_VALIDATOR_CONTEXT, null);
            }
        }
    }

    public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
        if (project != null) {
            NestedValidatorContext context = this.getNestedContext(state, false);
            if (context == null) {
                context = this.getNestedContext(state, true);
                this.setupValidation(context);
                state.put(CDA_VALIDATOR_CONTEXT, (Object)context);
            }
            super.validationStarting(project, state, monitor);
        }
    }
}

