/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.html.parser.ParserDelegator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.cda.xml.ui.handlers.GenerateCDADataHandler;
import org.eclipse.mdht.uml.cda.AssignedAuthor;
import org.eclipse.mdht.uml.cda.Author;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.hl7.datatypes.AD;
import org.eclipse.mdht.uml.hl7.datatypes.ADXP;
import org.eclipse.mdht.uml.hl7.datatypes.ANY;
import org.eclipse.mdht.uml.hl7.datatypes.CD;
import org.eclipse.mdht.uml.hl7.datatypes.ED;
import org.eclipse.mdht.uml.hl7.datatypes.EN;
import org.eclipse.mdht.uml.hl7.datatypes.ENXP;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.datatypes.IVL_PQ;
import org.eclipse.mdht.uml.hl7.datatypes.IVL_TS;
import org.eclipse.mdht.uml.hl7.datatypes.ON;
import org.eclipse.mdht.uml.hl7.datatypes.PN;
import org.eclipse.mdht.uml.hl7.datatypes.PQ;
import org.eclipse.mdht.uml.hl7.datatypes.REAL;
import org.eclipse.mdht.uml.hl7.datatypes.TEL;
import org.eclipse.mdht.uml.hl7.datatypes.util.DatatypesSwitch;

public class CDAValueUtil {
    static final SimpleDateFormat DATE_FORMAT1 = new SimpleDateFormat("yyyy");
    static final SimpleDateFormat DATE_FORMAT10 = new SimpleDateFormat("yyyyMMddHHmmZ");
    static final SimpleDateFormat DATE_FORMAT11 = new SimpleDateFormat("yyyyMMddHHmmssZ");
    static final SimpleDateFormat DATE_FORMAT12 = new SimpleDateFormat("yyyyMMddHHmmssSSSZ");
    static final SimpleDateFormat DATE_FORMAT2 = new SimpleDateFormat("yyyyMM");
    static final SimpleDateFormat DATE_FORMAT3 = new SimpleDateFormat("yyyyMMdd");
    static final SimpleDateFormat DATE_FORMAT4 = new SimpleDateFormat("yyyyMMdd");
    static final SimpleDateFormat DATE_FORMAT5 = new SimpleDateFormat("yyyyMMddHH");
    static final SimpleDateFormat DATE_FORMAT6 = new SimpleDateFormat("yyyyMMddHHmm");
    static final SimpleDateFormat DATE_FORMAT7 = new SimpleDateFormat("yyyyMMddHHmmss");
    static final SimpleDateFormat DATE_FORMAT8 = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    static final SimpleDateFormat DATE_FORMAT9 = new SimpleDateFormat("yyyyMMddHHZ");
    public static final SimpleDateFormat DATE_PRETTY = new SimpleDateFormat("MM/dd/yyyy");
    static final SimpleDateFormat DATETIME_PRETTY = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss Z");

    static String getAnyValue(Section section, ANY any) {
        GetValue getValue = new GetValue(section);
        if (any != null) {
            return (String)getValue.doSwitch((EObject)any);
        }
        return "";
    }

    static Date getDate(SimpleDateFormat format, String value) {
        try {
            if (value != null) {
                int l = value.length();
                if (value.contains("-") || value.contains("+")) {
                    l -= 4;
                }
                if (l == format.toPattern().length()) {
                    return format.parse(value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Date getDate(String value) {
        Date date = CDAValueUtil.getDate(DATE_FORMAT12, value);
        if (date != null) {
            return date;
        }
        date = CDAValueUtil.getDate(DATE_FORMAT11, value);
        if (date != null) {
            return date;
        }
        date = CDAValueUtil.getDate(DATE_FORMAT10, value);
        if (date != null) {
            return date;
        }
        date = CDAValueUtil.getDate(DATE_FORMAT9, value);
        if (date != null) {
            return date;
        }
        date = CDAValueUtil.getDate(DATE_FORMAT8, value);
        if (date != null) {
            return date;
        }
        date = CDAValueUtil.getDate(DATE_FORMAT7, value);
        if (date != null) {
            return date;
        }
        date = CDAValueUtil.getDate(DATE_FORMAT6, value);
        if (date != null) {
            return date;
        }
        date = CDAValueUtil.getDate(DATE_FORMAT5, value);
        if (date != null) {
            return date;
        }
        date = CDAValueUtil.getDate(DATE_FORMAT4, value);
        if (date != null) {
            return date;
        }
        date = CDAValueUtil.getDate(DATE_FORMAT3, value);
        if (date != null) {
            return date;
        }
        date = CDAValueUtil.getDate(DATE_FORMAT2, value);
        if (date != null) {
            return date;
        }
        date = CDAValueUtil.getDate(DATE_FORMAT1, value);
        if (date != null) {
            return date;
        }
        return null;
    }

    static String getKey(II ii) {
        if (ii.getRoot() != null) {
            if (ii.getExtension() != null) {
                return String.valueOf(ii.getRoot()) + " :: " + ii.getExtension();
            }
        } else {
            return "noroot x " + ii.getExtension();
        }
        return "nokey";
    }

    static Object getKey2(II ii) {
        if (!StringUtils.isEmpty((String)ii.getExtension())) {
            return ii.getExtension();
        }
        if (!StringUtils.isEmpty((String)ii.getRoot())) {
            return ii.getRoot();
        }
        return "";
    }

    static String getKey3(II ii) {
        if (!StringUtils.isEmpty((String)ii.getRoot())) {
            if (!StringUtils.isEmpty((String)ii.getExtension())) {
                return String.valueOf(ii.getRoot()) + " :: " + ii.getExtension();
            }
        } else if (!StringUtils.isEmpty((String)ii.getExtension())) {
            return ii.getExtension();
        }
        return "";
    }

    static String getNarrativeText(String htmlString) throws IOException {
        StringReader reader = null;
        reader = new StringReader(htmlString);
        GenerateCDADataHandler.ExtractText extractText = new GenerateCDADataHandler.ExtractText();
        ParserDelegator parserDelegator = new ParserDelegator();
        parserDelegator.parse(reader, extractText, true);
        return extractText.getText();
    }

    static String getValue(IVL_PQ pq) {
        StringBuffer sb = new StringBuffer();
        if (pq != null && !pq.isSetNullFlavor()) {
            if (pq.getValue() != null) {
                sb.append(String.valueOf(pq.getValue().toPlainString()) + " ");
                String unit = StringUtils.isEmpty((String)pq.getUnit()) ? "" : pq.getUnit();
                sb.append(unit);
            }
            if (pq.getLow() != null && pq.getLow().getValue() != null) {
                sb.append(pq.getLow().getValue().toPlainString());
                if (pq.getLow().eIsSet(pq.getLow().eClass().getEStructuralFeature(2))) {
                    sb.append(" " + pq.getLow().getUnit());
                }
            }
            if (pq.getHigh() != null && pq.getHigh().getValue() != null) {
                if (sb.length() > 0) {
                    sb.append(" - ");
                }
                sb.append(pq.getHigh().getValue().toPlainString());
                if (pq.getHigh().eIsSet(pq.getHigh().eClass().getEStructuralFeature(2))) {
                    sb.append(" " + pq.getHigh().getUnit());
                }
            }
        }
        return sb.toString();
    }

    static String getValue(List<Author> authors, GenerateCDADataHandler.PorO poro) {
        String result = "";
        String authorId = "";
        Iterator<Author> iterator = authors.iterator();
        if (iterator.hasNext()) {
            Author a = iterator.next();
            Iterator iterator2 = a.getAssignedAuthor().getIds().iterator();
            if (iterator2.hasNext()) {
                II ii = (II)iterator2.next();
                authorId = CDAValueUtil.getKey3(ii);
            }
            if (a.getAssignedAuthor() != null) {
                AssignedAuthor aa = a.getAssignedAuthor();
                if (GenerateCDADataHandler.PorO.ORGANIZATION.equals((Object)poro) && aa.getRepresentedOrganization() != null) {
                    for (ON on : aa.getRepresentedOrganization().getNames()) {
                        result = CDAValueUtil.getValues((EN)on);
                    }
                }
                if (GenerateCDADataHandler.PorO.PERSON.equals((Object)poro) && aa.getAssignedPerson() != null) {
                    for (PN pn : aa.getAssignedPerson().getNames()) {
                        result = CDAValueUtil.getValues((EN)pn);
                    }
                }
            }
        }
        if (!StringUtils.isEmpty((String)authorId) && StringUtils.isEmpty((String)result)) {
            if (GenerateCDADataHandler.PorO.ORGANIZATION.equals((Object)poro)) {
                if (GenerateCDADataHandler.organizations.containsKey(authorId)) {
                    result = String.valueOf(GenerateCDADataHandler.organizations.get(authorId)) + "*";
                }
            } else if (GenerateCDADataHandler.authors.containsKey(authorId)) {
                result = String.valueOf(GenerateCDADataHandler.authors.get(authorId)) + "*";
            }
        }
        if (StringUtils.isEmpty((String)result) && !StringUtils.isEmpty((String)authorId)) {
            result = authorId;
        }
        return result;
    }

    static String getValue(PQ pq) {
        StringBuffer sb = new StringBuffer();
        if (pq != null && !pq.isSetNullFlavor()) {
            if (pq.getValue() != null) {
                sb.append(String.valueOf(pq.getValue().toPlainString()) + " ");
            }
            if (!GenerateCDADataHandler.omitUnits) {
                String unit = StringUtils.isEmpty((String)pq.getUnit()) ? "" : pq.getUnit();
                sb.append(unit);
            }
        }
        return sb.toString();
    }

    public static String getValue(REAL real) {
        StringBuffer sb = new StringBuffer();
        if (real != null && real.getValue() != null) {
            sb.append(String.valueOf(real.getValue().toPlainString()) + " ");
        }
        return sb.toString();
    }

    static String getValue(Section section, ED ed) {
        if (section != null && ed != null) {
            if (!StringUtils.isEmpty((String)StringUtils.trim((String)ed.getText()))) {
                return ed.getText();
            }
            if (ed.getReference() != null) {
                String reference = ed.getReference().getValue();
                if (!StringUtils.isEmpty((String)reference) && section.getText() != null) {
                    String result = section.getText().getText(reference.substring(1));
                    if (!StringUtils.isEmpty((String)result)) {
                        return StringUtils.abbreviate((String)result, (int)1000);
                    }
                    return "Narrative does not match structure, Issue: ID " + reference + " not found in narrative " + reference;
                }
                return "Narrative does not match structure, Issue: Reference value is missing ";
            }
            return "Narrative does not match structure, Issue: Text Element has no content and reference is missing ";
        }
        return "";
    }

    public static String getValueAsString(IVL_TS ivlts) {
        StringBuffer sb = new StringBuffer();
        if (ivlts != null) {
            if (ivlts.getLow() != null && !StringUtils.isEmpty((String)ivlts.getLow().getValue())) {
                sb.append(ivlts.getLow().getValue());
            }
            if (ivlts.getHigh() != null && !StringUtils.isEmpty((String)ivlts.getHigh().getValue())) {
                sb.append(ivlts.getHigh().getValue());
            }
        }
        return sb.toString();
    }

    static String getValueAsString(Section section, CD cd) {
        StringBuffer sb = new StringBuffer();
        if (cd != null) {
            if (!StringUtils.isEmpty((String)cd.getDisplayName())) {
                sb.append(cd.getDisplayName());
            } else if (cd.getOriginalText() != null && cd.getOriginalText().getReference() != null) {
                String reference = cd.getOriginalText().getReference().getValue();
                if (!StringUtils.isEmpty((String)reference) && section.getText() != null) {
                    String result = section.getText().getText(reference.substring(1));
                    if (!StringUtils.isEmpty((String)result)) {
                        sb.append(result);
                    } else {
                        sb.append("Missing in narrative " + reference);
                    }
                } else {
                    sb.append("Reference Value Missing.");
                }
            } else if (cd.getOriginalText() != null && !StringUtils.isEmpty((String)cd.getOriginalText().getText())) {
                sb.append(cd.getOriginalText().getText());
            } else if (cd.isNullFlavorDefined()) {
                sb.append(cd.getNullFlavor());
            }
        }
        return sb.toString();
    }

    static String getValueAsString(TEL tel) {
        StringBuffer sb = new StringBuffer();
        if (tel != null) {
            if (!StringUtils.isEmpty((String)tel.getValue())) {
                sb.append(tel.getValue());
            } else if (tel.isNullFlavorDefined()) {
                sb.append(tel.getNullFlavor());
            }
            if (!tel.getUses().isEmpty()) {
                sb.append(" " + tel.getUses().get(0));
            }
        }
        return sb.toString();
    }

    public static String getValues(List<ADXP> values) {
        StringBuffer b = new StringBuffer();
        for (ADXP a : values) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append(a.getText());
        }
        return b.toString();
    }

    public static String getValues(AD ad) {
        StringBuffer b = new StringBuffer();
        for (ADXP a : ad.getStreetAddressLines()) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append(a.getText());
        }
        for (ADXP a : ad.getStates()) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append(a.getText());
        }
        return b.toString();
    }

    public static String getValues(EN pn) {
        if (pn.getText() != null && pn.getText().trim().length() > 0) {
            GenerateCDADataHandler.names.add(pn.getText());
            return pn.getText();
        }
        StringBuffer b = new StringBuffer();
        for (ENXP e : pn.getPrefixes()) {
            if (b.length() > 0) {
                b.append(" ");
            }
            GenerateCDADataHandler.names.add(e.getText());
            b.append(e.getText());
        }
        for (ENXP e : pn.getGivens()) {
            if (b.length() > 0) {
                b.append(" ");
            }
            GenerateCDADataHandler.names.add(e.getText());
            b.append(e.getText());
        }
        for (ENXP e : pn.getFamilies()) {
            if (b.length() > 0) {
                b.append(" ");
            }
            GenerateCDADataHandler.names.add(e.getText());
            b.append(e.getText());
        }
        for (ENXP e : pn.getSuffixes()) {
            if (b.length() > 0) {
                b.append(" ");
            }
            GenerateCDADataHandler.names.add(e.getText());
            b.append(e.getText());
        }
        return b.toString();
    }

    static String getValues(II ii) {
        return String.valueOf(StringUtils.isEmpty((String)ii.getRoot()) ? "" : ii.getRoot()) + (!StringUtils.isEmpty((String)ii.getRoot()) && !StringUtils.isEmpty((String)ii.getExtension()) ? ":" : "") + (StringUtils.isEmpty((String)ii.getExtension()) ? "" : ii.getExtension());
    }

    static class DocumentMetadata {
        public Date documentDate = null;
        public String documentLibrary = "";
        public String documentOrganization = "";
        public String documentRootID = "";
        public String documentSoftware = "";
        public String documentType = "";
        public String documentCode = "";
        public String documentCodeSystem = "";
        public String documentTemplateId = "";
        public String fileName = "";
        public String pcpAddress;
        public String pcpName;
        public String completePath;

        DocumentMetadata() {
        }
    }

    protected static class GetValue
    extends DatatypesSwitch<String> {
        Section section;

        public GetValue(Section section) {
            this.section = section;
        }

        public String caseCD(CD object) {
            return CDAValueUtil.getValueAsString(this.section, object);
        }

        public String caseED(ED object) {
            return CDAValueUtil.getValue(this.section, object);
        }

        public String caseII(II object) {
            return CDAValueUtil.getValues(object);
        }

        public String caseON(ON object) {
            return CDAValueUtil.getValues((EN)object);
        }

        public String casePN(PN object) {
            return CDAValueUtil.getValues((EN)object);
        }

        public String casePQ(PQ object) {
            return CDAValueUtil.getValue(object);
        }

        public String caseIVL_PQ(IVL_PQ object) {
            return CDAValueUtil.getValue(object);
        }

        public String caseREAL(REAL object) {
            return CDAValueUtil.getValue(object);
        }

        public String defaultCase(EObject object) {
            return "MISSING GET VALUE FOR" + object.eClass().getName();
        }
    }
}

