/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.mdht.cda.xml.ui.editors.CDAAnalyzer;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.util.CDADiagnostic;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.cda.util.ValidationResult;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.part.ViewPart;

public class ValidationsView
extends ViewPart {
    Browser browser;

    private static void handleDiagnostic(Diagnostic diagnostic, CDAUtil.ValidationHandler handler) {
        switch (diagnostic.getSeverity()) {
            case 4: {
                handler.handleError(diagnostic);
                break;
            }
            case 2: {
                handler.handleWarning(diagnostic);
                break;
            }
            case 1: {
                handler.handleInfo(diagnostic);
            }
        }
    }

    private static boolean shouldHandle(Diagnostic diagnostic) {
        return diagnostic.getMessage() != null && !diagnostic.getMessage().startsWith("Diagnosis of");
    }

    private static void processDiagnostic(Diagnostic diagnostic, CDAUtil.ValidationHandler handler) {
        LinkedList<Diagnostic> queue = new LinkedList<Diagnostic>();
        queue.add(diagnostic);
        while (!queue.isEmpty()) {
            Diagnostic d = (Diagnostic)queue.remove();
            if (ValidationsView.shouldHandle(d)) {
                ValidationsView.handleDiagnostic(d, handler);
            }
            for (Diagnostic childDiagnostic : d.getChildren()) {
                queue.add(childDiagnostic);
            }
        }
    }

    public void addTableListener(Table table) {
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.item.getData() instanceof Section) {
                    ArrayList mapValues;
                    CDADiagnosticCounter cdaDiagnosticCounter;
                    String key;
                    TableItem ti;
                    String filename = "";
                    if (event.item instanceof TableItem && !StringUtils.isEmpty((String)(ti = (TableItem)event.item).getParent().getToolTipText())) {
                        filename = ti.getParent().getToolTipText();
                    }
                    Section section = (Section)event.item.getData();
                    String sectionTitle = "";
                    if (section.getTitle() != null && section.getTitle().getText() != null) {
                        sectionTitle = section.getTitle().getText().toUpperCase();
                    }
                    HashMap<String, CDADiagnosticCounter> errorsResultMap = new HashMap<String, CDADiagnosticCounter>();
                    HashMap<String, CDADiagnosticCounter> warningsResultMap = new HashMap<String, CDADiagnosticCounter>();
                    HashMap<String, CDADiagnosticCounter> informationResultMap = new HashMap<String, CDADiagnosticCounter>();
                    Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)section);
                    ValidationResult vr = new ValidationResult();
                    StringBuffer sb = new StringBuffer();
                    if (diagnostic.getChildren().size() > 0) {
                        ValidationsView.processDiagnostic(diagnostic, (CDAUtil.ValidationHandler)vr);
                    }
                    for (Diagnostic dq : vr.getErrorDiagnostics()) {
                        key = String.format("%s::%d", dq.getSource(), dq.getCode());
                        if (!errorsResultMap.containsKey(key)) {
                            cdaDiagnosticCounter = new CDADiagnosticCounter(new CDADiagnostic(dq));
                            errorsResultMap.put(key, cdaDiagnosticCounter);
                        }
                        ((CDADiagnosticCounter)errorsResultMap.get(key)).incrementCount();
                    }
                    for (Diagnostic dq : vr.getWarningDiagnostics()) {
                        key = String.format("%s::%d", dq.getSource(), dq.getCode());
                        if (!warningsResultMap.containsKey(key)) {
                            cdaDiagnosticCounter = new CDADiagnosticCounter(new CDADiagnostic(dq));
                            warningsResultMap.put(key, cdaDiagnosticCounter);
                        }
                        ((CDADiagnosticCounter)warningsResultMap.get(key)).incrementCount();
                    }
                    for (Diagnostic dq : vr.getInfoDiagnostics()) {
                        key = String.format("%s::%d", dq.getSource(), dq.getCode());
                        if (!informationResultMap.containsKey(key)) {
                            cdaDiagnosticCounter = new CDADiagnosticCounter(new CDADiagnostic(dq));
                            informationResultMap.put(key, cdaDiagnosticCounter);
                        }
                        ((CDADiagnosticCounter)informationResultMap.get(key)).incrementCount();
                    }
                    Comparator<CDADiagnosticCounter> comparator = new Comparator<CDADiagnosticCounter>(){

                        @Override
                        public int compare(CDADiagnosticCounter o1, CDADiagnosticCounter o2) {
                            if (o1.getCount() > o2.getCount()) {
                                return -1;
                            }
                            if (o1.getCount() < o2.getCount()) {
                                return 1;
                            }
                            return 0;
                        }
                    };
                    sb.append("<table width=\"100%\" border=\"1\">" + sectionTitle + " SECTION VALIDATION (" + filename + ")<br><thead><tr><th colspan=\"2\">ERRORS</th></tr><tr><th>Count</th><th>Description</th></tr></thead>");
                    if (!errorsResultMap.isEmpty()) {
                        ArrayList errorsMapValues = new ArrayList(errorsResultMap.values());
                        Collections.sort(errorsMapValues, comparator);
                        for (CDADiagnosticCounter cdc : errorsMapValues) {
                            sb.append("<tr><td>" + cdc.getCount() + "</td><td><small>" + cdc.getCdaDiagnosticq().getMessage() + "</small></td></tr>");
                        }
                    } else {
                        sb.append("<tr><td colspan='10'>NO ERRORS FOR " + filename + "</td><tr>");
                    }
                    sb.append("</table>");
                    sb.append("<table width=\"100%\" border=\"1\"><thead><tr><th colspan=\"2\">WARNINGS</th></tr><tr><th>Count</th><th>Description</th></tr></thead>");
                    if (!warningsResultMap.isEmpty()) {
                        mapValues = new ArrayList(warningsResultMap.values());
                        Collections.sort(mapValues, comparator);
                        for (CDADiagnosticCounter cdc : mapValues) {
                            sb.append("<tr><td>" + cdc.getCount() + "</td><td><small>" + cdc.getCdaDiagnosticq().getMessage() + "</small></td><tr>");
                        }
                    } else {
                        sb.append("<tr><td colspan='10'>NO WARNINGS</td></tr>");
                    }
                    sb.append("</table>");
                    sb.append("<table width=\"100%\" border=\"1\"><thead><tr><th colspan=\"2\">INFORMATIONAL</th></tr><tr><th>Count</th><th>Description</th></tr></thead>");
                    if (!informationResultMap.isEmpty()) {
                        mapValues = new ArrayList(informationResultMap.values());
                        Collections.sort(mapValues, comparator);
                        for (CDADiagnosticCounter cdc : mapValues) {
                            sb.append("<tr><td>" + cdc.getCount() + "</td><td><small>" + cdc.getCdaDiagnosticq().getMessage() + "</small></td></tr>");
                        }
                    } else {
                        sb.append("<tr><td colspan='10'>NO INFORMATIONAL</td></tr>");
                    }
                    sb.append("</table>");
                    ValidationsView.this.browser.setText(sb.toString());
                }
            }
        });
    }

    public void clearView() {
        this.browser.setText("");
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 2048);
        Menu menu = new Menu((Control)this.browser);
        MenuItem printMenuItem = new MenuItem(menu, 64);
        printMenuItem.setText("Print");
        printMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ValidationsView.this.browser.execute("window.print();");
            }
        });
        this.browser.setMenu(menu);
        if (this.getSite().getPage().getPerspective() != null) {
            IEditorReference[] iEditorReferenceArray = this.getSite().getPage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDAAnalyzer analyzer;
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if ("org.eclipse.mdht.cda.xml.ui.editors.CDAAnalyzer".equals(editorReference.getId()) && (analyzer = (CDAAnalyzer)editorReference.getEditor(false)) != null) {
                    this.addTableListener(analyzer.getTable());
                }
                ++n2;
            }
        }
    }

    public void setFocus() {
    }

    private static class CDADiagnosticCounter {
        private CDADiagnostic cdaDiagnosticq;
        private int count = 0;

        public CDADiagnostic getCdaDiagnosticq() {
            return this.cdaDiagnosticq;
        }

        public int getCount() {
            return this.count;
        }

        public void incrementCount() {
            ++this.count;
        }

        public CDADiagnosticCounter(CDADiagnostic cdaDiagnosticq) {
            this.cdaDiagnosticq = cdaDiagnosticq;
        }
    }
}

