/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SetOperator implements Enumerator
{
    A(0, "A", "A"),
    E(1, "E", "E"),
    H(2, "H", "H"),
    I(3, "I", "I"),
    P(4, "P", "P");

    public static final int A_VALUE = 0;
    public static final int E_VALUE = 1;
    public static final int H_VALUE = 2;
    public static final int I_VALUE = 3;
    public static final int P_VALUE = 4;
    private static final SetOperator[] VALUES_ARRAY;
    public static final List<SetOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SetOperator[]{A, E, H, I, P};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SetOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SetOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SetOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SetOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SetOperator get(int value) {
        switch (value) {
            case 0: {
                return A;
            }
            case 1: {
                return E;
            }
            case 2: {
                return H;
            }
            case 3: {
                return I;
            }
            case 4: {
                return P;
            }
        }
        return null;
    }

    private SetOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

