/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.util;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.CDAPackage;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.ui.internal.Logger;
import org.eclipse.mdht.uml.cda.ui.util.CDAUIUtil;
import org.eclipse.mdht.uml.common.UmlPlugin;
import org.eclipse.pde.ui.templates.PluginReference;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.osgi.framework.Bundle;

public class CDAProjectUtil {
    private Map<String, Package> cdaPackages = new HashMap<String, Package>();
    private Map<String, Type> cdaDocuments = new HashMap<String, Type>();
    private Map<String, IFile> cdaDocumentsManfiest = new HashMap<String, IFile>();
    private Map<String, IFile> cdaDocumentsGenModels = new HashMap<String, IFile>();
    private Map<String, PluginReference> references = new HashMap<String, PluginReference>();
    private Type clinicalDocument = null;

    public Map<String, Package> getCDAPackages() {
        return this.cdaPackages;
    }

    public Map<String, Type> getCDADocuments() {
        return this.cdaDocuments;
    }

    public Map<String, IFile> getCDADocumentsManfiests() {
        return this.cdaDocumentsManfiest;
    }

    public Map<String, IFile> getCDADocumentsGenModels() {
        return this.cdaDocumentsGenModels;
    }

    public Map<String, PluginReference> getReferences() {
        return this.references;
    }

    void loadCDAModelsfromWorkspace() {
        UmlPlugin.computeModelPathMapExtensions();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        Path model = new Path("model");
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && project.exists((IPath)model)) {
                IFile plugin = project.getFile("plugin.xml");
                IFolder folder = project.getFolder((IPath)model);
                try {
                    IResource[] iResourceArray = folder.members();
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource resource = iResourceArray[n4];
                        if (resource.getName().endsWith(".uml") && !resource.getName().contains("_Ecore")) {
                            Package p;
                            URI pathMap;
                            URI modelFile = null;
                            modelFile = plugin.exists() ? ((pathMap = UmlPlugin.getPathMap((InputStream)plugin.getContents())) != null ? pathMap.appendSegment(resource.getName()) : URI.createFileURI((String)project.getFolder((IPath)model).getFile(resource.getName()).getRawLocation().toOSString())) : URI.createFileURI((String)project.getFolder((IPath)model).getFile(resource.getName()).getRawLocation().toOSString());
                            PackageableElement pe = (PackageableElement)EcoreUtil.getObjectByType((Collection)resourceSet.getResource(modelFile, true).getContents(), (EClassifier)UMLPackage.eINSTANCE.getPackageableElement());
                            if (pe != null && pe instanceof Package && ((p = (Package)pe).getAppliedProfile("CDA") != null || p.getName().equals("cda"))) {
                                IProject generatedProject = project;
                                if (project.getName().endsWith(".model")) {
                                    generatedProject = root.getProject(project.getName().replace(".model", ""));
                                }
                                this.cdaPackages.put(p.getQualifiedName(), p);
                                if (generatedProject.getFolder((IPath)model).exists()) {
                                    IResource[] iResourceArray2 = generatedProject.getFolder((IPath)model).members();
                                    int n5 = iResourceArray2.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        IResource genmodel = iResourceArray2[n6];
                                        if (genmodel.getName().endsWith(".genmodel")) {
                                            this.cdaDocumentsGenModels.put(p.getQualifiedName(), CDAUIUtil.getGenModel(generatedProject, genmodel.getProjectRelativePath()));
                                        }
                                        ++n6;
                                    }
                                }
                            }
                        }
                        ++n4;
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            ++n2;
        }
        Package cdaPackage = this.cdaPackages.get("cda");
        if (cdaPackage != null) {
            this.clinicalDocument = cdaPackage.getOwnedType("ClinicalDocument");
            for (Package ps : this.cdaPackages.values()) {
                for (Type type : ps.getOwnedTypes()) {
                    if (!CDAModelUtil.isClinicalDocument((Type)type)) continue;
                    this.cdaDocuments.put(type.getQualifiedName(), type);
                    this.cdaDocumentsGenModels.put(type.getQualifiedName(), this.cdaDocumentsGenModels.get(ps.getQualifiedName()));
                }
            }
        }
    }

    public void loadCDAModelsfromPlugins() {
        new ResourceSetImpl();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.emf.ecore.generated_package");
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ice = iConfigurationElementArray[n4];
                    String packageClassName = ice.getAttribute("class");
                    if (packageClassName != null) {
                        try {
                            Class packageClass = bundle.loadClass(packageClassName);
                            if (packageClass != null) {
                                Field eInstance = packageClass.getDeclaredField("eINSTANCE");
                                Field ePrefix = packageClass.getDeclaredField("eNS_PREFIX");
                                EPackage ePackage = (EPackage)eInstance.get(null);
                                String prefix = (String)ePrefix.get(null);
                                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                                    if (!(eClassifier instanceof EClass) || !CDAPackage.eINSTANCE.getClinicalDocument().isSuperTypeOf((EClass)eClassifier)) continue;
                                    this.cdaDocuments.put(String.valueOf(prefix) + "::" + eClassifier.getName(), null);
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

