/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.pde.internal.core.ICoreConstants;

public class CDAUIUtil {
    public static final String BUNDLE_ROOT_PATH = "BUNDLE_ROOT_PATH";
    public static final String BUNDLE_FILENAME_DESCRIPTOR = "META-INF/MANIFEST.MF";
    public static IPath MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");
    public static IPath MODEL_PATH = new Path("model");
    public static IPath DITA_PATH = new Path("dita");

    public static IFile getBundleRelativeFile(IProject project, IPath path) {
        return CDAUIUtil.getBundleRoot(project).getFile(path);
    }

    public static IFolder getBundleRelativeFolder(IProject project, IPath path) {
        return CDAUIUtil.getBundleRoot(project).getFolder(path);
    }

    public static IContainer getBundleRoot(IProject project) {
        String string;
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences node = scope.getNode("org.eclipse.pde.core");
        if (node != null && (string = node.get(BUNDLE_ROOT_PATH, null)) != null) {
            IPath path = Path.fromPortableString((String)string);
            return project.getFolder(path);
        }
        return project;
    }

    public static IFile getECoreModel(IProject project, IPath genmodelPath) {
        return CDAUIUtil.getBundleRelativeFile(project, genmodelPath);
    }

    public static URI getGeneratorModel(IProject project) {
        IFile generatorModelFile = CDAUIUtil.getProjectFile(project, MODEL_PATH, ".genmodel");
        if (generatorModelFile != null) {
            return URI.createFileURI((String)generatorModelFile.getRawLocation().toOSString());
        }
        return null;
    }

    public static IPath getGeneratorModelFile(IProject project) {
        IFile generatorModelFile = CDAUIUtil.getProjectFile(project, MODEL_PATH, ".genmodel");
        if (generatorModelFile != null) {
            return generatorModelFile.getFullPath();
        }
        return null;
    }

    public static IFile getGenModel(IProject project, IPath genmodelPath) {
        return CDAUIUtil.getBundleRelativeFile(project, genmodelPath);
    }

    public static IFile getManifest(IProject project) {
        return CDAUIUtil.getBundleRelativeFile(project, MANIFEST_PATH);
    }

    public static IFile getPluginXml(IProject project) {
        return CDAUIUtil.getBundleRelativeFile(project, ICoreConstants.PLUGIN_PATH);
    }

    public static IFile getProjectFile(IProject project, IPath folderPath, String fileExtension) {
        IFile fileResource = null;
        if (project.exists(folderPath)) {
            IFolder folder = project.getFolder(folderPath);
            try {
                folder.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource.getName().endsWith(fileExtension)) {
                        fileResource = (IFile)resource;
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return fileResource;
    }

    public static URI getUMLEcoreModel(IProject project) {
        IFile generatorModelFile = CDAUIUtil.getProjectFile(project, MODEL_PATH, "_Ecore.uml");
        if (generatorModelFile != null) {
            return URI.createFileURI((String)generatorModelFile.getRawLocation().toOSString());
        }
        return null;
    }

    public static IPath getUMLEcoreModelFile(IProject project) {
        IFile generatorModelFile = CDAUIUtil.getProjectFile(project, MODEL_PATH, "_Ecore.uml");
        if (generatorModelFile != null) {
            return generatorModelFile.getFullPath();
        }
        return null;
    }
}

