/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.uml2.uml.Type;

public class NewCDAModelPage
extends WizardPage {
    WizardNewProjectCreationPage newProjectPage;
    HashMap<String, Type> cdaDocuments;
    Combo combo;
    Text modelName;
    public Text cdaDocumentName;
    Text templateID;
    Text assigningAuthority;
    public Text basePackage;
    Text nsPrefix;
    Text nsURI;
    Text packageName;
    Text prefix;

    public void setNewProjectPage(WizardNewProjectCreationPage newProjectPage) {
        this.newProjectPage = newProjectPage;
    }

    public String getModelName() {
        return this.modelName.getText();
    }

    public String getBasePackage() {
        return this.basePackage.getText();
    }

    public String getNamespaceURI() {
        return this.nsURI.getText();
    }

    public String getCDADocumentName() {
        return this.cdaDocumentName.getText();
    }

    public String getTemplateId() {
        return this.templateID.getText();
    }

    public String getNsPrefix() {
        return this.nsPrefix.getText();
    }

    public String getNsURI() {
        return this.nsURI.getText();
    }

    public String getPrefix() {
        return this.prefix.getText();
    }

    public String getTemplateAssigningAuthority() {
        return this.assigningAuthority.getText();
    }

    public String getCDADocument() {
        return this.combo.getText();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    protected NewCDAModelPage(String pageName, String title, ImageDescriptor titleImage, HashMap<String, Type> cdaDocuments) {
        super(pageName, title, titleImage);
        this.cdaDocuments = cdaDocuments;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        new Label(composite, 0).setText("Implementation Guide Namespace ");
        this.modelName = new Text(composite, 0);
        this.modelName.setLayoutData((Object)new GridData(256));
        new Label(composite, 0).setText("Document ");
        this.cdaDocumentName = new Text(composite, 0);
        this.cdaDocumentName.setLayoutData((Object)new GridData(256));
        new Label(composite, 0).setText("CDA Document Conformance Reference ");
        this.combo = new Combo(composite, 12);
        new Label(composite, 0).setText("Template ID (Optional) ");
        this.templateID = new Text(composite, 0);
        this.templateID.setLayoutData((Object)new GridData(256));
        new Label(composite, 0).setText("Assigning Authority (Optional) ");
        this.assigningAuthority = new Text(composite, 0);
        this.assigningAuthority.setLayoutData((Object)new GridData(256));
        int current = 0;
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.cdaDocuments.keySet());
        Collections.sort(list);
        for (String key : list) {
            this.combo.add(key);
            if (key.equalsIgnoreCase("cda::ClinicalDocument")) {
                this.combo.select(current);
            }
            ++current;
        }
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCDAModelPage.this.packageName.setText(NewCDAModelPage.this.cdaDocumentName.getText().toLowerCase());
                NewCDAModelPage.this.nsPrefix.setText(NewCDAModelPage.this.modelName.getText().toLowerCase());
                NewCDAModelPage.this.prefix.setText(NewCDAModelPage.this.modelName.getText().toUpperCase());
                NewCDAModelPage.this.nsURI.setText(NewCDAModelPage.generateNSURI(NewCDAModelPage.this.basePackage.getText(), NewCDAModelPage.this.modelName.getText().toLowerCase()));
                NewCDAModelPage.this.setPageComplete(false);
                NewCDAModelPage.this.setPageComplete(NewCDAModelPage.this.basePackage.getText().matches("[A-Za-z0-9\\.]*") && NewCDAModelPage.this.modelName.getText().length() > 0 && NewCDAModelPage.this.cdaDocumentName.getText().length() > 0);
            }
        };
        this.modelName.addModifyListener(listener);
        this.cdaDocumentName.addModifyListener(listener);
        new Label(composite, 0).setText("Document Base Package");
        this.basePackage = new Text(composite, 0);
        this.basePackage.setText("org.eclipse.mdht.uml.cda");
        this.basePackage.setLayoutData((Object)new GridData(256));
        this.basePackage.addModifyListener(listener);
        new Label(composite, 0).setText("Namespace URI");
        this.nsURI = new Text(composite, 0);
        this.nsURI.setLayoutData((Object)new GridData(256));
        new Label(composite, 0).setText("Document Namespace Prefix ");
        this.nsPrefix = new Text(composite, 15);
        this.nsPrefix.setLayoutData((Object)new GridData(256));
        new Label(composite, 0).setText("Package Name ");
        this.packageName = new Text(composite, 15);
        this.packageName.setLayoutData((Object)new GridData(256));
        new Label(composite, 0).setText("Prefix ");
        this.prefix = new Text(composite, 0);
        this.prefix.setLayoutData((Object)new GridData(256));
        this.setPageComplete(false);
    }

    private static String generateNSURI(String basepackage, String modelName) {
        StringBuffer sb = new StringBuffer();
        sb.append("http://www.");
        String[] segments = basepackage.split("\\.");
        sb.append(segments.length > 2 ? segments[1] : "").append(".");
        sb.append(segments.length > 1 ? segments[0] : "");
        int segmentCtr = 2;
        while (segmentCtr < segments.length) {
            sb.append("/").append(segments[segmentCtr]);
            ++segmentCtr;
        }
        sb.append("/").append(modelName);
        return sb.toString();
    }
}

