/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform.ecore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.AnnotationsUtil;
import org.eclipse.mdht.uml.transform.ecore.IEcoreProfileReflection;
import org.eclipse.mdht.uml.transform.ecore.TransformAbstract;
import org.eclipse.mdht.uml.transform.internal.Logger;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;

public abstract class TransformPropertyConstraint
extends TransformAbstract {
    private final List<PropertyConstraintHandler> constraintHandlers = new ArrayList<PropertyConstraintHandler>();

    public TransformPropertyConstraint(TransformerOptions options, IBaseModelReflection baseModelReflection) {
        super(options, baseModelReflection);
        this.createConstraintHandlers();
    }

    private void createConstraintHandlers() {
        List<IEcoreProfileReflection.ValidationStereotypeKind> kinds = Arrays.asList(IEcoreProfileReflection.ValidationStereotypeKind.CODE_SYSTEM, IEcoreProfileReflection.ValidationStereotypeKind.VALUE_SET, IEcoreProfileReflection.ValidationStereotypeKind.VOCAB_SPECIFICATION, IEcoreProfileReflection.ValidationStereotypeKind.PROPERTY);
        for (IEcoreProfileReflection.ValidationStereotypeKind next : kinds) {
            TransformPropertyConstraint.addIfNotNull(this.createConstraintHandler(next), this.constraintHandlers);
        }
    }

    protected abstract PropertyConstraintHandler createConstraintHandler(IEcoreProfileReflection.ValidationStereotypeKind var1);

    public Object caseProperty(Property property) {
        if (this.isRemoved((Element)property)) {
            return null;
        }
        if (property.getClass_() == null) {
            return null;
        }
        PropertyContext ctx = new PropertyContext(property);
        for (PropertyConstraintHandler next : this.constraintHandlers) {
            ctx.addAnnotation(next);
            ctx.addConstraint(next);
        }
        ctx.done();
        return property;
    }

    private StringBuffer getValueExpression(Property property, String vocabExpression) {
        String templateTypeQName;
        String message;
        Property baseProperty = this.getBaseProperty(property);
        if (baseProperty == null) {
            String message2 = "Cannot find base property for: " + property.getQualifiedName();
            Logger.log(4, message2);
            return null;
        }
        if (property.getType() == null) {
            message = "Property has no type: " + property.getQualifiedName();
            Logger.log(2, message);
        }
        if (!this.isCodedType(property) && !this.isEnumerationType(property)) {
            message = "Property is not of CD or enumeration type: " + property.getQualifiedName();
            Logger.log(4, message);
            return null;
        }
        Classifier propertyType = this.getNormalizedType(property);
        StringBuffer body = new StringBuffer();
        String selfName = "self." + baseProperty.getName();
        String baseTypeQName = baseProperty.getType().getQualifiedName();
        String string = templateTypeQName = propertyType == null ? baseTypeQName : propertyType.getQualifiedName();
        if (property.getUpper() != 0) {
            if (baseProperty.getUpper() == 1) {
                body.append("not ").append(selfName).append(".oclIsUndefined() and ");
                body.append(selfName).append(".oclIsKindOf(").append(templateTypeQName).append(")");
                if (!TransformPropertyConstraint.isTestForDefinedValue(vocabExpression)) {
                    body.append(" and ");
                    body.append(LF);
                    body.append("let value : ").append(templateTypeQName).append(" = ");
                    body.append(selfName).append(".oclAsType(").append(templateTypeQName).append(") in ");
                    body.append(LF);
                    body.append(vocabExpression);
                }
            } else if (baseProperty.getUpper() > 0 || baseProperty.getUpper() == -1) {
                if (property.getLower() == 1 && property.getUpper() == 1) {
                    body.append(selfName);
                    body.append("->size() = 1 and ");
                } else if (property.getLower() >= 1) {
                    body.append("not ");
                    body.append(selfName);
                    body.append("->isEmpty() and ");
                }
                body.append(selfName);
                body.append("->forAll(element | not element.oclIsUndefined() and element.oclIsKindOf(").append(templateTypeQName).append(")");
                if (!TransformPropertyConstraint.isTestForDefinedValue(vocabExpression)) {
                    body.append(" and ");
                    body.append(LF);
                    body.append("let value : ").append(templateTypeQName);
                    body.append(" = element.oclAsType(").append(templateTypeQName).append(") in ");
                    body.append(LF);
                    body.append(vocabExpression);
                }
                body.append(")");
            }
        }
        return body;
    }

    private static boolean isTestForDefinedValue(String ocl) {
        return "not value.oclIsUndefined()".equals(ocl);
    }

    protected Classifier getNormalizedType(Property property) {
        Classifier baseDatatype;
        Classifier result;
        Classifier classifier = result = property.getType() instanceof Classifier ? (Classifier)property.getType() : null;
        if (result != null && (baseDatatype = this.getBaseDatatype(result, (Element)property)) != null) {
            result = baseDatatype;
        }
        return result;
    }

    protected abstract boolean isCodedType(Property var1);

    protected abstract boolean isSimpleCodedType(Property var1);

    private boolean isEnumerationType(Property property) {
        return property.getType() instanceof Enumeration;
    }

    public abstract class PropertyConstraintHandler {
        private final IEcoreProfileReflection.ValidationStereotypeKind kind;
        private final String suffix;

        protected PropertyConstraintHandler(IEcoreProfileReflection.ValidationStereotypeKind kind, String suffix) {
            this.kind = kind;
            this.suffix = suffix;
        }

        public final IEcoreProfileReflection.ValidationStereotypeKind kind() {
            return this.kind;
        }

        final String suffix() {
            return this.suffix;
        }

        protected abstract boolean addAnnotation(PropertyContext var1);

        protected abstract Constraint addConstraint(PropertyContext var1);

        protected abstract boolean isDuplicateInitialization(Property var1);

        protected final boolean addAnnotation(Property property, IEcoreProfileReflection.ValidationStereotypeKind stereotypeKind, String codeSystem, String codeSystemName, String code, String displayName, String codeSystemVersion) {
            String enumCode;
            ValueSpecification defaultValue;
            IEcoreProfileReflection.ValidationSeverityKind propertySeverity;
            boolean result = false;
            if (TransformPropertyConstraint.this.getEcoreProfile().getValidationSeverity((Element)property, stereotypeKind) == IEcoreProfileReflection.ValidationSeverityKind.INFO && ((propertySeverity = TransformPropertyConstraint.this.getEcoreProfile().getValidationSeverity((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.PROPERTY)) == null || propertySeverity == IEcoreProfileReflection.ValidationSeverityKind.INFO)) {
                return result;
            }
            AnnotationsUtil annotationsUtil = TransformPropertyConstraint.this.getEcoreProfile().annotate((Element)property.getClass_());
            if (TransformPropertyConstraint.this.isEnumerationType(property) && (defaultValue = property.getDefaultValue()) != null && (enumCode = defaultValue.stringValue()) != null && enumCode.length() > 0) {
                if (code == null || code.length() == 0) {
                    code = enumCode;
                } else if (!code.equals(enumCode)) {
                    String message = "Vocabulary constraint contradicts enumeration default value in property: " + property.getQualifiedName();
                    Logger.log(2, message);
                }
            }
            if (!this.isDuplicateInitialization(property)) {
                if (code != null) {
                    if (TransformPropertyConstraint.this.isEnumerationType(property)) {
                        annotationsUtil.setAnnotation(property.getName(), code);
                        result = true;
                    } else {
                        annotationsUtil.setAnnotation(String.valueOf(property.getName()) + ".code", code);
                    }
                }
                if (!TransformPropertyConstraint.this.isSimpleCodedType(property) && !TransformPropertyConstraint.this.isEnumerationType(property)) {
                    if (codeSystem != null) {
                        annotationsUtil.setAnnotation(String.valueOf(property.getName()) + ".codeSystem", codeSystem);
                    }
                    if (codeSystemName != null) {
                        annotationsUtil.setAnnotation(String.valueOf(property.getName()) + ".codeSystemName", codeSystemName);
                    }
                    if (codeSystemVersion != null) {
                        annotationsUtil.setAnnotation(String.valueOf(property.getName()) + ".codeSystemVersion", codeSystemVersion);
                    }
                    if (displayName != null) {
                        annotationsUtil.setAnnotation(String.valueOf(property.getName()) + ".displayName", displayName);
                    }
                }
            }
            annotationsUtil.saveAnnotations();
            return result;
        }

        protected final Constraint addVocabConstraint(PropertyContext context, IEcoreProfileReflection.ValidationStereotypeKind stereotypeKind, String oclVocabCondition) {
            StringBuffer body;
            Property property = context.property();
            String ocl = oclVocabCondition;
            if (ocl == null || ocl.length() == 0) {
                String message = "Could not generate vocabulary condition for property " + property.getQualifiedName();
                Logger.log(2, message);
                return null;
            }
            if (TransformPropertyConstraint.this.getEcoreProfile().getValidationSeverity((Element)property, stereotypeKind) == IEcoreProfileReflection.ValidationSeverityKind.INFO && TransformPropertyConstraint.this.isCodedType(property)) {
                ocl = "not value.codeSystem.oclIsUndefined() or not value.codeSystemName.oclIsUndefined()";
            }
            if ((body = TransformPropertyConstraint.this.getValueExpression(property, ocl)) == null) {
                String message = "Could not generate constraint for property: " + property.getQualifiedName();
                Logger.log(2, message);
                return null;
            }
            IEcoreProfileReflection.ValidationSeverityKind propSeverity = TransformPropertyConstraint.this.getEcoreProfile().getValidationSeverity((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.PROPERTY);
            IEcoreProfileReflection.ValidationSeverityKind csSeverity = TransformPropertyConstraint.this.getEcoreProfile().getValidationSeverity((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.CODE_SYSTEM);
            IEcoreProfileReflection.ValidationSeverityKind vsSeverity = TransformPropertyConstraint.this.getEcoreProfile().getValidationSeverity((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.VALUE_SET);
            if (propSeverity == null && csSeverity == null && vsSeverity == null) {
                body = new StringBuffer();
                body.append("true");
            }
            String constraintName = TransformPropertyConstraint.this.createConstraintName((NamedElement)property);
            return this.addConstraint(context, stereotypeKind, constraintName, body);
        }

        protected final Constraint addConstraint(PropertyContext context, IEcoreProfileReflection.ValidationStereotypeKind stereotypeKind, String constraintName, StringBuffer body) {
            Property property = context.property();
            Constraint result = null;
            if (body.length() > 0) {
                if (constraintName == null) {
                    constraintName = TransformPropertyConstraint.this.createConstraintName((NamedElement)property);
                }
                constraintName = context.adaptConstraintName(constraintName, this);
                result = TransformPropertyConstraint.this.addOCLConstraint(property, stereotypeKind, body, constraintName);
            }
            return result;
        }
    }

    public final class PropertyContext {
        private final Property property;
        private final Map<IEcoreProfileReflection.ValidationStereotypeKind, Constraint> constraints = new LinkedHashMap<IEcoreProfileReflection.ValidationStereotypeKind, Constraint>();
        private final Set<String> constraintNames = new HashSet<String>();
        private boolean initializerAdded;
        private boolean consumed;

        PropertyContext(Property property) {
            this.property = property;
        }

        public final Property property() {
            return this.property;
        }

        public String adaptConstraintName(String name, PropertyConstraintHandler handler) {
            String result = name;
            String suffix = handler.suffix();
            int i = 1;
            while (!this.constraintNames.add(result)) {
                result = String.valueOf(name) + suffix;
                suffix = String.valueOf(handler.suffix()) + i;
                ++i;
            }
            return result;
        }

        public void addAnnotation(PropertyConstraintHandler handler) {
            if (!this.initializerAdded) {
                this.initializerAdded = handler.addAnnotation(this);
            }
        }

        public void addConstraint(PropertyConstraintHandler handler) {
            TransformPropertyConstraint.putIfNotNull(handler.kind(), handler.addConstraint(this), this.constraints);
        }

        public void consume() {
            this.consumed = true;
        }

        public void done() {
            if (this.consumed || !this.constraints.isEmpty()) {
                TransformPropertyConstraint.this.removeModelElement((Element)this.property());
            }
            this.setUpConstraintDependencies();
            this.constraints.clear();
        }

        private void setUpConstraintDependencies() {
            Constraint propertyValidation;
            if (this.constraints.size() > 1 && (propertyValidation = this.constraints.get((Object)IEcoreProfileReflection.ValidationStereotypeKind.PROPERTY)) != null) {
                EList constraints;
                int index;
                Namespace context = propertyValidation.getContext();
                Constraint firstConstraint = this.constraints.values().iterator().next();
                if (firstConstraint != propertyValidation && context != null && (index = (constraints = context.getOwnedRules()).indexOf((Object)firstConstraint)) >= 0) {
                    constraints.move(index, (Object)propertyValidation);
                }
                AnnotationsUtil annotations = TransformPropertyConstraint.this.getEcoreProfile().annotate((Element)context);
                for (Constraint next : this.constraints.values()) {
                    if (next == propertyValidation) continue;
                    TransformPropertyConstraint.this.setConstraintDependency(annotations, next.getName(), propertyValidation.getName());
                }
                annotations.saveAnnotations();
            }
        }
    }
}

