/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.core.profile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ValueSetType implements Enumerator
{
    EXTENSIONAL(0, "Extensional", "Extensional"),
    INTENSIONAL(1, "Intensional", "Intensional");

    public static final int EXTENSIONAL_VALUE = 0;
    public static final int INTENSIONAL_VALUE = 1;
    private static final ValueSetType[] VALUES_ARRAY;
    public static final List<ValueSetType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ValueSetType[]{EXTENSIONAL, INTENSIONAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ValueSetType get(int value) {
        switch (value) {
            case 0: {
                return EXTENSIONAL;
            }
            case 1: {
                return INTENSIONAL;
            }
        }
        return null;
    }

    public static ValueSetType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValueSetType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValueSetType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValueSetType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private ValueSetType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

