/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.validation.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.validation.internal.provider.ProfileClientSelector;
import org.eclipse.mdht.uml.validation.internal.provider.ValidationProfileUtil;
import org.eclipse.uml2.uml.Package;

public class MDHTClientSelector
extends ProfileClientSelector
implements IExecutableExtension {
    private static final String BASE_MODEL_URI_PARAM = "baseModelURI";
    private static final String APPLIED_PROFILE_URI_PARAM = "appliedProfileURI";
    private List<URI> baseModelURIs;
    private List<URI> appliedProfileURIs;
    private final Map<URI, URI> platformURIMap = EcorePlugin.computePlatformURIMap();

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.parseURIMap((String)data);
        } else if (data instanceof Map) {
            this.baseModelURIs = this.parseURIs((String)((Map)data).get(BASE_MODEL_URI_PARAM));
            this.appliedProfileURIs = this.parseURIs((String)((Map)data).get(APPLIED_PROFILE_URI_PARAM));
        }
    }

    @Override
    public boolean selects(Object object) {
        boolean result = super.selects(object);
        if (result && (this.baseModelURIs != null || this.appliedProfileURIs != null)) {
            Package root = this.getRootPackage(object);
            result = result && this.checkBaseModelURIs(root) && this.checkAppliedProfiles(root);
        }
        return result;
    }

    private boolean checkBaseModelURIs(Package root) {
        boolean result = true;
        if (this.baseModelURIs != null) {
            URIConverter converter = this.getPlatformlyNormalizingURIConverter(ValidationProfileUtil.getURIConverter((EObject)root));
            for (URI uri : this.baseModelURIs) {
                boolean bl = result = this.findPackage(converter.normalize(uri), converter, ValidationProfileUtil.getAllImportedPackages(root)) != null;
                if (!result) break;
            }
        }
        return result;
    }

    private boolean checkAppliedProfiles(Package root) {
        boolean result = true;
        if (this.appliedProfileURIs != null) {
            URIConverter converter = this.getPlatformlyNormalizingURIConverter(ValidationProfileUtil.getURIConverter((EObject)root));
            for (URI uri : this.appliedProfileURIs) {
                boolean bl = result = this.findPackage(converter.normalize(uri), converter, (Iterable)root.getAllAppliedProfiles()) != null;
                if (!result) break;
            }
        }
        return result;
    }

    private <T extends Package> T findPackage(URI uri, URIConverter converter, Iterable<? extends T> packages) {
        Package result = null;
        boolean hasFragment = uri.hasFragment();
        for (Package next : packages) {
            URI nextURI;
            URI uRI = nextURI = hasFragment ? EcoreUtil.getURI((EObject)next) : EcoreUtil.getURI((EObject)next).trimFragment();
            if (!converter.normalize(nextURI).equals(uri)) continue;
            result = next;
            break;
        }
        return (T)result;
    }

    private URIConverter getPlatformlyNormalizingURIConverter(URIConverter converter) {
        final ExtensibleURIConverterImpl.URIMap delegate = (ExtensibleURIConverterImpl.URIMap)converter.getURIMap();
        ExtensibleURIConverterImpl result = new ExtensibleURIConverterImpl((Collection)converter.getURIHandlers(), (Collection)converter.getContentHandlers()){

            protected ExtensibleURIConverterImpl.URIMap getInternalURIMap() {
                if (this.uriMap == null) {
                    this.uriMap = (ExtensibleURIConverterImpl.URIMap)new URIMappingRegistryImpl(){

                        protected URI delegatedGetURI(URI uri) {
                            return delegate.getURI(uri);
                        }
                    }.map();
                }
                return super.getInternalURIMap();
            }
        };
        result.getURIMap().putAll(this.platformURIMap);
        return result;
    }

    private List<URI> parseURIs(String uriList) {
        String[] uris;
        ArrayList<URI> result = null;
        String[] stringArray = uris = uriList == null ? null : uriList.split("\\s*;\\s*");
        if (uris != null && uris.length > 0) {
            result = new ArrayList<URI>(uris.length);
            String[] stringArray2 = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray2[n2];
                result.add(URI.createURI((String)next));
                ++n2;
            }
        }
        return result;
    }

    private void parseURIMap(String uriMap) {
        Pattern pairPattern = Pattern.compile("([^=]+)=(.+)");
        Matcher m = pairPattern.matcher("");
        String[] pairs = uriMap.split("\\s*;\\s*");
        if (pairs != null && pairs.length > 0) {
            HashMap<String, ArrayList<URI>> map = new HashMap<String, ArrayList<URI>>();
            String[] stringArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                m.reset(next);
                if (m.matches()) {
                    List<Object> uris;
                    String key = m.group(1);
                    if (key.equalsIgnoreCase(BASE_MODEL_URI_PARAM)) {
                        uris = (ArrayList<URI>)map.get(BASE_MODEL_URI_PARAM);
                        if (uris == null) {
                            uris = new ArrayList<URI>(3);
                            map.put(BASE_MODEL_URI_PARAM, (ArrayList<URI>)uris);
                        }
                        uris.add(URI.createURI((String)m.group(2).trim()));
                    } else if (key.equalsIgnoreCase(APPLIED_PROFILE_URI_PARAM)) {
                        uris = (List)map.get(APPLIED_PROFILE_URI_PARAM);
                        if (uris == null) {
                            uris = new ArrayList(3);
                            map.put(APPLIED_PROFILE_URI_PARAM, (ArrayList<URI>)uris);
                        }
                        uris.add(URI.createURI((String)m.group(2).trim()));
                    }
                }
                ++n2;
            }
            if (map.containsKey(BASE_MODEL_URI_PARAM)) {
                this.baseModelURIs = (List)map.get(BASE_MODEL_URI_PARAM);
            }
            if (map.containsKey(APPLIED_PROFILE_URI_PARAM)) {
                this.appliedProfileURIs = (List)map.get(BASE_MODEL_URI_PARAM);
            }
        }
    }
}

