/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.core.util.CDACommonUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;

public class CDASampler {
    Map<String, String> samples = new HashMap<String, String>();
    private List<Map<String, String>> samplesStack = new ArrayList<Map<String, String>>();
    private String umlContext = "";
    private boolean customDataUsed;

    public void mergeSampleXML(Class umlClass, EObject context) {
        EAnnotation anno = umlClass.getEAnnotation("UMLSAMPLE");
        if (anno != null) {
            for (String name : anno.getDetails().keySet()) {
                String value = (String)anno.getDetails().get((Object)name);
                if ("".equals(value) || this.samples.containsKey(name)) continue;
                this.samples.put(name, value);
            }
        }
    }

    protected Map<String, String> extractSampleData(Property property) {
        return this.extractSampleData(property.getName());
    }

    protected Map<String, String> extractSampleData(EStructuralFeature feature) {
        return this.extractSampleData(feature.getName());
    }

    protected Map<String, String> extractSampleData(String property) {
        HashMap<String, String> result = new HashMap<String, String>();
        if ("mixed".equals(property)) {
            property = "text";
        }
        for (String name : new ArrayList<String>(this.samples.keySet())) {
            int toffset;
            if (name.startsWith("/", toffset = 0)) {
                ++toffset;
            }
            if (name.startsWith("@", toffset)) {
                ++toffset;
            }
            if (!name.startsWith(property, toffset) || toffset + property.length() != name.length() && (name.charAt(toffset + property.length()) != '(' || !result.isEmpty()) && name.charAt(toffset + property.length()) != '/') continue;
            int nextSlash = (String.valueOf(name) + "/").indexOf(47, toffset);
            if (result.isEmpty()) {
                property = name.substring(toffset, nextSlash);
            }
            result.put(name.substring(nextSlash), this.samples.get(name));
            this.samples.remove(name);
        }
        return result;
    }

    public void descentProperty(Property property) {
        this.umlContext = String.valueOf(this.umlContext) + "/" + property.getName();
        this.samplesStack.add(this.samples);
        this.samples = this.extractSampleData(property);
    }

    public Property descentProperty(EStructuralFeature eStructuralFeature, Class umlClass) {
        Iterator<Property> iterator = CDACommonUtils.allAttributes(umlClass).iterator();
        while (iterator.hasNext()) {
            Property property;
            Property cdaProperty = property = iterator.next();
            if (!property.getRedefinedProperties().isEmpty()) {
                cdaProperty = (Property)property.getRedefinedProperties().get(0);
            }
            if (!eStructuralFeature.getName().equals(cdaProperty.getName())) continue;
            this.descentProperty(property);
            for (String key : this.samples.keySet()) {
                System.out.println(String.valueOf(key) + "=" + this.samples.get(key));
            }
            return property;
        }
        this.samplesStack.add(this.samples);
        this.umlContext = String.valueOf(this.umlContext) + "/cda:" + eStructuralFeature.getName();
        this.samples = new HashMap<String, String>();
        System.out.println("Failed descending " + this.umlContext + " in cda:" + eStructuralFeature.getEContainingClass().getName() + "(" + umlClass.getName() + ")");
        return null;
    }

    public boolean hasData() {
        return !this.samples.isEmpty();
    }

    public String getSample() {
        String result = this.samples.get("");
        this.customDataUsed |= result != null;
        return result;
    }

    public String getSample(String def) {
        if (this.getSample() != null) {
            return this.getSample();
        }
        return def;
    }

    public void ascentProperty() {
        this.samples = this.samplesStack.remove(this.samplesStack.size() - 1);
        if (this.umlContext.lastIndexOf("/") != -1) {
            this.umlContext = this.umlContext.substring(0, this.umlContext.lastIndexOf("/"));
        }
    }

    public void assignSample(EObject eObject, EStructuralFeature structuralFeature) {
        if (this.getSample() != null && structuralFeature.getEType() instanceof EDataType) {
            EDataType eDataType = (EDataType)structuralFeature.getEType();
            try {
                Object def = EcoreUtil.createFromString((EDataType)eDataType, (String)this.getSample());
                if (def != null) {
                    eObject.eSet(structuralFeature, def);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isCustomDataUsed() {
        return this.customDataUsed;
    }
}

