/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.mdht.api.GenerateAPIAction;
import org.eclipse.mdht.transformation.ocl.OCLTransformation;
import org.eclipse.mdht.uml.cda.core.util.CDACommonUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class GenerateXMLAction
extends GenerateAPIAction {
    protected File xmlTestFolder;
    private Map<Element, Collection<File>> testFilesFor = new HashMap<Element, Collection<File>>();
    private Map<File, String> typeOfTestFile = new HashMap<File, String>();

    @Override
    protected String getTargetLanguage() {
        return "Positive/Negative XML Samples";
    }

    @Override
    protected String getRootFileExtension() {
        return ".xml";
    }

    @Override
    protected File genfolder(File modelFolder) {
        return new File(modelFolder, "samples");
    }

    @Override
    protected String toValidFileName(String filename) {
        filename = filename.replace(".", "_").replace(" ", "");
        filename = filename.replaceAll("[:\\\\/*\"?|<>']", "");
        return filename;
    }

    @Override
    protected void genAPICode(Package pack, IProgressMonitor monitor) throws Exception {
        this.xmlTestFolder = new File(this.genfolder, "xml");
        monitor.setTaskName("Creating Min/Max Clinical Documents");
        this.generateMinMaxXMLFiles(pack, monitor);
        monitor.setTaskName("Creating XML test data for properties");
        monitor = new SubProgressMonitor(monitor, 30);
        monitor.beginTask("", CDACommonUtils.getAllContents((Resource)pack.eResource(), Constraint.class).size() + CDACommonUtils.getAllContents((Resource)pack.eResource(), Class.class).size() + CDACommonUtils.getAllContents((Resource)pack.eResource(), Property.class).size());
        block0: for (Constraint constraint : CDACommonUtils.getAllContents((Resource)pack.eResource(), Constraint.class)) {
            OpaqueExpression opaqueExpression;
            monitor.worked(1);
            if (!(constraint.getSpecification() instanceof OpaqueExpression) || constraint.getConstrainedElements().isEmpty() || !(constraint.getContext() instanceof Class) || (opaqueExpression = (OpaqueExpression)constraint.getSpecification()).getLanguages().isEmpty() || !"Analysis".equals(opaqueExpression.getLanguages().get(0))) continue;
            Element ele = (Element)constraint.getConstrainedElements().get(0);
            Element eObject = ele = CDACommonUtils.getMDHTRepresentative((NamedElement)((NamedElement)ele));
            while (eObject != null) {
                if (eObject instanceof Class) {
                    Class clazz = (Class)eObject;
                    List propertyPath = CDACommonUtils.getPropertyPath((Class)clazz);
                    for (Element element : constraint.getConstrainedElements()) {
                        if (!(element instanceof Property)) continue;
                        Property property = (Property)element;
                        propertyPath.add(property);
                    }
                    monitor.subTask(constraint.getName());
                    File placeholderFolder = new File(this.xmlTestFolder, "Placeholder");
                    this.creator.forgetLastFileContent();
                    this.creator.initialize((Collection)propertyPath);
                    this.creator.flushClinicalDocument(this.record((Class)constraint.getContext(), new File(placeholderFolder, "Positive"), (NamedElement)constraint, "OK"));
                    this.creator.forgetLastFileContent();
                    this.creator.initialize((Collection)propertyPath);
                    this.creator.flushClinicalDocument(this.record((Class)constraint.getContext(), new File(placeholderFolder, "Negative"), (NamedElement)constraint, "Fail"));
                    continue block0;
                }
                eObject = eObject.eContainer();
            }
        }
        for (Class clazz : CDACommonUtils.getAllContents((Resource)pack.eResource(), Class.class)) {
            if (Boolean.parseBoolean(this.getStereotype((NamedElement)clazz, "noSchematronGen"))) continue;
            monitor.worked(1);
            String templateId = CDACommonUtils.getTemplateId((Class)clazz);
            Property templateIdProperty = this.creator.getTemplateIdProperty(clazz);
            if (templateId == null || templateIdProperty == null) continue;
            monitor.subTask(clazz.getName());
            File templateIDsFolder = new File(this.xmlTestFolder, "TemplateIDs");
            if (this.creator.initializePath(clazz, templateIdProperty, null, null) != null) {
                this.creator.flushClinicalDocument(this.record(clazz, new File(templateIDsFolder, "Positive"), (NamedElement)templateIdProperty, "OK"));
            }
            if (this.creator.initializePath(clazz, templateIdProperty, null, templateIdProperty) != null) {
                this.creator.flushClinicalDocument(this.record(clazz, new File(templateIDsFolder, "Negative"), (NamedElement)templateIdProperty, "AttributeValueTest"));
            }
            if (this.creator.initializePath(clazz, null, templateIdProperty, null) == null) continue;
            this.creator.flushClinicalDocument(this.record(clazz, new File(templateIDsFolder, "Negative"), (NamedElement)templateIdProperty, "NodeExistenceTest"));
        }
        for (Property property : CDACommonUtils.getAllContents((Resource)pack.eResource(), Property.class)) {
            Object child1;
            Property propertyForTypeCheck;
            monitor.worked(1);
            if (!(property.eContainer() instanceof Class)) continue;
            Class clazz = (Class)property.eContainer();
            monitor.subTask(CDACommonUtils.getUmlContext((Property)property));
            if (monitor.isCanceled()) {
                throw new RuntimeException("Canceled by user");
            }
            if (Boolean.parseBoolean(this.getStereotype((NamedElement)property, "noSchematronGen"))) continue;
            Property baseProperty = CDACommonUtils.getCDAProperty((Property)property);
            this.creator.forgetLastFileContent();
            if (this.creator.initializePath(clazz, property, null, null) != null) {
                this.creator.flushClinicalDocument(this.getXMLTestFile(property, "OK"));
            }
            if (property.getLower() >= 1 && CDACommonUtils.getPropertyForTypeCheck((Class)clazz) != property && CDACommonUtils.getPropertyForCodeOrClasscodeCheck((Class)clazz) != property && this.creator.initializePath(clazz, null, property, null) != null) {
                this.creator.flushClinicalDocument(this.getXMLTestFile(property, "NodeExistenceTest"));
            }
            if ((CDACommonUtils.getDefault((Property)property) != null || CDACommonUtils.getTextValue((Property)property) != null) && CDACommonUtils.getPropertyForTypeCheck((Class)clazz) != property && CDACommonUtils.getPropertyForCodeOrClasscodeCheck((Class)clazz) != property && this.creator.initializePath(clazz, property, null, property) != null) {
                this.creator.flushClinicalDocument(this.getXMLTestFile(property, "NodeValueTest"));
            }
            if (property.getLower() >= 1 && property.getType() instanceof Class && (propertyForTypeCheck = CDACommonUtils.getLeafPropertyForTypeCheck((Class)((Class)property.getType()))) != null && this.creator.initializePath(clazz, property, null, propertyForTypeCheck) != null) {
                this.creator.flushClinicalDocument(this.getXMLTestFile(property, "Predicated_NodeExistenceTest"));
            }
            if (property.getLower() >= 1 && property.getType() instanceof Class && CDACommonUtils.isDatatypeModel((Element)property.getType()) && baseProperty != null && baseProperty.getType() != property.getType() && this.creator.initializePath(clazz, property, null, property) != null) {
                this.creator.flushClinicalDocument(this.getXMLTestFile(property, "NodeTypeTest"));
            }
            if (property.getUpper() == 0 && this.creator.initializePath(clazz, property, null, null) != null) {
                this.creator.flushClinicalDocument(this.getXMLTestFile(property, "NodeNonExistenceTest"));
            }
            if (property.getUpper() != 1 || baseProperty == null || baseProperty.getUpper() == property.getUpper() || !((child1 = this.creator.initializePath(clazz, property, null, null)) instanceof EObject)) continue;
            EObject eObject = (EObject)child1;
            Object child2 = this.creator.repopulateProperty(property, eObject);
            if (child2 instanceof EObject) {
                this.creator.flushClinicalDocument(this.getXMLTestFile(property, "NodeNumberTest"));
                continue;
            }
            CDACommonUtils.addStatus((Collection)this.statuses, (int)4, (String)this.getPlugin(), (int)16, (String)("Cannot re-populate " + CDACommonUtils.getUmlContextDoubled((Property)property)), (EObject[])new EObject[]{property});
        }
        monitor.done();
    }

    private static String withoutDigits(String name) {
        while (!"".equals(name) && Character.isDigit(name.charAt(name.length() - 1))) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public String toXMLString(EObject eObject, Class clazz, Map<String, Object> options) {
        String xml;
        options.put("EXTENDED_META_DATA", BasicExtendedMetaData.INSTANCE);
        options.put("ENCODING", "UTF-8");
        try {
            xml = XMLHelperImpl.saveString(options, Arrays.asList(eObject), null, null);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        xml = xml.replace("\"datatypes:", "\"");
        xml = xml.replace("<cda:", "<");
        xml = xml.replace("</cda:", "</");
        xml = xml.replace("Extensions_3.0", "ext");
        xml = xml.replace("xmlns:cda=\"urn:hl7-org:v3\"", "xmlns=\"urn:hl7-org:v3\"");
        String eName = eObject.eClass().getName();
        if (!"ClinicalDocument".equals(eName)) {
            Property cdaProperty;
            String rootTag = GenerateXMLAction.withoutDigits(String.valueOf(eName.substring(0, 1).toLowerCase()) + eName.substring(1));
            if (eObject.eContainmentFeature() != null) {
                rootTag = eObject.eContainingFeature().getName();
            } else if (clazz != null && CDACommonUtils.getOverallPropertyReference((Class)clazz) != null && (cdaProperty = CDACommonUtils.getCDAProperty((Property)CDACommonUtils.getOverallPropertyReference((Class)clazz))) != null) {
                rootTag = cdaProperty.getName();
            }
            xml = xml.replace("<" + eName, "<" + rootTag);
            xml = xml.replace("</" + eName, "</" + rootTag);
            xml = xml.replace(" xmlns=\"urn:hl7-org:v3\"", "");
            xml = xml.replace(" xmi:version=\"2.0\"", "");
            xml = xml.replace(" xmlns:xmi=\"http://www.omg.org/XMI\"", "");
            xml = xml.replace(" xmlns:datatypes=\"http://www.openhealthtools.org/mdht/uml/hl7/datatypes\"", "");
            xml = xml.replace(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", "");
        } else {
            xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xml;
        }
        return xml;
    }

    protected void generateMinMaxXMLFiles(Package pack, IProgressMonitor monitor) throws Exception {
        String uriMap = "";
        for (Resource res : pack.eResource().getResourceSet().getResources()) {
            URI normURI = res.getResourceSet().getURIConverter().normalize(res.getURI());
            if (res.getURI().equals(normURI)) continue;
            uriMap = String.valueOf(uriMap) + " " + res.getURI() + " " + normURI;
        }
        this.currentCategory.setUriMap(uriMap.trim());
        HashSet propertyPath = new HashSet();
        for (Class clazz : this.classes) {
            propertyPath.addAll(CDACommonUtils.getPropertyPath((Class)clazz));
        }
        String pref = String.valueOf(this.specContractedName) + "_";
        this.creator.initialize(Collections.emptyList());
        this.creator.flushClinicalDocument(new File(this.xmlTestFolder, String.valueOf(pref) + "Min_mdht.xml"));
        this.creator.initialize(propertyPath);
        this.creator.flushClinicalDocument(new File(this.xmlTestFolder, String.valueOf(pref) + "Max(All_Classes)_mdht.xml"));
        EObject aClinicalDocument = this.creator.initializeSnippet(this.umlClinicalDocument, CDACommonUtils.getAllContents((Collection)this.irResources, Property.class));
        this.traceCreatedInstances(String.valueOf(pref) + "Max(All_Properties)_mdht", aClinicalDocument);
        this.creator.enableSampleData(true);
        this.creator.enableSampleDataExpansion(true);
        this.creator.initialize(Collections.emptyList());
        this.creator.flushClinicalDocument(new File(this.xmlTestFolder, String.valueOf(pref) + "Sample_mdht.xml"));
        this.creator.enableSampleData(false);
    }

    private void traceCreatedInstances(String fileName, EObject aClinicalDocument) throws IOException {
        this.trace("Clinical Document instance", (EObject)this.umlClinicalDocument, aClinicalDocument);
        this.currentCategory.setTargetModel(aClinicalDocument);
        for (EObject eObject : CDACommonUtils.getAllContents(Arrays.asList(aClinicalDocument), EObject.class)) {
            Type clazz;
            Property property = this.creator.getInitializedByProperty((Object)eObject);
            if (property != null) {
                this.trace("Property instance", (EObject)property, eObject);
            }
            if ((clazz = this.creator.getInitializedByClass((Object)eObject)) == null) continue;
            this.trace("Class instance", (EObject)clazz, eObject);
        }
        File file = new File(this.xmlTestFolder, String.valueOf(fileName) + ".xmi");
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("SCHEMA_LOCATION_IMPLEMENTATION", true);
        String xml = this.toXMLString(aClinicalDocument, this.umlClinicalDocument, options);
        this.creator.writeFile(xml, file);
        ResourceSetImpl rSet = new ResourceSetImpl();
        Resource res = rSet.createResource(URI.createFileURI((String)file.toString()));
        res.getContents().add((Object)aClinicalDocument);
    }

    private File getXMLTestFile(Property property, String testType) {
        if (!(property.getType() instanceof Class)) {
            testType = testType.replace("Node", "Attribute");
        }
        Class clazz = (Class)property.eContainer();
        if (testType.contains("OK")) {
            return this.record(clazz, new File(new File(this.xmlTestFolder, "Properties"), "Positive"), (NamedElement)property, testType);
        }
        return this.record(clazz, new File(new File(this.xmlTestFolder, "Properties"), "Negative"), (NamedElement)property, testType);
    }

    private File record(Class context, File parent, NamedElement constrainedElement, String testType) {
        Object element = constrainedElement instanceof Constraint || GenerateXMLAction.isTemplateId((Element)constrainedElement) ? context : constrainedElement;
        Collection<File> testTypes = this.testFilesFor.get(element);
        if (testTypes == null) {
            testTypes = new ArrayList<File>();
            this.testFilesFor.put((Element)element, testTypes);
        }
        String xmlTestFilenameTemplate = this.getStereotype((NamedElement)constrainedElement.getNearestPackage(), "xmlTestFilenameTemplate");
        String filename = this.toValidFileName(this.resolve(xmlTestFilenameTemplate, context, constrainedElement, testType));
        File result = new File(parent, String.valueOf(filename) + ".xml");
        testTypes.add(result);
        this.typeOfTestFile.put(result, testType);
        return result;
    }

    private String getTestTypes(Class clazz, NamedElement element, boolean anchor) {
        String result = "";
        Collection<File> testTypes = this.testFilesFor.get(GenerateXMLAction.isTemplateId((Element)element) ? clazz : element);
        if (testTypes != null) {
            for (File file : testTypes) {
                result = anchor ? String.valueOf(result) + this.getAnchor(file, this.typeOfTestFile.get(file), this.getEntityMimeType()) : String.valueOf(result) + " " + this.typeOfTestFile.get(file);
            }
        }
        return result;
    }

    @Override
    protected String resolve(String template, Class clazz, NamedElement element) {
        this.template = template;
        if (this.needResolve("{test-types-covered}", clazz, element)) {
            this.resolve(this.getTestTypes(clazz, element, false));
        }
        if (this.needResolve("{test-file-anchors}", clazz, element)) {
            this.resolve(this.getTestTypes(clazz, element, true));
        }
        return super.resolve(this.template, clazz, element);
    }

    @Override
    protected OCLTransformation<Package, Classifier, ?, Property, ?, ?, ?, ?, ?, ?, ?, ?> createTrafo(ResourceSet resourceSet) {
        return null;
    }

    @Override
    protected String getEntityMimeType() {
        return "text/xml";
    }
}

