/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.api;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mdht.transformation.ocl.OCLTransformation;
import org.eclipse.mdht.uml.ui.properties.internal.sections.ConstraintSection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.OpaqueExpression;

public class OCLConstraintSection
extends ConstraintSection {
    private Hyperlink fromOclLabel;
    public static Map<String, OCLTransformation> OCL_TRANSFORMATIONS = new HashMap<String, OCLTransformation>();

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        Composite p = (Composite)parent.getParent().getChildren()[parent.getParent().getChildren().length - 2];
        p.setLayout((Layout)new GridLayout(0, false));
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.languageCombo.getParent();
        this.createFromOclLink(composite);
    }

    private void createFromOclLink(final Composite composite) {
        this.fromOclLabel = this.getWidgetFactory().createHyperlink(composite, "Get from OCL", 0);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.bodyText, 0, 16384);
        data.top = new FormAttachment((Control)this.bodyText, -5, 1024);
        this.fromOclLabel.setLayoutData((Object)data);
        FontData[] fD = this.fromOclLabel.getFont().getFontData();
        fD[0].setHeight(fD[0].getHeight() * 3 / 4);
        this.fromOclLabel.setFont(new Font((Device)Display.getCurrent(), fD[0]));
        this.fromOclLabel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    OCLTransformation trafo = OCL_TRANSFORMATIONS.get(OCLConstraintSection.this.languageCombo.getText());
                    trafo.setResourceSet(OCLConstraintSection.this.constraint.getContext().eResource().getResourceSet());
                    OpaqueExpression spec = OCLConstraintSection.this.constraint.getSpecification() instanceof OpaqueExpression ? (OpaqueExpression)OCLConstraintSection.this.constraint.getSpecification() : null;
                    int oclIndex = spec.getLanguages().indexOf((Object)"OCL");
                    String xpath = trafo.transform((Object)OCLConstraintSection.this.constraint.getContext(), (String)spec.getBodies().get(oclIndex));
                    OCLConstraintSection.this.bodyText.setText(xpath);
                    OCLConstraintSection.this.bodyModified = true;
                    OCLConstraintSection.this.modifyFields();
                }
                catch (Exception e2) {
                    MessageDialog.openError((Shell)composite.getShell(), (String)"Conversion error", (String)e2.getMessage());
                }
            }
        });
    }

    public void refresh() {
        super.refresh();
        OpaqueExpression spec = this.constraint.getSpecification() instanceof OpaqueExpression ? (OpaqueExpression)this.constraint.getSpecification() : null;
        int oclIndex = spec != null ? spec.getLanguages().indexOf((Object)"OCL") : -1;
        this.fromOclLabel.setVisible(OCL_TRANSFORMATIONS.containsKey(this.languageCombo.getText()) && oclIndex >= 0 && oclIndex < spec.getBodies().size() && !UML2Util.isEmpty((String)((String)spec.getBodies().get(oclIndex))));
    }
}

