/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.mdht.uml.cda.tests.DiagnosticOutputHelper;
import org.eclipse.mdht.uml.cda.tests.SystemOutValidationHandler;
import org.eclipse.mdht.uml.hl7.datatypes.BN;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.vocab.NullFlavor;

public class BNTest {
    private static boolean diagnosticsHaveErrors(Diagnostic oDiagnostic) {
        return oDiagnostic.getSeverity() != 0;
    }

    private static boolean processDiagnostics(Diagnostic oDiagnostic) {
        boolean bResult = true;
        if (BNTest.diagnosticsHaveErrors(oDiagnostic)) {
            SystemOutValidationHandler oValHandler = new SystemOutValidationHandler();
            DiagnosticOutputHelper.processDiagnostic(oDiagnostic, oValHandler);
            bResult = false;
        }
        return bResult;
    }

    public static boolean testWithNullFlavorNotSet() {
        BN oBn = DatatypesFactory.eINSTANCE.createBN();
        oBn.setValue(Boolean.valueOf(true));
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oBn);
        return BNTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testBNWithNullFlavor_FailureCase() {
        boolean bResult = true;
        BN oBn = DatatypesFactory.eINSTANCE.createBN();
        oBn.setNullFlavor(NullFlavor.NA);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oBn);
        if (!BNTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static void main(String[] args) throws Exception {
        boolean bFailure = false;
        if (!BNTest.testWithNullFlavorNotSet()) {
            bFailure = true;
            System.out.println("testWithNullFlavorNotSet failed!");
        }
        if (!BNTest.testBNWithNullFlavor_FailureCase()) {
            bFailure = true;
            System.out.println("testBNWithNullFlavor_FailureCase failed!");
        }
        if (bFailure) {
            System.out.println("One or more tests Failed!!!");
        } else {
            System.out.println("All tests completed successfully...");
        }
    }
}

