/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import java.math.BigDecimal;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.mdht.uml.cda.tests.DiagnosticOutputHelper;
import org.eclipse.mdht.uml.cda.tests.SystemOutValidationHandler;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.MO;
import org.eclipse.mdht.uml.hl7.datatypes.PQ;
import org.eclipse.mdht.uml.hl7.datatypes.PQR;
import org.eclipse.mdht.uml.hl7.datatypes.REAL;

public class BigDecimalTest {
    private static boolean diagnosticsHaveErrors(Diagnostic oDiagnostic) {
        return oDiagnostic.getSeverity() != 0;
    }

    private static boolean processDiagnostics(Diagnostic oDiagnostic) {
        boolean bResult = true;
        if (BigDecimalTest.diagnosticsHaveErrors(oDiagnostic)) {
            SystemOutValidationHandler oValHandler = new SystemOutValidationHandler();
            DiagnosticOutputHelper.processDiagnostic(oDiagnostic, oValHandler);
            bResult = false;
        }
        return bResult;
    }

    public static boolean testMOValue() {
        boolean bResult = true;
        MO oMO = DatatypesFactory.eINSTANCE.createMO();
        oMO.setValue(new BigDecimal("100.12345678"));
        if (!oMO.getValue().equals(new BigDecimal("100.12345678"))) {
            System.out.println("Failed to set/retrieve MO::value using BigDecimal initializer.");
            bResult = false;
        }
        oMO = DatatypesFactory.eINSTANCE.createMO();
        oMO.setValue(new Double("123.23"));
        if (!oMO.getValue().equals(new BigDecimal("123.23"))) {
            System.out.println("Failed to set/retrieve MO::value using Double initializer.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testPQValue() {
        boolean bResult = true;
        PQ oPQ = DatatypesFactory.eINSTANCE.createPQ();
        oPQ.setValue(new BigDecimal("100.12345678"));
        if (!oPQ.getValue().equals(new BigDecimal("100.12345678"))) {
            System.out.println("Failed to set/retrieve PQ::value using BigDecimal initializer.");
            bResult = false;
        }
        oPQ = DatatypesFactory.eINSTANCE.createPQ();
        oPQ.setValue(new Double("123.23"));
        if (!oPQ.getValue().equals(new BigDecimal("123.23"))) {
            System.out.println("Failed to set/retrieve PQ::value using Double initializer.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testPQRValue() {
        boolean bResult = true;
        PQR oPQR = DatatypesFactory.eINSTANCE.createPQR();
        oPQR.setValue(new BigDecimal("100.12345678"));
        if (!oPQR.getValue().equals(new BigDecimal("100.12345678"))) {
            System.out.println("Failed to set/retrieve PQR::value using BigDecimal initializer.");
            bResult = false;
        }
        oPQR = DatatypesFactory.eINSTANCE.createPQR();
        oPQR.setValue(new Double("123.23"));
        if (!oPQR.getValue().equals(new BigDecimal("123.23"))) {
            System.out.println("Failed to set/retrieve PQR::value using Double initializer.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testREALValue() {
        boolean bResult = true;
        REAL oREAL = DatatypesFactory.eINSTANCE.createREAL();
        oREAL.setValue(new BigDecimal("100.12345678"));
        if (!oREAL.getValue().equals(new BigDecimal("100.12345678"))) {
            System.out.println("Failed to set/retrieve REAL::value using BigDecimal initializer.");
            bResult = false;
        }
        oREAL = DatatypesFactory.eINSTANCE.createREAL();
        oREAL.setValue(new Double("123.23"));
        if (!oREAL.getValue().equals(new BigDecimal("123.23"))) {
            System.out.println("Failed to set/retrieve REAL::value using Double initializer.");
            bResult = false;
        }
        return bResult;
    }

    public static void main(String[] args) throws Exception {
        boolean bFailure = false;
        if (!BigDecimalTest.testMOValue()) {
            bFailure = true;
            System.out.println("testMOValue failed!");
        }
        if (!BigDecimalTest.testPQValue()) {
            bFailure = true;
            System.out.println("testPQValue failed!");
        }
        if (!BigDecimalTest.testPQRValue()) {
            bFailure = true;
            System.out.println("testPQRValue failed!");
        }
        if (!BigDecimalTest.testREALValue()) {
            bFailure = true;
            System.out.println("testREALValue failed!");
        }
        if (bFailure) {
            System.out.println("One or more tests Failed!!!");
        } else {
            System.out.println("All tests completed successfully...");
        }
    }
}

