/*
 * Decompiled with CFR 0.152.
 */
package traceability.presentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import traceability.LogEntry;
import traceability.Trace;
import traceability.TraceDiff;
import traceability.Traces;
import traceability.presentation.table.TraceabilityViewer;
import traceability.util.TraceabilityUtils;

public class Tracing {
    public List<Object> rows = new ArrayList<Object>();
    public Map<EObject, EObject> forward = new HashMap<EObject, EObject>();
    public Map<EObject, EObject> backward = new HashMap<EObject, EObject>();
    public Map<EObject, TraceDiff> diffOfElement = new HashMap<EObject, TraceDiff>();
    Map<EObject, Trace> traceOfElement = new HashMap<EObject, Trace>();
    public List<EObject> sourceModels = new ArrayList<EObject>();
    public List<EObject> targetModels = new ArrayList<EObject>();
    public Map<EObject, List<LogEntry>> errors = new HashMap<EObject, List<LogEntry>>();
    public Map<LogEntry, EObject> errorsRev = new HashMap<LogEntry, EObject>();
    public Set<EObject> traced = new HashSet<EObject>();
    private TraceDiff traceDiff;
    private Resource resource;
    public Map<EObject, EObject> modelOfElement = new HashMap<EObject, EObject>();

    public Tracing(Resource resource) {
        this.resource = resource;
        this.insertTraces();
    }

    public Tracing() {
    }

    protected void insertTraces() {
        EObject eobject;
        TreeIterator it = EcoreUtil.getAllContents((Resource)this.resource, (boolean)true);
        while (it.hasNext()) {
            eobject = (EObject)it.next();
            if (eobject instanceof TraceDiff) {
                this.traceDiff = (TraceDiff)eobject;
                for (EObject participant : this.traceDiff.getParticipants()) {
                    this.insertTraces(participant);
                }
            }
            this.insertTraces(eobject);
        }
        for (EObject eObject : this.backward.keySet()) {
            if (this.forward.get(this.backward.get(eObject)) != eObject || !this.rows.remove(eObject)) continue;
            System.err.println("Removed " + eObject);
        }
        it = EcoreUtil.getAllContents((Resource)this.resource, (boolean)true);
        while (it.hasNext()) {
            eobject = (EObject)it.next();
            if (eobject instanceof TraceDiff) {
                this.traceDiff = (TraceDiff)eobject;
                for (EObject participant : this.traceDiff.getParticipants()) {
                    this.addErrors(participant);
                }
            }
            this.addErrors(eobject);
        }
    }

    private void insertTraces(EObject eObject) {
        Traces traces;
        if (eObject instanceof Trace) {
            Trace trace = (Trace)eObject;
            EObject lastSource = null;
            Traces traces2 = this.getTraceContainer((EObject)trace);
            for (EObject source : trace.getSource()) {
                this.goForward(trace, this.traceDiff, this.rows, lastSource != null ? lastSource : source, lastSource != null ? source : lastSource);
                lastSource = source;
                if (traces2 == null) continue;
                this.modelOfElement.put(source, traces2.getSourceModel());
            }
            for (EObject target : trace.getTarget()) {
                this.goForward(trace, this.traceDiff, this.rows, lastSource, target);
                if (traces2 == null) continue;
                this.modelOfElement.put(target, traces2.getTargetModel());
            }
        }
        if (eObject instanceof Traces && (traces = (Traces)eObject).getSourceModel() != null) {
            this.sourceModels.add(traces.getSourceModel());
            this.targetModels.add(traces.getTargetModel());
        }
    }

    public Traces getTraceContainer(EObject trace) {
        Traces traces = null;
        EObject parent = trace.eContainer();
        while (parent != null) {
            if (parent instanceof Traces) {
                traces = (Traces)parent;
                break;
            }
            parent = parent.eContainer();
        }
        return traces;
    }

    private void addErrors(EObject eobject) {
        if (eobject instanceof LogEntry) {
            LogEntry logEntry = (LogEntry)eobject;
            for (EObject eo : logEntry.getParticipants()) {
                List<LogEntry> existing = this.errors.get(eo);
                if (existing == null) {
                    existing = new ArrayList<LogEntry>();
                    this.errors.put(eo, existing);
                }
                existing.add(logEntry);
                this.errorsRev.put(logEntry, eo);
            }
            if (this.traceDiff != null) {
                this.diffOfElement.put((EObject)logEntry, this.traceDiff);
            }
        }
    }

    public void goForward(Trace trace, TraceDiff diff, List<Object> elements, EObject source, EObject target) {
        if (source != null) {
            this.traced.add(source);
        }
        if (target != null) {
            this.traced.add(target);
        }
        if (diff != null && !this.diffOfElement.containsKey(source)) {
            this.diffOfElement.put(source, diff);
        }
        if (trace != null && !this.diffOfElement.containsKey(source)) {
            this.traceOfElement.put(source, trace);
        }
        if (target == null) {
            if (this.backward.get(source) == null) {
                if (!elements.contains(source)) {
                    elements.add(source);
                }
                this.backward.put(source, null);
            }
            return;
        }
        if (this.forward.get(source) != null) {
            if (this.backward.get(target) == null) {
                if (!elements.contains(target)) {
                    elements.add(target);
                }
                this.backward.put(target, source);
            } else {
                System.err.println("Cannot insert trace link!");
            }
            return;
        }
        this.forward.put(source, target);
        if (this.backward.get(source) == null) {
            if (!elements.contains(source)) {
                elements.add(source);
            }
            this.backward.put(source, null);
        }
        if (this.backward.get(target) == null) {
            elements.remove(target);
            this.backward.put(target, source);
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public <T> T findType(Class<T> cls, Object element) {
        T result = this.findTypeRightward(cls, element = TraceabilityViewer.getRedirectedElement(element));
        if (result == null) {
            result = this.findTypeLeftward(cls, element);
        }
        return result;
    }

    <T> T findTypeLeftward(Class<T> cls, Object element) {
        Object result = element;
        while (result != null) {
            if (cls.isInstance(result)) {
                return (T)result;
            }
            result = this.backward.get(result);
        }
        return null;
    }

    <T> T findTypeRightward(Class<T> cls, Object element) {
        Object result = element;
        while (result != null) {
            if (cls.isInstance(result)) {
                return (T)result;
            }
            result = this.forward.get(result);
        }
        return null;
    }

    public EObject findModel(EObject model, EObject element) {
        EObject result = this.findModelRightward(model, element);
        if (result == null) {
            result = this.findModelLeftward(model, element);
        }
        return result;
    }

    EObject findModelLeftward(EObject model, EObject element) {
        EObject result = element;
        while (result != null) {
            if (model == this.modelOfElement.get(result)) {
                return result;
            }
            result = this.backward.get(result);
        }
        return null;
    }

    EObject findModelRightward(EObject model, EObject element) {
        EObject result = element;
        while (result != null) {
            if (model == this.modelOfElement.get(result)) {
                return result;
            }
            result = this.forward.get(result);
        }
        return null;
    }

    public List<LogEntry> getErrors(Object element) {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        while (element != null) {
            List<LogEntry> error = this.errors.get(element);
            if (error != null) {
                for (LogEntry entry : error) {
                    TraceDiff diff;
                    if (!this.diffOfElement.isEmpty() && (diff = this.getTraceDiff((EObject)entry)) != null && diff.getParticipants().size() != 1 || result.contains(entry)) continue;
                    result.add(entry);
                }
            }
            element = this.forward.get(element);
        }
        return result;
    }

    public Trace getAnyTrace(EObject eObject) {
        TraceDiff diff;
        Trace trace = this.getTrace(eObject);
        if (trace == null && (diff = this.getTraceDiff(eObject)) != null) {
            for (EObject p : diff.getParticipants()) {
                if (!(p instanceof Trace) || !TraceabilityUtils.getProjectName((EObject)p).contains(".model")) continue;
                trace = (Trace)p;
            }
        }
        return trace;
    }

    public TraceDiff getTraceDiff(EObject cellData) {
        return this.diffOfElement.get(cellData);
    }

    public Trace getTrace(Object cellData) {
        return this.traceOfElement.get(cellData);
    }

    public LogEntry getError(Object element) {
        LogEntry result = null;
        for (LogEntry error : this.getErrors(element)) {
            if (result != null && result.getSeverity() <= error.getSeverity()) continue;
            result = error;
        }
        return result;
    }
}

