/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.actions;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CommandAction;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.common.ui.util.AdapterFactoryManager;
import org.eclipse.mdht.uml.common.ui.util.EditingDomainUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.common.edit.provider.IItemQualifiedTextProvider;

public class UMLCommandAction
extends CommandAction
implements IObjectActionDelegate {
    private ILabelProvider labelProvider = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        ISelection unwrappedSelection = null;
        if (selection instanceof IStructuredSelection) {
            ArrayList<EObject> unwrapped = new ArrayList<EObject>();
            for (Object element : (IStructuredSelection)selection) {
                EObject eObject = null;
                if (element instanceof IAdaptable) {
                    eObject = (EObject)((IAdaptable)element).getAdapter(View.class);
                    if (eObject == null) {
                        eObject = (EObject)((IAdaptable)element).getAdapter(EObject.class);
                    }
                } else if (element instanceof EObject) {
                    eObject = (EObject)element;
                }
                if (View.class.isInstance(eObject)) {
                    eObject = ((View)eObject).getElement();
                }
                if (eObject == null) continue;
                unwrapped.add(eObject);
            }
            unwrappedSelection = new StructuredSelection(unwrapped);
            if (this.editingDomain == null) {
                this.editingDomain = EditingDomainUtil.getEditingDomain(unwrapped);
            }
        } else {
            unwrappedSelection = selection;
        }
        super.selectionChanged(action, unwrappedSelection);
    }

    protected UMLCommandAction() {
    }

    protected ILabelProvider getLabelProvider() {
        if (this.labelProvider == null && this.getAdapterFactory() != null) {
            this.labelProvider = new AdapterFactoryLabelProvider(this.getAdapterFactory()){

                public String getColumnText(Object object, int columnIndex) {
                    IItemQualifiedTextProvider itemQualifiedTextProvider = (IItemQualifiedTextProvider)this.adapterFactory.adapt(object, IItemQualifiedTextProvider.class);
                    return itemQualifiedTextProvider != null ? itemQualifiedTextProvider.getQualifiedText(object) : super.getColumnText(object, columnIndex);
                }

                public String getText(Object object) {
                    IItemQualifiedTextProvider itemQualifiedTextProvider = (IItemQualifiedTextProvider)this.adapterFactory.adapt(object, IItemQualifiedTextProvider.class);
                    return itemQualifiedTextProvider != null ? itemQualifiedTextProvider.getQualifiedText(object) : super.getText(object);
                }
            };
        }
        return this.labelProvider;
    }

    protected AdapterFactory getAdapterFactory() {
        return this.editingDomain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)this.editingDomain).getAdapterFactory() : AdapterFactoryManager.getAdapterFactory();
    }

    public void setActiveEditor(IAction action, IEditorPart editorPart) {
        super.setActiveEditor(action, editorPart);
    }

    protected void refreshViewer() {
        if (this.workbenchPart instanceof IViewerProvider) {
            ((IViewerProvider)this.workbenchPart).getViewer().refresh();
        }
    }

    protected class RefreshingChangeCommand
    extends ChangeCommand {
        public RefreshingChangeCommand(EditingDomain editingDomain, Runnable runnable, String label) {
            super(editingDomain, runnable, label);
        }

        public void execute() {
            super.execute();
            UMLCommandAction.this.refreshViewer();
        }

        public void undo() {
            super.undo();
            UMLCommandAction.this.refreshViewer();
        }

        public void redo() {
            super.redo();
            UMLCommandAction.this.refreshViewer();
        }
    }

    protected class TextComparator<T>
    implements Comparator<T> {
        protected TextComparator() {
        }

        @Override
        public int compare(T t1, T t2) {
            return CommonPlugin.INSTANCE.getComparator().compare(UMLCommandAction.this.getLabelProvider().getText(t1), UMLCommandAction.this.getLabelProvider().getText(t2));
        }
    }
}

