/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.dita.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mdht.dita.ui.util.DitaUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;

public class PublishDitaHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (event.getParameter("org.eclipse.dita.ui.parameter.target") != null) {
            try {
                if (event.getApplicationContext() instanceof IEvaluationContext) {
                    IEvaluationContext evaluationContext = (IEvaluationContext)event.getApplicationContext();
                    for (Object selection : (Collection)evaluationContext.getDefaultVariable()) {
                        if (!(selection instanceof IFile)) continue;
                        IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
                        PublishThread publishThread = new PublishThread((IFile)selection, event.getParameter("org.eclipse.dita.ui.parameter.target"));
                        iProgressService.busyCursorWhile((IRunnableWithProgress)publishThread);
                    }
                }
            }
            catch (Exception e) {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                e.printStackTrace();
                MessageDialog.openError((Shell)window.getShell(), (String)"DITA-OT Publishing", (String)("Error" + e.getMessage()));
            }
        } else {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
            MessageDialog.openError((Shell)window.getShell(), (String)"DITA-OT Publishing", (String)"No Publishing Target");
        }
        return null;
    }

    private static class PublishThread
    implements IRunnableWithProgress {
        IFile ditaMap;
        String targets;

        public PublishThread(IFile ditaMap, String targets) {
            this.ditaMap = ditaMap;
            this.targets = targets;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("DITA Publishing " + this.ditaMap.getName(), (StringUtils.countMatches((String)this.targets, (String)",") + 1) * 300);
            String[] stringArray = this.targets.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    String target = stringArray[n2];
                    try {
                        monitor.subTask("Publish As " + target);
                        ILaunch publishLaunch = DitaUtil.publish(this.ditaMap, target);
                        int workcounter = 300;
                        while (!publishLaunch.isTerminated() && !monitor.isCanceled()) {
                            Thread.currentThread();
                            Thread.sleep(100L);
                            monitor.worked(1);
                            --workcounter;
                        }
                        monitor.worked(workcounter > 0 ? workcounter : 0);
                        if (monitor.isCanceled()) {
                            publishLaunch.terminate();
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++n2;
            }
            if (!monitor.isCanceled() && this.ditaMap.getProject() != null) {
                try {
                    this.ditaMap.getProject().refreshLocal(2, monitor);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }
}

