/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.ui.search;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.common.UmlPlugin;
import org.eclipse.mdht.uml.common.ui.search.IElementFilter;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ModelSearch {
    private ModelSearch() {
    }

    private static boolean implementsInterface(Object object, java.lang.Class<?> anInterface) {
        java.lang.Class<?>[] interfaces = object.getClass().getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i] == anInterface) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List<EObject> findStereotypeApplications(ResourceSet resourceSet, Stereotype stereotype) {
        ArrayList<EObject> elementList = new ArrayList<EObject>();
        for (Resource resource : resourceSet.getResources()) {
            String uri = resource.getURI().toString();
            if (uri.equals("pathmap://UML_METAMODELS/UML.metamodel.uml") || uri.equals("pathmap://UML_METAMODELS/Ecore.metamodel.uml")) continue;
            elementList.addAll(ModelSearch.findStereotypeApplications(resource, stereotype));
        }
        return elementList;
    }

    public static List<EObject> findStereotypeApplications(Resource resource, Stereotype stereotype) {
        ArrayList<EObject> elementList = new ArrayList<EObject>();
        for (EObject eObject : resource.getContents()) {
            if (!stereotype.equals(UMLUtil.getStereotype((EObject)eObject))) continue;
            elementList.add(eObject);
        }
        return elementList;
    }

    public static List<Element> findAllOf(ResourceSet resourceSet, IElementFilter filter) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        TreeIterator iterator = resourceSet.getAllContents();
        while (iterator != null && iterator.hasNext()) {
            Object element = iterator.next();
            if (Resource.class.isInstance(element)) continue;
            if (ProfileApplication.class.isInstance(element)) {
                iterator.prune();
                continue;
            }
            if (Profile.class.isInstance(element)) {
                iterator.prune();
                continue;
            }
            if (EAnnotation.class.isInstance(element)) {
                iterator.prune();
                continue;
            }
            if (Package.class.isInstance(element)) {
                if ("pathmap://UML_METAMODELS/UML.metamodel.uml".equals(((Package)element).eResource().getURI().toString())) {
                    iterator.prune();
                    continue;
                }
                if ("pathmap://UML_METAMODELS/Ecore.metamodel.uml".equals(((Package)element).eResource().getURI().toString())) {
                    iterator.prune();
                    continue;
                }
                if (!filter.accept((Element)element)) continue;
                elementList.add((Element)element);
                continue;
            }
            if (element instanceof Element && filter.accept((Element)element)) {
                elementList.add((Element)element);
                continue;
            }
            if (Package.class.isInstance(element)) continue;
            iterator.prune();
        }
        return elementList;
    }

    public static List<Element> findAllOf(Package umlPackage, IElementFilter filter) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        TreeIterator iterator = umlPackage.eAllContents();
        while (iterator != null && iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (element instanceof ElementImport) {
                if ("pathmap://UML_METAMODELS/UML.metamodel.uml".equals((element = ((ElementImport)element).getImportedElement()).eResource().getURI().toString())) {
                    continue;
                }
            } else if (element instanceof PackageImport) {
                Package importedPackage = ((PackageImport)element).getImportedPackage();
                if (importedPackage == null || importedPackage.eIsProxy() || "pathmap://UML_METAMODELS/UML.metamodel.uml".equals(importedPackage.eResource().getURI().toString())) continue;
                element = importedPackage;
                elementList.addAll(ModelSearch.findAllOf(importedPackage, filter));
            }
            if (element instanceof Element && filter.accept((Element)element)) {
                elementList.add((Element)element);
                continue;
            }
            if (Package.class.isInstance(element)) continue;
            iterator.prune();
        }
        return elementList;
    }

    public static List<Element> findAllOf(Package umlPackage, java.lang.Class<?> type) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        TreeIterator iterator = umlPackage.eAllContents();
        while (iterator != null && iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (element instanceof ElementImport) {
                if (!"pathmap://UML_METAMODELS/UML.metamodel.uml".equals((element = ((ElementImport)element).getImportedElement()).eResource().getURI().toString())) {
                    elementList.add((Element)element);
                }
            } else if (element instanceof PackageImport) {
                Package importedPackage = ((PackageImport)element).getImportedPackage();
                if ("pathmap://UML_METAMODELS/UML.metamodel.uml".equals(importedPackage.eResource().getURI().toString())) continue;
                elementList.addAll(ModelSearch.findAllOf(importedPackage, type));
                continue;
            }
            if (element instanceof Element && ModelSearch.implementsInterface(element, type)) {
                elementList.add((Element)element);
                continue;
            }
            if (Package.class.isInstance(element)) continue;
            iterator.prune();
        }
        return elementList;
    }

    public static List<Element> findAllOf(Resource resource, java.lang.Class<?> type) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        TreeIterator iterator = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (iterator != null && iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (type.isInstance(element) && element instanceof Element) {
                elementList.add((Element)element);
                continue;
            }
            if (Package.class.isInstance(element)) continue;
            iterator.prune();
        }
        return elementList;
    }

    public static List<Class> findUMLMetaclasses(ResourceSet resourceSet) {
        ArrayList<Class> classList = new ArrayList<Class>();
        Resource umlMetamodel = resourceSet.getResource(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), true);
        if (umlMetamodel != null) {
            TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)umlMetamodel, (boolean)true);
            while (iterator != null && iterator.hasNext()) {
                Object element = iterator.next();
                if (!(element instanceof Class)) continue;
                classList.add((Class)element);
            }
        }
        return classList;
    }

    public static List<Element> findAllOf(ResourceSet resourceSetold, java.lang.Class<?> type) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        UmlPlugin.computeModelPathMapExtensions();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        Path model = new Path("model");
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && project.exists((IPath)model)) {
                IFile plugin = project.getFile("plugin.xml");
                IFolder folder = project.getFolder((IPath)model);
                try {
                    IResource[] iResourceArray = folder.members();
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource resource = iResourceArray[n4];
                        if (resource.getName().endsWith(".uml") && !resource.getName().contains("_Ecore")) {
                            URI pathMap;
                            URI modelFile = null;
                            modelFile = plugin.exists() ? ((pathMap = UmlPlugin.getPathMap((InputStream)plugin.getContents())) != null ? pathMap.appendSegment(resource.getName()) : URI.createFileURI((String)project.getFolder((IPath)model).getFile(resource.getName()).getRawLocation().toOSString())) : URI.createFileURI((String)project.getFolder((IPath)model).getFile(resource.getName()).getRawLocation().toOSString());
                            TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)resourceSet.getResource(modelFile, true), (boolean)true);
                            while (iterator != null && iterator.hasNext()) {
                                Object element = iterator.next();
                                if (Resource.class.isInstance(element)) continue;
                                if (ProfileApplication.class.isInstance(element)) {
                                    iterator.prune();
                                    continue;
                                }
                                if (Profile.class.isInstance(element) && Stereotype.class != type) {
                                    iterator.prune();
                                    continue;
                                }
                                if (EAnnotation.class.isInstance(element)) {
                                    iterator.prune();
                                    continue;
                                }
                                if (Package.class.isInstance(element)) {
                                    if ("pathmap://UML_METAMODELS/UML.metamodel.uml".equals(((Package)element).eResource().getURI().toString())) {
                                        iterator.prune();
                                        continue;
                                    }
                                    if ("pathmap://UML_METAMODELS/Ecore.metamodel.uml".equals(((Package)element).eResource().getURI().toString())) {
                                        iterator.prune();
                                        continue;
                                    }
                                }
                                if (type.isInstance(element) && element instanceof Element) {
                                    elementList.add((Element)element);
                                    continue;
                                }
                                if (Package.class.isInstance(element)) continue;
                                iterator.prune();
                            }
                        }
                        ++n4;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return elementList;
    }
}

