/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.logging.Logger;
import org.eclipse.microprofile.lra.LRAResponse;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;

@ApplicationScoped
@Path(value="lraresource-cancelon")
public class LraCancelOnResource {
    private static final Logger LOGGER = Logger.getLogger(LraCancelOnResource.class.getName());
    public static final String LRA_CANCEL_ON_RESOURCE_PATH = "lraresource-cancelon";
    @Inject
    private LRAMetricService lraMetricService;
    public static final String CANCEL_ON_FAMILY_DEFAULT_4XX = "cancelOnFamilyDefault4xx";
    public static final String CANCEL_ON_FAMILY_DEFAULT_5XX = "cancelOnFamilyDefault5xx";
    public static final String CANCEL_ON_FAMILY_3XX = "cancelOnFamily3xx";
    public static final String CANCEL_ON_301 = "cancelOn301";
    public static final String NOT_CANCEL_ON_FAMILY_5XX = "notCancelOnFamily5xx";
    public static final String CANCEL_FROM_REMOTE_CALL = "cancelFromRemoteCall";

    @GET
    @Path(value="cancelOnFamilyDefault4xx")
    @LRA(value=LRA.Type.REQUIRED)
    public Response cancelOnFamilyDefault4xx(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)lraId).build();
    }

    @GET
    @Path(value="cancelOnFamilyDefault5xx")
    @LRA(value=LRA.Type.REQUIRED)
    public Response cancelOnFamilyDefault5xx(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)lraId).build();
    }

    @GET
    @Path(value="cancelOnFamily3xx")
    @LRA(value=LRA.Type.REQUIRES_NEW, cancelOnFamily={Response.Status.Family.REDIRECTION})
    public Response cancelOnFamily3xx(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)lraId).build();
    }

    @GET
    @Path(value="cancelOn301")
    @LRA(value=LRA.Type.REQUIRES_NEW, cancelOn={Response.Status.MOVED_PERMANENTLY})
    public Response cancelOn301(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.status((Response.Status)Response.Status.MOVED_PERMANENTLY).entity((Object)lraId).build();
    }

    @GET
    @Path(value="notCancelOnFamily5xx")
    @LRA(value=LRA.Type.REQUIRES_NEW, cancelOnFamily={Response.Status.Family.CLIENT_ERROR})
    public Response notCancelOnFamily5xx(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)lraId).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="cancelFromRemoteCall")
    @LRA(value=LRA.Type.REQUIRES_NEW)
    public Response cancelFromRemoteCall(@HeaderParam(value="Long-Running-Action") URI lraId, @Context UriInfo uriInfo) {
        try (Client client = ClientBuilder.newClient();){
            Response response = client.target(uriInfo.getBaseUri()).path(LRA_CANCEL_ON_RESOURCE_PATH).path(CANCEL_ON_FAMILY_DEFAULT_5XX).request().get();
            assert (response.getStatus() == 500);
        }
        return Response.ok((Object)lraId).build();
    }

    @PUT
    @Path(value="/complete")
    @Complete
    public Response completeWork(@HeaderParam(value="Long-Running-Action") URI lraId) {
        if (lraId == null) {
            throw new NullPointerException("lraId can't be null as it should be invoked with the context");
        }
        this.lraMetricService.incrementMetric(LRAMetricType.Completed, lraId, LraCancelOnResource.class);
        LOGGER.info(String.format("LRA id '%s' was completed", lraId.toASCIIString()));
        return LRAResponse.completed();
    }

    @PUT
    @Path(value="/compensate")
    @Compensate
    public Response compensateWork(@HeaderParam(value="Long-Running-Action") URI lraId) {
        if (lraId == null) {
            throw new NullPointerException("lraId can't be null as it should be invoked with the context");
        }
        this.lraMetricService.incrementMetric(LRAMetricType.Compensated, lraId, LraCancelOnResource.class);
        LOGGER.info(String.format("LRA id '%s' was compensated", lraId.toASCIIString()));
        return LRAResponse.compensated();
    }
}

